/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.avatar.EntityAvatarData;
import net.blancworks.figura.avatar.LocalAvatarData;
import net.blancworks.figura.avatar.LocalAvatarManager;
import net.blancworks.figura.config.ConfigManager;
import net.blancworks.figura.gui.FiguraToast;
import net.blancworks.figura.lua.FiguraLuaManager;
import net.blancworks.figura.lua.api.FiguraAPI;
import net.blancworks.figura.lua.api.sound.FiguraSoundManager;
import net.blancworks.figura.network.IFiguraNetwork;
import net.blancworks.figura.network.NewFiguraNetworkManager;
import net.blancworks.figura.trust.PlayerTrustManager;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.impl.client.keybinding.KeyBindingRegistryImpl;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1160;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3675;
import net.minecraft.class_368;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FiguraMod
implements ClientModInitializer {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final class_2960 FIGURA_FONT = new class_2960("figura", "default");
    public static final UnaryOperator<class_2583> ACCENT_COLOR = FiguraMod::getAccentColor;
    public static final class_1160 MAYA_BLUE = new class_1160(0.05f, 0.88f, 0.81f);
    public static final class_1160 FRAN_PINK = new class_1160(1.0f, 0.45f, 0.72f);
    public static final String MOD_VERSION = ((ModContainer)FabricLoader.getInstance().getModContainer("figura").get()).getMetadata().getVersion().getFriendlyString();
    public static final boolean IS_CHEESE = LocalDate.now().getDayOfMonth() == 1 && LocalDate.now().getMonthValue() == 4;
    public static class_2487 cheese;
    public static final ConfigManager.ConfigKeyBind ACTION_WHEEL_BUTTON;
    public static final ConfigManager.ConfigKeyBind PLAYER_POPUP_BUTTON;
    public static final ConfigManager.ConfigKeyBind PANIC_BUTTON;
    public static int ticksElapsed;
    public static final String GRADLE_PROPERTIES_LINK = "https://raw.githubusercontent.com/Blancworks/Figura/1.18/gradle.properties";
    public static String latestVersion;
    public static int latestVersionStatus;
    private static CompletableFuture<?> globalLoadTask;
    public static IFiguraNetwork networkManager;
    private static NewFiguraNetworkManager newNetworkManager;
    public static final List<FiguraAPI> CUSTOM_APIS;
    public static final List<UUID> VIP;

    public void onInitializeClient() {
        FabricLoader.getInstance().getEntrypointContainers("figura", FiguraAPI.class).forEach(entrypoint -> {
            ModMetadata metadata = entrypoint.getProvider().getMetadata();
            String modId = metadata.getId();
            try {
                CUSTOM_APIS.add((FiguraAPI)entrypoint.getEntrypoint());
            }
            catch (Exception e) {
                LOGGER.error("Failed to load entrypoint of mod {}", (Object)modId, (Object)e);
            }
        });
        ConfigManager.initialize();
        FiguraLuaManager.initialize();
        PlayerTrustManager.init();
        LocalAvatarManager.init();
        ACTION_WHEEL_BUTTON.method_1422(class_3675.class_307.field_1668.method_1447(((Integer)ConfigManager.Config.ACTION_WHEEL_BUTTON.value).intValue()));
        PLAYER_POPUP_BUTTON.method_1422(class_3675.class_307.field_1668.method_1447(((Integer)ConfigManager.Config.PLAYER_POPUP_BUTTON.value).intValue()));
        PANIC_BUTTON.method_1422(class_3675.class_307.field_1668.method_1447(((Integer)ConfigManager.Config.PANIC_BUTTON.value).intValue()));
        KeyBindingRegistryImpl.registerKeyBinding((class_304)ACTION_WHEEL_BUTTON);
        KeyBindingRegistryImpl.registerKeyBinding((class_304)PLAYER_POPUP_BUTTON);
        KeyBindingRegistryImpl.registerKeyBinding((class_304)PANIC_BUTTON);
        newNetworkManager = new NewFiguraNetworkManager();
        networkManager = newNetworkManager;
        ClientTickEvents.END_CLIENT_TICK.register(FiguraMod::ClientEndTick);
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            LocalAvatarData data = AvatarDataManager.localPlayer;
            if (data != null && data.model != null && !context.camera().method_19333()) {
                data.model.renderFirstPersonWorldParts(context.matrixStack(), context.camera(), context.tickDelta());
            }
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(v -> networkManager.onClose());
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("figura", "reloadtextures");
            }

            public void method_14491(class_3300 manager) {
                AvatarDataManager.reloadAssets();
                EntityAvatarData.loadCemModels();
                LocalAvatarManager.loadResourceAvatars(manager);
                try {
                    cheese = class_2507.method_10629((InputStream)((class_3298)manager.method_14486(new class_2960("figura", "cheese/cheese.moon")).get()).method_14482());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        FiguraMod.getModContentDirectory();
        FiguraMod.getLatestModVersion();
    }

    public static void ClientEndTick(class_310 client) {
        try {
            AvatarDataManager.tick();
            FiguraSoundManager.tick();
            networkManager = newNetworkManager;
            if (networkManager != null) {
                networkManager.tickNetwork();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ++ticksElapsed;
    }

    public static Path getModContentDirectory() {
        String userPath = (String)ConfigManager.Config.MODEL_FOLDER_PATH.value;
        try {
            Path p;
            Path path = p = userPath.isEmpty() ? FiguraMod.getDefaultDirectory() : Path.of(userPath, new String[0]);
            if (!Files.exists(p, new LinkOption[0])) {
                Files.createDirectories(p, new FileAttribute[0]);
            }
            return p;
        }
        catch (Exception e) {
            e.printStackTrace();
            return FiguraMod.getDefaultDirectory();
        }
    }

    public static Path getDefaultDirectory() {
        Path p = FabricLoader.getInstance().getGameDir().normalize().resolve("figura");
        try {
            if (!Files.exists(p, new LinkOption[0])) {
                Files.createDirectories(p, new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    public static CompletableFuture<?> doTask(Runnable toRun) {
        try {
            return FiguraMod.doTask(toRun, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static CompletableFuture<?> doTask(Runnable toRun, @Nullable Runnable onFinished) {
        globalLoadTask = globalLoadTask == null || globalLoadTask.isDone() ? CompletableFuture.runAsync(() -> FiguraMod.runTask(toRun, onFinished)) : globalLoadTask.thenRunAsync(() -> FiguraMod.runTask(toRun, onFinished));
        return globalLoadTask;
    }

    private static void runTask(Runnable toRun, @Nullable Runnable onFinished) {
        toRun.run();
        if (onFinished != null) {
            onFinished.run();
        }
    }

    public static void sendToast(Object title, Object message) {
        class_2561 m;
        class_2561 t;
        class_2561 text = title instanceof class_2561 ? (t = (class_2561)title) : class_5250.method_43477((class_7417)new class_2588(title.toString()));
        class_2561 text2 = message instanceof class_2561 ? (m = (class_2561)message) : class_5250.method_43477((class_7417)new class_2588(message.toString()));
        class_310.method_1551().method_1566().method_2000();
        class_310.method_1551().method_1566().method_1999((class_368)new FiguraToast(text, text2));
    }

    public static void getLatestModVersion() {
        if ((Integer)ConfigManager.Config.RELEASE_CHANNEL.value == 2) {
            latestVersionStatus = 0;
            return;
        }
        FiguraMod.doTask(() -> {
            try {
                String line;
                StringBuilder output = new StringBuilder();
                URLConnection connection = new URL(GRADLE_PROPERTIES_LINK).openConnection();
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    output.append(line).append("\n");
                }
                reader.close();
                String versionFileContents = output.toString();
                int versionPos = versionFileContents.indexOf("mod_version");
                int nextLinePos = versionFileContents.indexOf("\n", versionPos);
                latestVersion = versionFileContents.substring(versionPos, nextLinePos).replaceAll(" ", "").substring(12);
                SemanticVersion temp = SemanticVersion.parse((String)latestVersion);
                if (temp.getPrereleaseKey().isPresent() && (Integer)ConfigManager.Config.RELEASE_CHANNEL.value == 1) {
                    latestVersion = temp.getVersionComponent(0) + "." + temp.getVersionComponent(1) + "." + (temp.getVersionComponent(2) - 1);
                }
                SemanticVersion latest = SemanticVersion.parse((String)latestVersion);
                SemanticVersion current = SemanticVersion.parse((String)MOD_VERSION);
                latestVersionStatus = current.compareTo((Object)latest);
            }
            catch (Exception e) {
                latestVersionStatus = 0;
                e.printStackTrace();
            }
        });
    }

    public static class_2583 getAccentColor(class_2583 style) {
        return style.method_36139(((Integer)ConfigManager.Config.ACCENT_COLOR.value).intValue());
    }

    static {
        ACTION_WHEEL_BUTTON = new ConfigManager.ConfigKeyBind("figura.config.action_wheel_button", 66, "figura", ConfigManager.Config.ACTION_WHEEL_BUTTON);
        PLAYER_POPUP_BUTTON = new ConfigManager.ConfigKeyBind("figura.config.player_popup_button", 82, "figura", ConfigManager.Config.PLAYER_POPUP_BUTTON);
        PANIC_BUTTON = new ConfigManager.ConfigKeyBind("figura.config.panic_button", -1, "figura", ConfigManager.Config.PANIC_BUTTON);
        latestVersionStatus = 0;
        CUSTOM_APIS = new ArrayList<FiguraAPI>();
        VIP = List.of(UUID.fromString("aa0e3391-e497-4e8e-8afe-b69dfaa46afa"), UUID.fromString("66a6c5c4-963b-4b73-a0d9-162faedd8b7f"), UUID.fromString("45361fcf-f188-46de-ae96-43d89afd6658"), UUID.fromString("d47ce8af-b942-47de-8790-f602241531e3"), UUID.fromString("0d04770a-9482-4a39-8011-fcbb7c99b8e1"), UUID.fromString("10c4a29c-78fd-428c-bf51-f70b93e2ab45"), UUID.fromString("50de3aff-e8ef-4d55-9092-f96b7b40de7a"));
    }
}

