/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.loot.table;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.loot.v1.event.LootTableLoadingCallback;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.impl.loot.table.BufferingLootTableBuilder;
import net.minecraft.class_2960;
import net.minecraft.class_52;

public final class LootTablesV1Init
implements ModInitializer {
    private static final ThreadLocal<Map<class_2960, BufferingLootTableBuilder>> BUFFERS = ThreadLocal.withInitial(HashMap::new);

    public void onInitialize() {
        LootTableEvents.REPLACE.register((resourceManager, lootManager, id, original, source) -> {
            BufferingLootTableBuilder builder = new BufferingLootTableBuilder();
            builder.init(original);
            BUFFERS.get().put(id, builder);
            class_52[] result = new class_52[1];
            ((LootTableLoadingCallback)LootTableLoadingCallback.EVENT.invoker()).onLootTableLoading(resourceManager, lootManager, id, builder, table -> {
                result[0] = table;
            });
            return result[0];
        });
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            Map<class_2960, BufferingLootTableBuilder> buffers = BUFFERS.get();
            if (buffers.containsKey(id)) {
                try {
                    buffers.get(id).applyTo(tableBuilder);
                }
                finally {
                    buffers.remove(id);
                    if (buffers.isEmpty()) {
                        BUFFERS.remove();
                    }
                }
            }
        });
    }
}

