/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.metadata;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.lambdaurora.lambdabettergrass.LambdaBetterGrass;
import dev.lambdaurora.spruceui.util.Nameable;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.minecraft.class_1100;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_4696;
import org.jetbrains.annotations.Nullable;

public class LBGLayerType
implements Nameable {
    private static final Map<String, class_1921> NAMED_RENDER_LAYERS = new ImmutableMap.Builder().put((Object)"solid", (Object)class_1921.method_23577()).put((Object)"cutout", (Object)class_1921.method_23581()).put((Object)"cutout_mipped", (Object)class_1921.method_23579()).put((Object)"translucent", (Object)class_1921.method_23583()).put((Object)"tripwire", (Object)class_1921.method_29997()).build();
    private static final List<LBGLayerType> LAYER_TYPES = new ArrayList<LBGLayerType>();
    public final class_2960 id;
    public final class_2248 block;
    public final class_2960 modelId;
    private final String name;
    private final List<class_1921> acceptedRenderLayers;
    private final class_1921 defaultRenderLayer;
    private final Reference2ReferenceMap<class_2248, class_1921> oldRenderLayers = new Reference2ReferenceOpenHashMap();

    public LBGLayerType(class_2960 id, class_2248 block, class_2960 modelId, List<class_1921> acceptedRenderLayers, class_1921 defaultRenderLayer) {
        this.id = id;
        this.block = block;
        this.modelId = modelId;
        this.acceptedRenderLayers = acceptedRenderLayers;
        this.defaultRenderLayer = defaultRenderLayer;
        String[] path = this.id.method_12832().split("/");
        this.name = path[path.length - 1];
    }

    public class_1100 getLayerModel(Function<class_2960, class_1100> modelGetter) {
        return modelGetter.apply(this.modelId);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasSpecialRenderLayer() {
        return this.defaultRenderLayer != null;
    }

    public void apply(class_2248 block) {
        if (!this.hasSpecialRenderLayer()) {
            return;
        }
        class_1921 currentLayer = class_4696.method_23679((class_2680)block.method_9564());
        if (currentLayer != this.defaultRenderLayer && !this.acceptedRenderLayers.contains(currentLayer)) {
            this.oldRenderLayers.putIfAbsent((Object)block, (Object)currentLayer);
            BlockRenderLayerMap.INSTANCE.putBlock(block, this.defaultRenderLayer);
        }
    }

    private void resetSelf() {
        this.oldRenderLayers.forEach((arg_0, arg_1) -> ((BlockRenderLayerMap)BlockRenderLayerMap.INSTANCE).putBlock(arg_0, arg_1));
    }

    public static void reset() {
        LAYER_TYPES.forEach(LBGLayerType::resetSelf);
        LAYER_TYPES.clear();
    }

    public static void forEach(Consumer<LBGLayerType> consumer) {
        LAYER_TYPES.forEach(consumer);
    }

    @Nullable
    public static LBGLayerType fromName(String name) {
        for (LBGLayerType type : LAYER_TYPES) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return null;
    }

    public static void load(class_2960 resourceId, class_3298 resource) {
        class_2960 id = new class_2960(resourceId.method_12836(), resourceId.method_12832().replace(".json", ""));
        try (InputStreamReader reader = new InputStreamReader(resource.method_14482());){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            class_2960 affectId = new class_2960(json.get("block").getAsString());
            class_2248 block = (class_2248)class_2378.field_11146.method_10223(affectId);
            if (block == class_2246.field_10124) {
                return;
            }
            class_2960 modelId = new class_2960(json.get("model").getAsString());
            ReferenceArrayList acceptedRenderLayers = new ReferenceArrayList();
            class_1921 defaultRenderLayer = null;
            if (json.has("render_layer")) {
                JsonObject renderLayerData = json.getAsJsonObject("render_layer");
                JsonArray accepted = renderLayerData.getAsJsonArray("accepted");
                String defaultLayer = renderLayerData.get("default").getAsString();
                for (JsonElement el : accepted) {
                    String name = el.getAsString();
                    class_1921 layer = NAMED_RENDER_LAYERS.get(name);
                    if (layer != null) {
                        acceptedRenderLayers.add((Object)layer);
                        continue;
                    }
                    LambdaBetterGrass.get().warn("Failed to find accepted render layer \"" + name + "\" for LBG layer type \"" + id + "\".");
                }
                defaultRenderLayer = NAMED_RENDER_LAYERS.get(defaultLayer);
                if (defaultRenderLayer == null) {
                    LambdaBetterGrass.get().warn("Failed to find default render layer \"" + defaultLayer + "\" for LBG layer type \"" + id + "\".");
                }
            }
            LAYER_TYPES.add(new LBGLayerType(id, block, modelId, (List<class_1921>)acceptedRenderLayers, defaultRenderLayer));
        }
        catch (IOException | IllegalStateException e) {
            LambdaBetterGrass.get().warn("Failed to load layer type \"" + id + "\".");
        }
    }

    public String toString() {
        return "LBGLayerType{id=" + this.id + ", block=" + this.block + ", modelId=" + this.modelId + "}";
    }
}

