/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.metadata;

import com.google.gson.JsonObject;
import dev.lambdaurora.lambdabettergrass.LambdaBetterGrass;
import dev.lambdaurora.lambdabettergrass.metadata.LBGMetadata;
import dev.lambdaurora.lambdabettergrass.util.LBGTextureGenerator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1723;
import net.minecraft.class_2960;
import net.minecraft.class_4730;
import org.jetbrains.annotations.Nullable;

public class LBGLayer {
    private final LBGMetadata parentMetadata;
    public final int index;
    public final int colorIndex;
    private final class_2960 connectMask;
    private final class_2960 blendUpMask;
    private final class_2960 blendArchMask;
    private final class_2960 topTexture;
    private final class_2960 sideTexture;
    private class_4730 connectTexture;
    private class_4730 blendUpTexture;
    private class_4730 blendUpMirroredTexture;
    private class_4730 archTexture;
    private final Map<String, class_1058> bakedSprites = new Object2ObjectOpenHashMap();

    public LBGLayer(LBGMetadata metadata, JsonObject json) {
        this.parentMetadata = metadata;
        this.index = metadata.nextLayerIndex();
        this.colorIndex = json.has("color_index") ? json.get("color_index").getAsInt() : -1;
        class_1091 topTexture = class_1088.field_5374;
        class_1091 sideTexture = class_1088.field_5374;
        if (json.has("textures")) {
            JsonObject textures = json.getAsJsonObject("textures");
            if (textures.has("top")) {
                topTexture = new class_2960(textures.get("top").getAsString());
            }
            if (textures.has("side")) {
                sideTexture = new class_2960(textures.get("side").getAsString());
            }
            if (textures.has("overrides")) {
                JsonObject overrides = textures.getAsJsonObject("overrides");
                this.connectTexture = this.getOverridenTexture(overrides, "connect");
                this.blendUpTexture = this.getOverridenTexture(overrides, "blend_up");
                this.blendUpMirroredTexture = this.getOverridenTexture(overrides, "blend_up_m");
                this.archTexture = this.getOverridenTexture(overrides, "arch");
            }
        }
        this.topTexture = topTexture;
        this.sideTexture = sideTexture;
        class_2960 connectMask = LambdaBetterGrass.BETTER_GRASS_SIDE_CONNECT_MASK;
        class_2960 blendUpMask = LambdaBetterGrass.BETTER_GRASS_SIDE_BLEND_UP_MASK;
        class_2960 blendArchMask = LambdaBetterGrass.BETTER_GRASS_SIDE_ARCH_BLEND_MASK;
        if (json.has("masks")) {
            JsonObject mask = json.getAsJsonObject("masks");
            if (mask.has("connect")) {
                connectMask = new class_2960(mask.get("connect").getAsString() + ".png");
            }
            if (mask.has("blend_up")) {
                blendUpMask = new class_2960(mask.get("blend_up").getAsString() + ".png");
            }
            if (mask.has("arch")) {
                blendArchMask = new class_2960(mask.get("arch").getAsString() + ".png");
            }
        }
        this.connectMask = connectMask;
        this.blendUpMask = blendUpMask;
        this.blendArchMask = blendArchMask;
    }

    @Nullable
    private class_4730 getOverridenTexture(JsonObject overrides, String name) {
        if (overrides.has(name)) {
            class_4730 id = new class_4730(class_1723.field_21668, new class_2960(overrides.get(name).getAsString()));
            this.parentMetadata.textures.add(id);
            return id;
        }
        return null;
    }

    public void buildTextures() {
        class_1011 top = LBGTextureGenerator.getNativeImage(this.parentMetadata.resourceManager, LBGLayer.getTexturePath(this.topTexture));
        class_1011 side = LBGTextureGenerator.getNativeImage(this.parentMetadata.resourceManager, LBGLayer.getTexturePath(this.sideTexture));
        String[] path = this.parentMetadata.id.method_12832().split("/");
        String name = path.length == 0 ? "undefined" : path[path.length - 1];
        if (this.connectTexture == null) {
            class_1011 connectMask = LBGTextureGenerator.getNativeImage(this.parentMetadata.resourceManager, this.connectMask);
            this.connectTexture = LBGLayer.genTexture(name + "_" + this.index + "_connect", side, top, connectMask);
            this.parentMetadata.textures.add(this.connectTexture);
            connectMask.close();
        }
        if (this.blendUpTexture == null || this.blendUpMirroredTexture == null) {
            class_1011 blendUp = LBGTextureGenerator.getNativeImage(this.parentMetadata.resourceManager, this.blendUpMask);
            if (this.blendUpTexture == null) {
                this.blendUpTexture = LBGLayer.genTexture(name + "_" + this.index + "_blend_up", side, top, blendUp);
                this.parentMetadata.textures.add(this.blendUpTexture);
            }
            if (this.blendUpMirroredTexture == null) {
                class_1011 blendUpMirrored = LBGTextureGenerator.mirrorImage(blendUp);
                this.blendUpMirroredTexture = LBGLayer.genTexture(name + "_" + this.index + "_blend_up_m", side, top, blendUpMirrored);
                this.parentMetadata.textures.add(this.blendUpMirroredTexture);
                blendUpMirrored.close();
            }
            blendUp.close();
        }
        if (this.archTexture == null) {
            class_1011 archMask = LBGTextureGenerator.getNativeImage(this.parentMetadata.resourceManager, this.blendArchMask);
            this.archTexture = LBGLayer.genTexture(name + "_" + this.index + "_arch", side, top, archMask);
            this.parentMetadata.textures.add(this.archTexture);
            archMask.close();
        }
        top.close();
        side.close();
    }

    private static class_2960 getTexturePath(class_2960 id) {
        return new class_2960(id.method_12836(), "textures/" + id.method_12832() + ".png");
    }

    private static class_4730 genTexture(String name, class_1011 side, class_1011 top, class_1011 mask) {
        return new class_4730(class_1723.field_21668, LBGTextureGenerator.generateTexture(name, side, top, mask));
    }

    public void bakeTextures(Function<class_4730, class_1058> textureGetter) {
        this.tryBakeSprite("connect", this.connectTexture, textureGetter);
        this.tryBakeSprite("blend_up", this.blendUpTexture, textureGetter);
        this.tryBakeSprite("blend_up_m", this.blendUpMirroredTexture, textureGetter);
        this.tryBakeSprite("arch", this.archTexture, textureGetter);
    }

    private void tryBakeSprite(String name, @Nullable class_4730 id, Function<class_4730, class_1058> textureGetter) {
        if (id == null) {
            id = new class_4730(class_1723.field_21668, (class_2960)class_1088.field_5374);
        }
        try {
            this.bakedSprites.put(name, textureGetter.apply(id));
        }
        catch (NullPointerException e) {
            LambdaBetterGrass.get().warn("Could not bake sprite `" + name + "` with id `" + id + "`!");
            this.bakedSprites.put(name, textureGetter.apply(new class_4730(class_1723.field_21668, (class_2960)class_1088.field_5374)));
        }
    }

    @Nullable
    public class_1058 getBakedTexture(String name) {
        return this.bakedSprites.get(name);
    }

    public String toString() {
        return "LBGLayer{index=" + this.index + ", colorIndex=" + this.colorIndex + "}";
    }

    public static LBGLayer mergeLayers(LBGLayer parent, LBGLayer child) {
        class_1011 childBlendUp;
        class_1011 parentBlendUp;
        if (parent.colorIndex != child.colorIndex) {
            return parent;
        }
        String[] path = parent.parentMetadata.id.method_12832().split("/");
        String name = path.length == 0 ? "undefined" : path[path.length - 1];
        if (parent.connectTexture != null && child.connectTexture != null) {
            class_1011 parentConnect = LBGTextureGenerator.getNativeImage(parent.parentMetadata.resourceManager, LBGLayer.getTexturePath(parent.connectTexture.method_24147()));
            class_1011 childConnect = LBGTextureGenerator.getNativeImage(child.parentMetadata.resourceManager, LBGLayer.getTexturePath(child.connectTexture.method_24147()));
            parent.parentMetadata.textures.remove(parent.connectTexture);
            parent.connectTexture = LBGLayer.genTexture(name + "_" + parent.index + "_connect", parentConnect, childConnect, childConnect);
            parent.parentMetadata.textures.add(parent.connectTexture);
            parentConnect.close();
            childConnect.close();
        }
        if (parent.blendUpTexture != null && child.blendUpTexture != null) {
            parentBlendUp = LBGTextureGenerator.getNativeImage(parent.parentMetadata.resourceManager, LBGLayer.getTexturePath(parent.blendUpTexture.method_24147()));
            childBlendUp = LBGTextureGenerator.getNativeImage(child.parentMetadata.resourceManager, LBGLayer.getTexturePath(child.blendUpTexture.method_24147()));
            parent.parentMetadata.textures.remove(parent.blendUpTexture);
            parent.blendUpTexture = LBGLayer.genTexture(name + "_" + parent.index + "_blend_up", parentBlendUp, childBlendUp, childBlendUp);
            parent.parentMetadata.textures.add(parent.blendUpTexture);
            parentBlendUp.close();
            childBlendUp.close();
        }
        if (parent.blendUpMirroredTexture != null && child.blendUpMirroredTexture != null) {
            parentBlendUp = LBGTextureGenerator.getNativeImage(parent.parentMetadata.resourceManager, LBGLayer.getTexturePath(parent.blendUpMirroredTexture.method_24147()));
            childBlendUp = LBGTextureGenerator.getNativeImage(child.parentMetadata.resourceManager, LBGLayer.getTexturePath(child.blendUpMirroredTexture.method_24147()));
            parent.parentMetadata.textures.remove(parent.blendUpMirroredTexture);
            parent.blendUpMirroredTexture = LBGLayer.genTexture(name + "_" + parent.index + "_blend_up_m", parentBlendUp, childBlendUp, childBlendUp);
            parent.parentMetadata.textures.add(parent.blendUpMirroredTexture);
            parentBlendUp.close();
            childBlendUp.close();
        }
        if (parent.archTexture != null && child.archTexture != null) {
            class_1011 parentArch = LBGTextureGenerator.getNativeImage(parent.parentMetadata.resourceManager, LBGLayer.getTexturePath(parent.archTexture.method_24147()));
            class_1011 childArch = LBGTextureGenerator.getNativeImage(child.parentMetadata.resourceManager, LBGLayer.getTexturePath(child.archTexture.method_24147()));
            parent.parentMetadata.textures.remove(parent.archTexture);
            parent.archTexture = LBGLayer.genTexture(name + "_" + parent.index + "_arch", parentArch, childArch, childArch);
            parent.parentMetadata.textures.add(parent.archTexture);
            parentArch.close();
            childArch.close();
        }
        return parent;
    }
}

