/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.taski.builtin;

import dev.quantumfusion.taski.Task;
import dev.quantumfusion.taski.builtin.AbstractTask;
import dev.quantumfusion.taski.builtin.StaticTask;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class WeightedStageTask
extends AbstractTask {
    private List<WeightedStage> stages = new ArrayList<WeightedStage>();
    private float totalWeight;

    public WeightedStageTask(String name) {
        super(name);
        this.reset();
    }

    public WeightedStageTask(String name, List<WeightedStage> stages) {
        super(name);
        this.reset(stages);
    }

    public List<WeightedStage> getStages() {
        return this.stages;
    }

    public float getTotalWeight() {
        return this.totalWeight;
    }

    public void reset(List<WeightedStage> stages) {
        this.stages = stages;
        this.totalWeight = 0.0f;
        for (WeightedStage stage : stages) {
            this.totalWeight += stage.weight;
        }
    }

    @Override
    public void reset() {
        for (WeightedStage stage : this.stages) {
            if (stage.task == null) continue;
            stage.task.reset();
        }
    }

    @Override
    public void finish() {
        for (WeightedStage stage : this.stages) {
            if (stage.task != null) {
                stage.task.finish();
                continue;
            }
            stage.task = StaticTask.FULL;
        }
    }

    @Override
    public @Range(from=0L, to=1L) float getProgress() {
        List<WeightedStage> stages = this.stages;
        if (stages.isEmpty()) {
            return 0.0f;
        }
        float total = 0.0f;
        for (WeightedStage stage : stages) {
            if (stage.task == null) break;
            if (stage.task.done()) {
                total += 1.0f * stage.weight;
                continue;
            }
            total += stage.task.getProgress() * stage.weight;
            break;
        }
        return total / this.totalWeight;
    }

    @Override
    public boolean done() {
        if (this.stages.isEmpty()) {
            return false;
        }
        for (WeightedStage stage : this.stages) {
            if (stage.task != null && stage.task.done()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public String getNameSuffix() {
        List<WeightedStage> stages = this.stages;
        if (stages.isEmpty()) {
            return null;
        }
        int done = 0;
        for (WeightedStage stage : stages) {
            if (stage.task == null || !stage.task.done()) break;
            ++done;
        }
        return Math.min(done + 1, stages.size()) + " / " + stages.size();
    }

    public static class WeightedStage {
        public final float weight;
        @Nullable
        public Task task;

        public WeightedStage(float weight, @Nullable Task task) {
            this.weight = weight;
            this.task = task;
        }
    }
}

