/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.taski.builtin;

import dev.quantumfusion.taski.Task;
import dev.quantumfusion.taski.builtin.AbstractTask;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StepTask
extends AbstractTask {
    public static final int UNKNOWN_TOTAL = -1;
    private int total;
    private int current;
    @Nullable
    private Task subTask;

    public StepTask(String name) {
        super(name);
        this.total = -1;
    }

    public StepTask(String name, int total) {
        super(name);
        this.total = total;
    }

    public StepTask(String name, int total, int startValue) {
        super(name);
        this.total = total;
        this.current = startValue;
    }

    public void setSubTask(@NotNull Task subTask) {
        this.subTask = subTask;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    @Nullable
    public Task getSubTask() {
        return this.subTask;
    }

    public int getCurrent() {
        return this.current;
    }

    public int getTotal() {
        return this.total;
    }

    public void reset(int total, int startValue) {
        this.total = total;
        this.current = startValue;
    }

    public void reset(int total) {
        this.reset(total, 0);
    }

    @Override
    public void reset() {
        this.reset(-1, 0);
    }

    @Override
    public void finish() {
        this.current = this.total;
    }

    public <T extends Task> void run(int amount, T subTask, Consumer<T> function) {
        function.accept(subTask);
        this.current += amount;
        this.subTask = subTask;
    }

    public <T extends Task> void run(T subTask, Consumer<T> function) {
        this.run(1, subTask, function);
    }

    public void run(int amount, Task subTask, Runnable function) {
        function.run();
        this.current += amount;
        this.subTask = subTask;
    }

    public void run(Task subTask, Runnable function) {
        this.run(1, subTask, function);
    }

    public void run(int amount, Runnable function) {
        this.run(amount, null, function);
    }

    public void run(Runnable function) {
        this.run(1, null, function);
    }

    public void next(int amount, Task subTask) {
        this.current += amount;
        this.subTask = subTask;
    }

    public void next(Task subTask) {
        this.next(1, subTask);
    }

    public void next(int amount) {
        this.next(amount, null);
    }

    public void next() {
        this.next(1, null);
    }

    @Override
    public boolean done() {
        if (this.total == -1) {
            return false;
        }
        return this.current >= this.total;
    }

    @Override
    public float getProgress() {
        if (this.total == -1) {
            return 0.0f;
        }
        float value = (float)this.current / (float)this.total;
        if (this.subTask != null) {
            value += this.subTask.getProgress() / (float)this.total;
        }
        return value;
    }

    @Override
    @Nullable
    public String getNameSuffix() {
        if (this.total == -1) {
            return null;
        }
        return Math.min(this.current + 1, this.total) + " / " + this.total;
    }
}

