/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.taski.builtin;

import dev.quantumfusion.taski.Task;
import dev.quantumfusion.taski.builtin.AbstractTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class StageTask
extends AbstractTask {
    private List<Task> stages = new ArrayList<Task>();

    public StageTask(String name) {
        super(name);
    }

    public StageTask(String name, List<Task> stages) {
        super(name);
        this.reset(stages);
    }

    public StageTask(String name, Task ... stages) {
        super(name);
        this.reset(stages);
    }

    public List<Task> getStages() {
        return this.stages;
    }

    public void reset(List<Task> stages) {
        this.stages = stages;
    }

    public void reset(Task ... stages) {
        ArrayList<Task> out = new ArrayList<Task>(stages.length);
        Collections.addAll(out, stages);
        this.stages = out;
    }

    @Override
    public void reset() {
        for (Task stage : this.stages) {
            stage.reset();
        }
    }

    @Override
    public void finish() {
        for (Task stage : this.stages) {
            stage.finish();
        }
    }

    @Override
    public boolean done() {
        if (this.stages.isEmpty()) {
            return false;
        }
        for (Task stage : this.stages) {
            if (stage.done()) continue;
            return false;
        }
        return true;
    }

    @Override
    public float getProgress() {
        List<Task> stages = this.stages;
        if (stages.isEmpty()) {
            return 0.0f;
        }
        float total = 0.0f;
        for (Task stage : stages) {
            if (stage.done()) {
                total += 1.0f;
                continue;
            }
            total += stage.getProgress();
            break;
        }
        return total / (float)stages.size();
    }

    @Override
    @Nullable
    public String getNameSuffix() {
        List<Task> stages = this.stages;
        if (stages.isEmpty()) {
            return null;
        }
        int done = 0;
        for (Task stage : stages) {
            if (!stage.done()) break;
            ++done;
        }
        return Math.min(done + 1, stages.size()) + " / " + stages.size();
    }
}

