/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.taski.builtin;

import dev.quantumfusion.taski.builtin.AbstractTask;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class PercentagePollTask
extends AbstractTask {
    private Supplier<Float> pollFunc;

    public PercentagePollTask(String name) {
        super(name);
        this.pollFunc = null;
    }

    public PercentagePollTask(String name, Supplier<Float> pollFunc) {
        super(name);
        this.pollFunc = pollFunc;
    }

    @Override
    public void reset() {
        this.pollFunc = null;
    }

    public void reset(Supplier<Float> pollFunc) {
        this.pollFunc = pollFunc;
    }

    @Override
    public void finish() {
        this.pollFunc = () -> Float.valueOf(1.0f);
    }

    @Override
    public boolean done() {
        if (this.pollFunc == null) {
            return false;
        }
        return this.pollFunc.get().floatValue() >= 1.0f;
    }

    @Override
    public float getProgress() {
        if (this.pollFunc == null) {
            return 0.0f;
        }
        return this.pollFunc.get().floatValue();
    }

    @Override
    @Nullable
    public String getNameSuffix() {
        if (this.pollFunc == null) {
            return null;
        }
        return (int)(this.pollFunc.get().floatValue() * 100.0f) + "%";
    }
}

