/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.taski.builtin;

import dev.quantumfusion.taski.builtin.AbstractTask;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class CountPollTask
extends AbstractTask {
    private Supplier<Integer> countFunc;
    private int total;

    public CountPollTask(String name) {
        super(name);
        this.total = 0;
        this.countFunc = null;
    }

    public CountPollTask(String name, int total, Supplier<Integer> countFunc) {
        super(name);
        this.total = total;
        this.countFunc = countFunc;
    }

    public int getTotal() {
        return this.total;
    }

    public Supplier<Integer> getCountFunc() {
        return this.countFunc;
    }

    public void reset(int total, Supplier<Integer> countFunc) {
        this.total = total;
        this.countFunc = countFunc;
    }

    @Override
    public void reset() {
        this.total = 0;
        this.countFunc = null;
    }

    @Override
    public void finish() {
        this.countFunc = () -> this.total;
    }

    @Override
    public boolean done() {
        if (this.countFunc == null) {
            return false;
        }
        return this.countFunc.get() >= this.total;
    }

    @Override
    public float getProgress() {
        if (this.countFunc == null) {
            return 0.0f;
        }
        return this.countFunc.get().intValue();
    }

    @Override
    @Nullable
    public String getNameSuffix() {
        if (this.countFunc == null) {
            return null;
        }
        return Math.min(this.countFunc.get() + 1, this.total) + " / " + this.total;
    }
}

