/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.threading.worldgen.common;

import com.google.common.base.Preconditions;
import com.ibm.asyncutil.locks.AsyncLock;
import com.ibm.asyncutil.locks.AsyncNamedLock;
import com.ishland.c2me.base.common.GlobalExecutors;
import com.ishland.c2me.base.common.scheduler.SchedulerThread;
import com.ishland.c2me.base.common.scheduler.SchedulingAsyncCombinedLock;
import com.ishland.c2me.threading.worldgen.common.Config;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1923;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3193;

public class ChunkStatusUtils {
    public static final BooleanSupplier FALSE_SUPPLIER = () -> false;

    public static ChunkStatusThreadingType getThreadingType(class_2806 status) {
        if (status.equals(class_2806.field_16423) || status.equals(class_2806.field_16422) || status.equals(class_2806.field_12794) || status.equals(class_2806.field_12804) || status.equals(class_2806.field_12796) || status.equals(class_2806.field_12801) || status.equals(class_2806.field_12790) || status.equals(class_2806.field_12800)) {
            return ChunkStatusThreadingType.PARALLELIZED;
        }
        if (status.equals(class_2806.field_12786)) {
            return ChunkStatusThreadingType.SINGLE_THREADED;
        }
        if (status.equals(class_2806.field_12795)) {
            return Config.allowThreadedFeatures ? ChunkStatusThreadingType.PARALLELIZED : ChunkStatusThreadingType.SINGLE_THREADED;
        }
        return ChunkStatusThreadingType.AS_IS;
    }

    public static <T> CompletableFuture<T> runChunkGenWithLock(class_1923 target, class_2806 status, class_3193 holder, int radius, IntSupplier priority, AsyncNamedLock<class_1923> chunkLock, Supplier<CompletableFuture<T>> action) {
        Preconditions.checkNotNull((Object)priority);
        Preconditions.checkNotNull((Object)status);
        ArrayList<class_1923> fetchedLocks = new ArrayList<class_1923>((2 * radius + 1) * (2 * radius + 1));
        for (int x = target.field_9181 - radius; x <= target.field_9181 + radius; ++x) {
            for (int z = target.field_9180 - radius; z <= target.field_9180 + radius; ++z) {
                fetchedLocks.add(new class_1923(x, z));
            }
        }
        BooleanSupplier isCancelled = holder != null ? () -> holder.method_16146(status).isDone() : FALSE_SUPPLIER;
        SchedulingAsyncCombinedLock lock = new SchedulingAsyncCombinedLock(chunkLock, new HashSet(fetchedLocks), priority, isCancelled, SchedulerThread.INSTANCE, action, target.toString());
        SchedulerThread.INSTANCE.addPendingLock(lock);
        return lock.getFuture();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ChunkStatusThreadingType {
        PARALLELIZED{

            @Override
            public CompletableFuture<Either<class_2791, class_3193.class_3724>> runTask(AsyncLock lock, Supplier<CompletableFuture<Either<class_2791, class_3193.class_3724>>> completableFuture) {
                return CompletableFuture.supplyAsync(completableFuture, GlobalExecutors.executor).thenCompose(Function.identity());
            }
        }
        ,
        SINGLE_THREADED{

            @Override
            public CompletableFuture<Either<class_2791, class_3193.class_3724>> runTask(AsyncLock lock, Supplier<CompletableFuture<Either<class_2791, class_3193.class_3724>>> completableFuture) {
                Preconditions.checkNotNull((Object)lock);
                return lock.acquireLock().toCompletableFuture().thenComposeAsync(lockToken -> {
                    try {
                        CompletionStage completionStage = (CompletionStage)completableFuture.get();
                        return completionStage;
                    }
                    finally {
                        lockToken.releaseLock();
                    }
                }, (Executor)GlobalExecutors.executor);
            }
        }
        ,
        AS_IS{

            @Override
            public CompletableFuture<Either<class_2791, class_3193.class_3724>> runTask(AsyncLock lock, Supplier<CompletableFuture<Either<class_2791, class_3193.class_3724>>> completableFuture) {
                return completableFuture.get();
            }
        };


        public abstract CompletableFuture<Either<class_2791, class_3193.class_3724>> runTask(AsyncLock var1, Supplier<CompletableFuture<Either<class_2791, class_3193.class_3724>>> var2);
    }
}

