/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TextFieldListEntry;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public class DoubleListEntry
extends TextFieldListEntry<Double> {
    private static final Function<String, String> stripCharacters = s -> {
        StringBuilder stringBuilder_1 = new StringBuilder();
        char[] var2 = s.toCharArray();
        int var3 = var2.length;
        for (char c : var2) {
            if (!Character.isDigit(c) && c != '-' && c != '.') continue;
            stringBuilder_1.append(c);
        }
        return stringBuilder_1.toString();
    };
    private double minimum = -1.7976931348623157E308;
    private double maximum = Double.MAX_VALUE;
    private final Consumer<Double> saveConsumer;

    @Deprecated
    @ApiStatus.Internal
    public DoubleListEntry(Component fieldName, Double value, Component resetButtonKey, Supplier<Double> defaultValue, Consumer<Double> saveConsumer) {
        super(fieldName, value, resetButtonKey, defaultValue);
        this.saveConsumer = saveConsumer;
    }

    @Deprecated
    @ApiStatus.Internal
    public DoubleListEntry(Component fieldName, Double value, Component resetButtonKey, Supplier<Double> defaultValue, Consumer<Double> saveConsumer, Supplier<Optional<Component[]>> tooltipSupplier) {
        this(fieldName, value, resetButtonKey, defaultValue, saveConsumer, tooltipSupplier, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public DoubleListEntry(Component fieldName, Double value, Component resetButtonKey, Supplier<Double> defaultValue, Consumer<Double> saveConsumer, Supplier<Optional<Component[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, value, resetButtonKey, defaultValue, tooltipSupplier, requiresRestart);
        this.saveConsumer = saveConsumer;
    }

    @Override
    protected String stripAddText(String s) {
        return stripCharacters.apply(s);
    }

    @Override
    protected void textFieldPreRender(EditBox widget) {
        try {
            double i = Double.parseDouble(this.textFieldWidget.m_94155_());
            if (i < this.minimum || i > this.maximum) {
                widget.m_94202_(0xFF5555);
            } else {
                widget.m_94202_(0xE0E0E0);
            }
        }
        catch (NumberFormatException ex) {
            widget.m_94202_(0xFF5555);
        }
    }

    @Override
    protected boolean isMatchDefault(String text) {
        return this.getDefaultValue().isPresent() && text.equals(((Double)this.defaultValue.get()).toString());
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    public DoubleListEntry setMinimum(double minimum) {
        this.minimum = minimum;
        return this;
    }

    public DoubleListEntry setMaximum(double maximum) {
        this.maximum = maximum;
        return this;
    }

    @Override
    public Double getValue() {
        try {
            return Double.valueOf(this.textFieldWidget.m_94155_());
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    @Override
    public Optional<Component> getError() {
        try {
            double i = Double.parseDouble(this.textFieldWidget.m_94155_());
            if (i > this.maximum) {
                return Optional.of(Component.m_237110_((String)"text.cloth-config.error.too_large", (Object[])new Object[]{this.maximum}));
            }
            if (i < this.minimum) {
                return Optional.of(Component.m_237110_((String)"text.cloth-config.error.too_small", (Object[])new Object[]{this.minimum}));
            }
        }
        catch (NumberFormatException ex) {
            return Optional.of(Component.m_237115_((String)"text.cloth-config.error.not_valid_number_double"));
        }
        return super.getError();
    }
}

