/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.memoryleakfix;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.logging.LoggerAdapterDefault;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.struct.InjectorGroupInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;

public class MemoryLeakFix
implements ModInitializer {
    public static final String MOD_ID = "memoryleakfix";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"memoryleakfix");
    public static final Set<ByteBuf> BUFFERS_TO_CLEAR = Collections.synchronizedSet(new HashSet());
    private static final String OBJECT = "java/lang/Object";

    public void onInitialize() {
    }

    public static void forceLoadAllMixinsAndClearSpongePoweredCache() {
        if (FabricLoader.getInstance().isModLoaded("essential-loader")) {
            return;
        }
        LOGGER.info("[MemoryLeakFix] Attempting to ForceLoad All Mixins and clear cache");
        MemoryLeakFix.silenceAuditLogger();
        MixinEnvironment.getCurrentEnvironment().audit();
        try {
            Field noGroupField = InjectorGroupInfo.Map.class.getDeclaredField("NO_GROUP");
            noGroupField.setAccessible(true);
            Object noGroup = noGroupField.get(null);
            Field membersField = noGroup.getClass().getDeclaredField("members");
            membersField.setAccessible(true);
            ((List)membersField.get(noGroup)).clear();
            MemoryLeakFix.emptyClassInfo();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        LOGGER.info("[MemoryLeakFix] Done ForceLoad and clearing SpongePowered cache");
    }

    private static Class<?> getMixinLoggerClass() throws ClassNotFoundException {
        Class<?> mixinLogger;
        try {
            mixinLogger = Class.forName("net.fabricmc.loader.impl.launch.knot.MixinLogger");
        }
        catch (ClassNotFoundException err) {
            mixinLogger = Class.forName("org.quiltmc.loader.impl.launch.knot.MixinLogger");
        }
        return mixinLogger;
    }

    private static void silenceAuditLogger() {
        try {
            Field loggerField = MemoryLeakFix.getMixinLoggerClass().getDeclaredField("LOGGER_MAP");
            loggerField.setAccessible(true);
            Map loggerMap = (Map)loggerField.get(null);
            loggerMap.put("mixin.audit", new LoggerAdapterDefault("mixin.audit"));
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    private static void emptyClassInfo() throws NoSuchFieldException, IllegalAccessException {
        if (FabricLoader.getInstance().isModLoaded("not-that-cc")) {
            return;
        }
        Field cacheField = ClassInfo.class.getDeclaredField("cache");
        cacheField.setAccessible(true);
        Map cache = (Map)cacheField.get(null);
        ClassInfo jlo = (ClassInfo)cache.get(OBJECT);
        cache.clear();
        cache.put(OBJECT, jlo);
    }
}

