/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.opts.allocs.common;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class SimpleObjectPool<T> {
    private final Function<SimpleObjectPool<T>, T> constructor;
    private final Consumer<T> initializer;
    private final int size;
    private final Object[] cachedObjects;
    private int allocatedCount = 0;

    public SimpleObjectPool(Function<SimpleObjectPool<T>, T> constructor, Consumer<T> initializer, int size) {
        this.constructor = Objects.requireNonNull(constructor);
        this.initializer = Objects.requireNonNull(initializer);
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0);
        this.cachedObjects = new Object[size];
        this.size = size;
        for (int i = 0; i < size; ++i) {
            T object = constructor.apply(this);
            this.cachedObjects[i] = object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T alloc() {
        Object object;
        SimpleObjectPool simpleObjectPool = this;
        synchronized (simpleObjectPool) {
            if (this.allocatedCount >= this.size) {
                T object2 = this.constructor.apply(this);
                return object2;
            }
            int ordinal = this.allocatedCount++;
            object = this.cachedObjects[ordinal];
            this.cachedObjects[ordinal] = null;
        }
        this.initializer.accept(object);
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(T object) {
        SimpleObjectPool simpleObjectPool = this;
        synchronized (simpleObjectPool) {
            if (this.allocatedCount == 0) {
                return;
            }
            this.cachedObjects[--this.allocatedCount] = object;
        }
    }
}

