/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.base.common.scheduler;

import com.google.common.base.Preconditions;
import com.ibm.asyncutil.locks.AsyncLock;
import com.ibm.asyncutil.locks.AsyncNamedLock;
import com.ishland.c2me.base.common.GlobalExecutors;
import com.ishland.c2me.base.common.scheduler.SchedulerThread;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1923;
import org.jetbrains.annotations.NotNull;

public class SchedulingAsyncCombinedLock<T>
implements Comparable<SchedulingAsyncCombinedLock<T>> {
    private final AsyncNamedLock<class_1923> lock;
    private final class_1923[] names;
    private final IntSupplier priority;
    private final BooleanSupplier isCancelled;
    private final SchedulerThread schedulerThread;
    private final Supplier<CompletableFuture<T>> action;
    private final String desc;
    private final CompletableFuture<T> future = new CompletableFuture();
    private AsyncLock.LockToken acquiredToken;

    public SchedulingAsyncCombinedLock(AsyncNamedLock<class_1923> lock, Set<class_1923> names, IntSupplier priority, BooleanSupplier isCancelled, SchedulerThread schedulerThread, Supplier<CompletableFuture<T>> action, String desc) {
        this.lock = lock;
        this.names = (class_1923[])names.toArray(class_1923[]::new);
        this.priority = priority;
        this.isCancelled = isCancelled;
        this.schedulerThread = schedulerThread;
        this.action = action;
        this.desc = desc;
    }

    synchronized boolean tryAcquire() {
        if (this.isCancelled.getAsBoolean()) {
            this.future.completeExceptionally(new CancellationException());
            return false;
        }
        LockEntry[] tryLocks = new LockEntry[this.names.length];
        boolean allAcquired = true;
        for (class_1923 name : this.names) {
            LockEntry entry;
            tryLocks[i] = entry = new LockEntry(name, this.lock.tryLock((Object)name));
            if (!entry.lockToken.isEmpty()) continue;
            allAcquired = false;
            break;
        }
        if (allAcquired) {
            this.acquiredToken = () -> {
                for (LockEntry entry : tryLocks) {
                    entry.lockToken.get().releaseLock();
                }
            };
            return true;
        }
        boolean triedRelock = false;
        for (LockEntry entry : tryLocks) {
            if (entry == null) continue;
            entry.lockToken.ifPresent(AsyncLock.LockToken::releaseLock);
            if (triedRelock || !entry.lockToken.isEmpty()) continue;
            this.lock.acquireLock((Object)entry.name).thenAccept(lockToken -> {
                lockToken.releaseLock();
                this.schedulerThread.addPendingLock(this);
            });
            triedRelock = true;
        }
        if (!triedRelock) {
            System.err.println("Some issue occurred while doing locking, retrying");
            return this.tryAcquire();
        }
        return false;
    }

    public void doAction(Runnable postAction) {
        Preconditions.checkNotNull((Object)postAction);
        AsyncLock.LockToken token = this.acquiredToken;
        if (token == null) {
            throw new IllegalStateException();
        }
        CompletableFuture<T> future = this.action.get();
        Preconditions.checkNotNull(future, (Object)"future");
        future.handleAsync((result, throwable) -> {
            try {
                token.releaseLock();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                postAction.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (throwable != null) {
                this.future.completeExceptionally((Throwable)throwable);
            } else {
                this.future.complete(result);
            }
            return null;
        }, GlobalExecutors.invokingExecutor);
    }

    public CompletableFuture<T> getFuture() {
        return this.future.thenApply(Function.identity());
    }

    @Override
    public int compareTo(@NotNull SchedulingAsyncCombinedLock o) {
        return Integer.compare(this.priority.getAsInt(), o.priority.getAsInt());
    }

    private record LockEntry(class_1923 name, Optional<AsyncLock.LockToken> lockToken) {
    }
}

