/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.base.common.scheduler;

import com.ishland.c2me.base.ModuleEntryPoint;
import com.ishland.c2me.base.common.scheduler.PriorityUtils;
import com.ishland.c2me.base.common.scheduler.SchedulingAsyncCombinedLock;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerThread
extends Thread
implements Executor {
    static final Logger LOGGER = LoggerFactory.getLogger((String)"C2ME Scheduler");
    public static final SchedulerThread INSTANCE = new SchedulerThread();
    private final ConcurrentLinkedQueue<Runnable> rawTasks = new ConcurrentLinkedQueue();
    private final PriorityBlockingQueue<SchedulingAsyncCombinedLock<?>> pendingLocks = new PriorityBlockingQueue();
    private final Semaphore semaphore = new Semaphore((int)ModuleEntryPoint.globalExecutorParallelism);
    private long lastRebuild = System.currentTimeMillis();
    private int lastPrioritySerial = 0;
    private final ObjectArrayList<SchedulingAsyncCombinedLock<?>> priorityChangeTmpStorage = new ObjectArrayList();

    private SchedulerThread() {
        this.setName("C2ME scheduler");
        this.start();
    }

    @Override
    public void run() {
        while (true) {
            Runnable runnable;
            boolean didWork = false;
            if (this.doPriorityChanges()) {
                didWork = true;
            }
            int burst = 0;
            while (!this.pendingLocks.isEmpty() && burst++ < 128 && this.semaphore.tryAcquire()) {
                SchedulingAsyncCombinedLock<?> lock = this.pendingLocks.poll();
                if (lock != null && lock.tryAcquire()) {
                    lock.doAction(this.semaphore::release);
                    didWork = true;
                    continue;
                }
                this.semaphore.release();
            }
            if (!didWork && (runnable = this.rawTasks.poll()) != null) {
                didWork = true;
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (didWork) continue;
            LockSupport.parkNanos("Waiting for tasks", 10000000L);
        }
    }

    public void addPendingLock(SchedulingAsyncCombinedLock<?> lock) {
        this.pendingLocks.add(lock);
        LockSupport.unpark(this);
    }

    private boolean doPriorityChanges() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis > this.lastRebuild + 500L) {
            this.lastRebuild = currentTimeMillis;
            int currentPrioritySerial = PriorityUtils.priorityChangeSerial();
            if (this.lastPrioritySerial != currentPrioritySerial) {
                this.lastPrioritySerial = currentPrioritySerial;
                long startTime = System.nanoTime();
                this.priorityChangeTmpStorage.clear();
                this.pendingLocks.drainTo((Collection<SchedulingAsyncCombinedLock<?>>)this.priorityChangeTmpStorage);
                this.pendingLocks.addAll((Collection<SchedulingAsyncCombinedLock<?>>)this.priorityChangeTmpStorage);
                this.priorityChangeTmpStorage.clear();
                return true;
            }
        }
        return false;
    }

    @Override
    public void execute(@NotNull Runnable command) {
        this.rawTasks.add(command);
        LockSupport.unpark(this);
    }
}

