/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.base.common.scheduler;

import com.ishland.c2me.base.common.scheduler.ISyncLoadManager;
import com.ishland.c2me.base.common.scheduler.ThreadLocalWorldGenSchedulingState;
import com.ishland.c2me.base.mixin.access.IChunkTicketManager;
import com.ishland.c2me.base.mixin.access.IChunkTicketManagerNearbyChunkTicketUpdater;
import com.ishland.c2me.base.mixin.access.IThreadedAnvilChunkStorage;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntSupplier;
import net.minecraft.class_1923;
import net.minecraft.class_3193;
import net.minecraft.class_3204;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriorityUtils {
    static final Logger LOGGER = LoggerFactory.getLogger((String)"C2ME Priority System");
    private static final int BITS_8 = 255;
    private static final int BITS_4 = 7;
    private static final AtomicInteger priorityChanges = new AtomicInteger(0);

    public static IntSupplier getChunkPriority(class_3218 serverWorld, @Nullable class_3193 holder, class_1923 chunkPos) {
        class_3215 chunkManager = serverWorld.method_14178();
        ISyncLoadManager syncLoadManager = (ISyncLoadManager)chunkManager;
        class_3204 ticketManager = chunkManager.field_17254.method_17263();
        IChunkTicketManagerNearbyChunkTicketUpdater nearbyChunkTicketUpdater = (IChunkTicketManagerNearbyChunkTicketUpdater)((IChunkTicketManager)ticketManager).getNearbyChunkTicketUpdater();
        Long2IntMap distanceFromPlayers = nearbyChunkTicketUpdater.getDistances();
        long pos = chunkPos.method_8324();
        if (holder == null) {
            // empty if block
        }
        return () -> PriorityUtils.syncLoadPriority(chunkPos, syncLoadManager) << 16 | ((holder != null ? holder.method_14005() : 0) & 0xFF) << 8 | distanceFromPlayers.get(pos) & 0xFF;
    }

    public static IntSupplier getChunkPriority(class_3218 serverWorld, class_1923 pos) {
        class_3193 chunkHolder = ThreadLocalWorldGenSchedulingState.getChunkHolder();
        if (chunkHolder == null) {
            Long2ObjectLinkedOpenHashMap<class_3193> chunkHolders = ((IThreadedAnvilChunkStorage)serverWorld.method_14178().field_17254).getChunkHolders();
            chunkHolder = (class_3193)chunkHolders.get(pos.method_8324());
        }
        return PriorityUtils.getChunkPriority(serverWorld, chunkHolder, pos);
    }

    private static byte syncLoadPriority(class_1923 pos, ISyncLoadManager manager) {
        class_1923 currentSyncLoad = manager.getCurrentSyncLoad();
        if (currentSyncLoad == null) {
            return 31;
        }
        int distance = PriorityUtils.chebyshevDistance(pos, currentSyncLoad);
        if (distance > 15) {
            return 31;
        }
        return (byte)(distance & 7);
    }

    private static int chebyshevDistance(class_1923 one, class_1923 another) {
        return another != null && one != null ? Math.min(Math.abs(one.field_9181 - another.field_9181), Math.abs(one.field_9180 - another.field_9180)) : Integer.MAX_VALUE;
    }

    public static void notifyPriorityChange() {
        priorityChanges.incrementAndGet();
    }

    public static int priorityChangeSerial() {
        return priorityChanges.get();
    }
}

