/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.base;

import com.ishland.c2me.base.common.config.ConfigSystem;
import io.netty.util.internal.PlatformDependent;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;

public class ModuleEntryPoint {
    private static final boolean enabled = true;
    public static final long globalExecutorParallelism = new ConfigSystem.ConfigAccessor().key("globalExecutorParallelism").comment("Configures the parallelism of global executor").getLong(ModuleEntryPoint.getDefaultGlobalExecutorParallelism(), ModuleEntryPoint.getDefaultGlobalExecutorParallelism(), ConfigSystem.LongChecks.THREAD_COUNT);

    private static int getDefaultGlobalExecutorParallelism() {
        return Math.max(1, Math.min(ModuleEntryPoint.getDefaultParallelismCPU(), ModuleEntryPoint.getDefaultParallelismHeap()));
    }

    private static int getDefaultParallelismCPU() {
        if (PlatformDependent.isWindows()) {
            return Math.max(1, (int)((double)Runtime.getRuntime().availableProcessors() / 1.6 - 2.0)) + ModuleEntryPoint.defaultParallelismEnvTypeOffset();
        }
        return Math.max(1, (int)((double)Runtime.getRuntime().availableProcessors() / 1.2 - 2.0)) + ModuleEntryPoint.defaultParallelismEnvTypeOffset();
    }

    private static int defaultParallelismEnvTypeOffset() {
        return ModuleEntryPoint.isClientSide() ? -2 : 0;
    }

    private static boolean isClientSide() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    private static int getDefaultParallelismHeap() {
        if (PlatformDependent.isJ9Jvm()) {
            return (int)((ModuleEntryPoint.memoryInGiB() + (ModuleEntryPoint.isClientSide() ? -0.6 : -0.2)) / 0.5) + ModuleEntryPoint.defaultParallelismEnvTypeOffset();
        }
        return (int)((ModuleEntryPoint.memoryInGiB() + (ModuleEntryPoint.isClientSide() ? -1.2 : -0.6)) / 1.2) + ModuleEntryPoint.defaultParallelismEnvTypeOffset();
    }

    private static double memoryInGiB() {
        return (double)Runtime.getRuntime().maxMemory() / 1024.0 / 1024.0 / 1024.0;
    }
}

