/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.base.Strings;
import com.google.gson.JsonParser;
import com.mojang.authlib.exceptions.MinecraftClientException;
import com.mojang.authlib.minecraft.InsecurePublicKeyException;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.response.KeyPairResponse;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.PublicKey;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_3515;
import net.minecraft.class_5525;
import net.minecraft.class_7427;
import net.minecraft.class_7428;
import net.minecraft.class_7501;
import org.slf4j.Logger;

public class class_7434 {
    private static final Logger field_39074 = LogUtils.getLogger();
    private static final Path field_39075 = Path.of("profilekeys", new String[0]);
    private final Path field_39076;
    private final CompletableFuture<Optional<class_7428>> field_39434;
    private final CompletableFuture<Optional<class_7501>> field_39435;

    public class_7434(UserApiService $$03, UUID $$1, Path $$2) {
        this.field_39076 = $$2.resolve(field_39075).resolve($$1 + ".json");
        CompletableFuture<Optional<class_7427>> $$3 = this.method_43602($$03);
        this.field_39434 = $$3.thenApply($$0 -> $$0.map(class_7427::comp_742));
        this.field_39435 = $$3.thenApply($$02 -> $$02.map($$0 -> class_7501.method_44179($$0.comp_741(), "SHA256withRSA")));
    }

    private CompletableFuture<Optional<class_7427>> method_43602(UserApiService $$0) {
        return CompletableFuture.supplyAsync(() -> {
            Optional<class_7427> $$1 = this.method_43606().filter($$0 -> !$$0.comp_742().comp_767().method_43704());
            if ($$1.isPresent() && !$$1.get().method_43546()) {
                return $$1;
            }
            try {
                class_7427 $$2 = this.method_43605($$0);
                this.method_43600($$2);
                return Optional.of($$2);
            }
            catch (MinecraftClientException | IOException | class_5525 $$3) {
                field_39074.error("Failed to retrieve profile key pair", $$3);
                this.method_43600(null);
                return $$1;
            }
        }, class_156.method_18349());
    }

    private Optional<class_7427> method_43606() {
        Optional optional;
        block9: {
            if (Files.notExists(this.field_39076, new LinkOption[0])) {
                return Optional.empty();
            }
            BufferedReader $$0 = Files.newBufferedReader(this.field_39076);
            try {
                optional = class_7427.field_39049.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)$$0)).result();
                if ($$0 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if ($$0 != null) {
                        try {
                            $$0.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception $$1) {
                    field_39074.error("Failed to read profile key pair file {}", (Object)this.field_39076, (Object)$$1);
                    return Optional.empty();
                }
            }
            $$0.close();
        }
        return optional;
    }

    private void method_43600(@Nullable class_7427 $$02) {
        try {
            Files.deleteIfExists(this.field_39076);
        }
        catch (IOException $$1) {
            field_39074.error("Failed to delete profile key pair file {}", (Object)this.field_39076, (Object)$$1);
        }
        if ($$02 == null) {
            return;
        }
        class_7427.field_39049.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)$$02).result().ifPresent($$0 -> {
            try {
                Files.createDirectories(this.field_39076.getParent(), new FileAttribute[0]);
                Files.writeString(this.field_39076, (CharSequence)$$0.toString(), new OpenOption[0]);
            }
            catch (Exception $$1) {
                field_39074.error("Failed to write profile key pair file {}", (Object)this.field_39076, (Object)$$1);
            }
        });
    }

    private class_7427 method_43605(UserApiService $$0) throws class_5525, IOException {
        KeyPairResponse $$1 = $$0.getKeyPair();
        if ($$1 != null) {
            class_7428.class_7443 $$2 = class_7434.method_44076($$1);
            return new class_7427(class_3515.method_43519($$1.getPrivateKey()), class_7428.method_43698($$2), Instant.parse($$1.getRefreshedAfter()));
        }
        throw new IOException("Could not retrieve profile key pair");
    }

    private static class_7428.class_7443 method_44076(KeyPairResponse $$0) throws class_5525 {
        if (Strings.isNullOrEmpty((String)$$0.getPublicKey()) || Strings.isNullOrEmpty((String)$$0.getPublicKeySignature())) {
            throw new class_5525((Throwable)new InsecurePublicKeyException.MissingException());
        }
        try {
            Instant $$1 = Instant.parse($$0.getExpiresAt());
            PublicKey $$2 = class_3515.method_43524($$0.getPublicKey());
            byte[] $$3 = Base64.getDecoder().decode($$0.getPublicKeySignature());
            return new class_7428.class_7443($$1, $$2, $$3);
        }
        catch (IllegalArgumentException | DateTimeException $$4) {
            throw new class_5525($$4);
        }
    }

    @Nullable
    public class_7501 method_44287() {
        return this.field_39435.join().orElse(null);
    }

    public Optional<class_7428> method_43603() {
        return this.field_39434.join();
    }

    public Optional<class_7428.class_7443> method_43784() {
        return this.method_43603().map(class_7428::comp_767);
    }
}

