/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.fixes.worldgen.threading_issues.asm;

import com.ishland.c2me.base.common.util.ASMUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASMTransformerMakeVolatile {
    static final Logger LOGGER = LoggerFactory.getLogger((String)"C2ME (c2me-fixes-worldgen-threading-issues) ASM Transformer");
    private static final Map<String, List<String>> makeVolatileFields = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> makeVolatileFieldsMapped;

    public static void transform(ClassNode classNode) {
        List<String> pendingFields = makeVolatileFieldsMapped.get(classNode.name);
        if (pendingFields != null) {
            classNode.fields.stream().filter(fieldNode -> pendingFields.contains(fieldNode.name + ":" + fieldNode.desc)).forEach(fieldNode -> {
                LOGGER.debug("Making field L{};{}:{} volatile", new Object[]{classNode.name, fieldNode.name, fieldNode.desc});
                fieldNode.access |= 0x40;
            });
        }
    }

    static {
        makeVolatileFields.put("net/minecraft/class_3353$class_3354", List.of("field_14414:Z"));
        makeVolatileFields.put("net/minecraft/class_3390$class_3402", List.of("field_14498:Z"));
        makeVolatileFields.put("net/minecraft/class_3390$class_3398", List.of("field_14496:Z"));
        makeVolatileFields.put("net/minecraft/class_3390$class_3400", List.of("field_14497:Z"));
        makeVolatileFields.put("net/minecraft/class_3390$class_3407", List.of("field_14506:Lnet/minecraft/class_3390$class_3404;"));
        makeVolatileFields.put("net/minecraft/class_3366$class_3388", List.of("field_14485:Z", "field_14484:Z", "field_14483:I"));
        makeVolatileFields.put("net/minecraft/class_3366$class_3374", List.of("field_14464:Lnet/minecraft/class_3366$class_3388;", "field_14466:Lnet/minecraft/class_3366$class_3388;"));
        makeVolatileFields.put("net/minecraft/class_3470", List.of("field_15432:Lnet/minecraft/class_2338;"));
        makeVolatileFields.put("net/minecraft/class_3421$class_3422", List.of("field_15268:Z"));
        makeVolatileFields.put("net/minecraft/class_3421$class_3428", List.of("field_15279:Z"));
        makeVolatileFields.put("net/minecraft/class_3421$class_3434", List.of("field_15284:Lnet/minecraft/class_3421$class_3427;", "field_15283:Lnet/minecraft/class_3421$class_3428;"));
        makeVolatileFields.put("net/minecraft/class_3418", List.of("field_15241:I"));
        makeVolatileFields.put("net/minecraft/class_3447", List.of("field_15322:Z", "field_16445:Z"));
        makeVolatileFields.put("net/minecraft/class_3471$class_3476", List.of("field_15450:Lnet/minecraft/class_2470;", "field_15449:Lnet/minecraft/class_2338;", "field_15448:Ljava/lang/String;"));
        makeVolatileFieldsMapped = makeVolatileFields.entrySet().stream().map(entry -> {
            String mappedClassName = ASMUtils.mappingResolver.mapClassName("intermediary", ((String)entry.getKey()).replace('/', '.')).replace('.', '/');
            List<String> mappedFieldNames = ((List)entry.getValue()).stream().map(fieldName -> {
                String[] split = fieldName.split(":");
                return ASMUtils.mappingResolver.mapFieldName("intermediary", ((String)entry.getKey()).replace('/', '.'), split[0], split[1]) + ":" + ASMUtils.remapFieldDescriptor((String)split[1]);
            }).toList();
            return new KeyValue<String, List<String>>(mappedClassName, mappedFieldNames);
        }).collect(Collectors.toMap(KeyValue::key, KeyValue::value));
    }

    private record KeyValue<K, V>(K key, V value) {
    }
}

