/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.detailab.render;

import com.google.common.collect.Multimap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.redlimerl.detailab.DetailArmorBar;
import com.redlimerl.detailab.api.DetailArmorBarAPI;
import com.redlimerl.detailab.api.render.CustomArmorBar;
import com.redlimerl.detailab.config.ConfigEnumType;
import com.redlimerl.detailab.render.InGameDrawer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_5134;
import net.minecraft.class_757;

public class ArmorBarRenderer {
    public static final ArmorBarRenderer INSTANCE = new ArmorBarRenderer();
    public static long LAST_THORNS = 0L;
    public static long LAST_MENDING = 0L;
    private static final UUID[] MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private final class_310 client = class_310.method_1551();
    private final class_329 hud;

    public ArmorBarRenderer() {
        this.hud = this.client.field_1705;
    }

    private static int getAnimationSpeed() {
        return switch (DetailArmorBar.getConfig().getOptions().effectSpeed) {
            case ConfigEnumType.EffectSpeed.VERY_SLOW -> 45;
            case ConfigEnumType.EffectSpeed.SLOW -> 37;
            case ConfigEnumType.EffectSpeed.FAST -> 23;
            case ConfigEnumType.EffectSpeed.VERY_FAST -> 15;
            default -> 30;
        };
    }

    private static Color getProtectColor(int g, int p, int e, int f, int a) {
        long time;
        int speed = ArmorBarRenderer.getAnimationSpeed();
        int alpha = DetailArmorBar.getConfig().getOptions().effectType == ConfigEnumType.ProtectionEffect.AURA ? 80 : (DetailArmorBar.getConfig().getOptions().effectType == ConfigEnumType.ProtectionEffect.OUTLINE ? ((time = DetailArmorBar.getTicks()) % ((long)speed * 4L) < (long)speed * 2L ? 0 : (time % ((long)speed * 2L) < (long)speed ? Math.round(class_3532.method_16439((float)((float)(time % (long)speed) / ((float)speed - 1.0f)), (float)0.0f, (float)0.65f) * 255.0f) : Math.round(class_3532.method_16439((float)((float)(time % (long)speed) / ((float)speed - 1.0f)), (float)0.65f, (float)0.0f) * 255.0f))) : 0);
        if (g > 0) {
            return new Color(153, 255, 255, alpha);
        }
        if (p > 0) {
            return new Color(112, 51, 173, alpha);
        }
        if (e > 0) {
            return new Color(255, 255, 0, alpha);
        }
        if (f > 0) {
            return new Color(210, 56, 0, alpha);
        }
        if (a > 0) {
            return new Color(255, 255, 255, alpha);
        }
        return Color.WHITE;
    }

    private static Color getProtectColor(int[] s) {
        return ArmorBarRenderer.getProtectColor(s[0], s[1], s[2], s[3], s[4]);
    }

    private static Color getLowDurabilityColor() {
        int speed = ArmorBarRenderer.getAnimationSpeed();
        long time = DetailArmorBar.getTicks();
        int alpha = time % ((long)speed * 4L) >= (long)speed * 2L ? 0 : (time % ((long)speed * 2L) < (long)speed ? Math.round(class_3532.method_16439((float)((float)(time % (long)speed) / ((float)speed - 1.0f)), (float)0.0f, (float)0.65f) * 255.0f) : Math.round(class_3532.method_16439((float)((float)(time % (long)speed) / ((float)speed - 1.0f)), (float)0.65f, (float)0.0f) * 255.0f));
        return new Color(255, 25, 25, alpha);
    }

    private static Color getThornColor() {
        long time = DetailArmorBar.getTicks() - LAST_THORNS;
        if (DetailArmorBar.getConfig().getOptions().effectThorn == ConfigEnumType.Animation.STATIC) {
            return Color.WHITE;
        }
        if (time > 19L) {
            return Color.WHITE;
        }
        int cc = Math.round(class_3532.method_16439((float)((float)(time % 20L) / 19.0f), (float)0.0f, (float)1.0f) * 255.0f);
        return new Color(255, cc, cc);
    }

    private static Map<class_1887, LevelData> getEnchantments(Iterable<class_1799> equipment) {
        HashMap<class_1887, LevelData> result = new HashMap<class_1887, LevelData>();
        for (class_1799 itemStack : equipment) {
            if (itemStack.method_7960()) continue;
            class_1890.method_8222((class_1799)itemStack).forEach((enchantment, integer) -> {
                LevelData enchantData = result.getOrDefault(enchantment, new LevelData(0, 0));
                ++enchantData.count;
                enchantData.level += integer.intValue();
                if (enchantment == class_1893.field_9097) {
                    enchantData.level += integer - 1;
                }
                result.put((class_1887)enchantment, enchantData);
            });
        }
        return result;
    }

    private static LevelData getEnchantLevel(Iterable<class_1799> equipment, class_1887 type) {
        return ArmorBarRenderer.getEnchantments(equipment).getOrDefault(type, new LevelData(0, 0));
    }

    private int getLowDurabilityItem(Iterable<class_1799> equipment) {
        int count = 0;
        for (class_1799 itemStack : equipment) {
            if (itemStack.method_7960() || itemStack.method_7936() == 0 || !((float)itemStack.method_7919() * 100.0f / ((float)itemStack.method_7936() * 100.0f) >= 0.92f)) continue;
            count += itemStack.method_7909() instanceof class_1738 ? ArmorBarRenderer.getDefense(itemStack) : 2;
        }
        return count;
    }

    private static List<class_3545<class_1799, CustomArmorBar>> getArmorPoints(class_1657 player) {
        ArrayList<class_3545<class_1799, CustomArmorBar>> armorItem = new ArrayList<class_3545<class_1799, CustomArmorBar>>();
        Stack<class_1799> equipment = new Stack<class_1799>();
        for (class_1799 item : player.method_5661()) {
            if (DetailArmorBar.getConfig().getOptions().toggleInverseSlot) {
                equipment.push(item);
                continue;
            }
            equipment.add(0, item);
        }
        class_1324 attribute = player.method_5996(class_5134.field_23724);
        if (attribute != null) {
            int i = 0;
            while ((double)i < attribute.method_6201()) {
                armorItem.add((class_3545<class_1799, CustomArmorBar>)new class_3545((Object)class_1799.field_8037, (Object)CustomArmorBar.DEFAULT));
                ++i;
            }
            for (class_1322 entityAttributeModifier : attribute.method_6195()) {
                if (Arrays.stream(MODIFIERS).toList().contains(entityAttributeModifier.method_6189())) continue;
                int i2 = 0;
                while ((double)i2 < entityAttributeModifier.method_6186()) {
                    armorItem.add((class_3545<class_1799, CustomArmorBar>)new class_3545((Object)class_1799.field_8037, (Object)CustomArmorBar.DEFAULT));
                    ++i2;
                }
            }
        }
        for (class_1799 itemStack : equipment) {
            CustomArmorBar barData;
            if (itemStack.method_7960()) continue;
            class_1792 class_17922 = itemStack.method_7909();
            if (class_17922 instanceof class_1738) {
                class_1738 armor = (class_1738)class_17922;
                barData = DetailArmorBar.getConfig().getOptions().toggleArmorTypes ? DetailArmorBarAPI.getArmorBarList().getOrDefault(armor, CustomArmorBar.DEFAULT) : (DetailArmorBar.getConfig().getOptions().toggleNetherites && armor.method_7686() == class_1740.field_21977 ? DetailArmorBarAPI.getArmorBarList().getOrDefault(armor, CustomArmorBar.DEFAULT) : CustomArmorBar.DEFAULT);
                for (int i = 0; i < ArmorBarRenderer.getDefense(itemStack); ++i) {
                    armorItem.add((class_3545<class_1799, CustomArmorBar>)new class_3545((Object)itemStack, (Object)barData));
                }
                continue;
            }
            if (!DetailArmorBar.getConfig().getOptions().toggleItemBar || DetailArmorBar.getConfig().getOptions().toggleSortSpecialItem || !DetailArmorBarAPI.getItemBarList().containsKey(itemStack.method_7909())) continue;
            if (armorItem.size() % 2 == 1) {
                armorItem.add((class_3545<class_1799, CustomArmorBar>)new class_3545((Object)class_1799.field_8037, (Object)CustomArmorBar.EMPTY));
            }
            barData = DetailArmorBarAPI.getItemBarList().get(itemStack.method_7909());
            armorItem.add((class_3545<class_1799, CustomArmorBar>)new class_3545((Object)itemStack, (Object)barData));
            armorItem.add((class_3545<class_1799, CustomArmorBar>)new class_3545((Object)itemStack, (Object)barData));
        }
        if (DetailArmorBar.getConfig().getOptions().toggleItemBar && DetailArmorBar.getConfig().getOptions().toggleSortSpecialItem) {
            for (class_1799 itemStack : equipment) {
                if (itemStack.method_7960() || itemStack.method_7909() instanceof class_1738 || !DetailArmorBarAPI.getItemBarList().containsKey(itemStack.method_7909())) continue;
                if (armorItem.size() % 2 == 1) {
                    armorItem.add((class_3545<class_1799, CustomArmorBar>)new class_3545((Object)class_1799.field_8037, (Object)CustomArmorBar.EMPTY));
                }
                CustomArmorBar barData = DetailArmorBarAPI.getItemBarList().get(itemStack.method_7909());
                armorItem.add((class_3545<class_1799, CustomArmorBar>)new class_3545((Object)itemStack, (Object)barData));
                armorItem.add((class_3545<class_1799, CustomArmorBar>)new class_3545((Object)itemStack, (Object)barData));
            }
        }
        return armorItem;
    }

    private static int getDefense(class_1799 itemStack) {
        class_1738 armorItem = (class_1738)itemStack.method_7909();
        Multimap attributes = itemStack.method_7926(armorItem.method_7685());
        if (attributes.containsKey((Object)class_5134.field_23724)) {
            return attributes.get((Object)class_5134.field_23724).stream().filter(att -> Arrays.stream(MODIFIERS).toList().contains(att.method_6189())).mapToInt(att -> (int)att.method_6186()).sum();
        }
        return armorItem.method_7687();
    }

    public void render(class_4587 matrices, class_1657 player) {
        int mendingSpeed;
        long mendingTime;
        this.client.method_16011().method_15405("armor");
        LevelData generic = ArmorBarRenderer.getEnchantLevel(player.method_5661(), class_1893.field_9111);
        LevelData projectile = ArmorBarRenderer.getEnchantLevel(player.method_5661(), class_1893.field_9096);
        LevelData explosive = ArmorBarRenderer.getEnchantLevel(player.method_5661(), class_1893.field_9107);
        LevelData fire = ArmorBarRenderer.getEnchantLevel(player.method_5661(), class_1893.field_9095);
        int[] protectArr = new int[]{generic.level + generic.count, projectile.level, explosive.level, fire.level, 0};
        List<class_3545<class_1799, CustomArmorBar>> armorPoints = ArmorBarRenderer.getArmorPoints(player);
        LevelData thorns = ArmorBarRenderer.getEnchantLevel(player.method_5661(), class_1893.field_9097);
        int playerHealth = class_3532.method_15386((float)player.method_6032());
        int totalArmorPoint = armorPoints.size();
        int totalEnchants = Arrays.stream(protectArr).sum();
        double maxHealth = Math.max(player.method_26825(class_5134.field_23716), (double)playerHealth);
        int absorptionHealth = class_3532.method_15386((float)player.method_6067());
        int healthRow = DetailArmorBar.getConfig().getOptions().toggleCompatibleHeartMod ? 1 : class_3532.method_15384((double)((maxHealth + (double)absorptionHealth) / 20.0));
        int screenWidth = this.client.method_22683().method_4486() / 2 - 91;
        int screenHeight = this.client.method_22683().method_4502() - 39;
        int yPos = screenHeight - (healthRow - 1) * Math.max(10 - (healthRow - 2), 3) - 10;
        int stackCount = (totalArmorPoint - 1) / 20;
        int stackRow = stackCount * 20;
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34542);
        if (totalArmorPoint > 0) {
            for (int count = 0; count < 10; ++count) {
                int xPos = screenWidth + count * 8;
                if (count * 2 + 1 + stackRow < totalArmorPoint) {
                    class_3545<class_1799, CustomArmorBar> am1 = armorPoints.get(count * 2 + stackRow);
                    class_3545<class_1799, CustomArmorBar> am2 = armorPoints.get(count * 2 + 1 + stackRow);
                    if (am1.method_15441() == am2.method_15441()) {
                        ((CustomArmorBar)am1.method_15441()).draw((class_1799)am1.method_15442(), matrices, xPos, yPos, false, false);
                    } else {
                        ((CustomArmorBar)am2.method_15441()).draw((class_1799)am2.method_15442(), matrices, xPos, yPos, true, true);
                        ((CustomArmorBar)am1.method_15441()).draw((class_1799)am1.method_15442(), matrices, xPos, yPos, true, false);
                    }
                }
                if (count * 2 + 1 + stackRow == totalArmorPoint) {
                    CustomArmorBar.EMPTY.draw(class_1799.field_8037, matrices, xPos, yPos, false, false);
                    class_3545<class_1799, CustomArmorBar> am = armorPoints.get(count * 2 + stackRow);
                    ((CustomArmorBar)am.method_15441()).draw((class_1799)am.method_15442(), matrices, xPos, yPos, true, false);
                }
                if (count * 2 + 1 + stackRow <= totalArmorPoint) continue;
                CustomArmorBar.EMPTY.draw(class_1799.field_8037, matrices, xPos, yPos, false, false);
            }
            if (armorPoints.size() > 20) {
                for (int i = 0; i < stackCount; ++i) {
                    CustomArmorBar.DEFAULT.draw(class_1799.field_8037, matrices, screenWidth - 7 - (stackCount - i) * 3, yPos, false, false);
                }
            }
        }
        if (DetailArmorBar.getConfig().getOptions().toggleDurability) {
            Color lowDurColor;
            int lowDur = this.getLowDurabilityItem(player.method_5661());
            if (totalArmorPoint != 0 && lowDur != 0 && (lowDurColor = ArmorBarRenderer.getLowDurabilityColor()).getAlpha() != 0) {
                int armorPreset = (totalArmorPoint - 1) % 20 + 1;
                int halfArmors = (int)Math.ceil((double)armorPreset / 2.0) - 1;
                for (int count = 0; count <= halfArmors && lowDur > 0; ++count) {
                    int xPos = screenWidth + (halfArmors - count) * 8;
                    class_3545<class_1799, CustomArmorBar> am = armorPoints.get((halfArmors - count) * 2 + stackRow);
                    if (armorPreset == (halfArmors - count) * 2 + 1) {
                        if (count != 0) continue;
                        ((CustomArmorBar)am.method_15441()).drawOutLine((class_1799)am.method_15442(), matrices, xPos, yPos, true, false, lowDurColor);
                        --lowDur;
                        continue;
                    }
                    if (lowDur == 1) {
                        ((CustomArmorBar)am.method_15441()).drawOutLine((class_1799)am.method_15442(), matrices, xPos, yPos, true, true, lowDurColor);
                        lowDur = 0;
                        continue;
                    }
                    ((CustomArmorBar)am.method_15441()).drawOutLine((class_1799)am.method_15442(), matrices, xPos, yPos, false, false, lowDurColor);
                    lowDur -= 2;
                }
            }
        }
        if (DetailArmorBar.getConfig().getOptions().toggleMending && totalArmorPoint != 0 && (mendingTime = DetailArmorBar.getTicks() - LAST_MENDING) < (long)((mendingSpeed = 3) * 4)) {
            for (int count = 0; count < 10; ++count) {
                if (mendingTime % (long)(mendingSpeed * 2) >= (long)mendingSpeed) continue;
                int xPos = screenWidth + count * 8;
                if (armorPoints.size() <= count * 2 + stackRow) {
                    if (!DetailArmorBar.getConfig().getOptions().toggleEmptyBar) continue;
                    CustomArmorBar.DEFAULT.drawOutLine(class_1799.field_8037, matrices, xPos, yPos, false, false, Color.WHITE);
                    continue;
                }
                class_3545<class_1799, CustomArmorBar> am = armorPoints.get(count * 2 + stackRow);
                ((CustomArmorBar)am.method_15441()).drawOutLine((class_1799)am.method_15442(), matrices, xPos, yPos, false, false, Color.WHITE);
            }
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)DetailArmorBar.GUI_ARMOR_BAR);
        if (DetailArmorBar.getConfig().getOptions().toggleEnchants && totalEnchants > 0 && totalArmorPoint > 0) {
            for (int count = 0; count * 2 + 1 <= totalEnchants && count <= 9; ++count) {
                int xPos = screenWidth + count * 8;
                if (count * 2 + 1 < totalEnchants) {
                    int min = -1;
                    int max = -1;
                    for (int pw = 0; pw < 5; ++pw) {
                        if (min == -1 && protectArr[pw] > 1) {
                            min = pw;
                            break;
                        }
                        if (min == -1 && protectArr[pw] == 1) {
                            min = pw;
                            continue;
                        }
                        if (min == -1 || max != -1 || protectArr[pw] < 1) continue;
                        max = pw;
                    }
                    if (min != -1 && max != -1) {
                        this.drawEnchantTexture(matrices, xPos, yPos, ArmorBarRenderer.getProtectColor(protectArr), 2);
                        protectArr[min] = 0;
                        this.drawEnchantTexture(matrices, xPos, yPos, ArmorBarRenderer.getProtectColor(protectArr), 1);
                        int n = max;
                        protectArr[n] = protectArr[n] - 1;
                    } else {
                        this.drawEnchantTexture(matrices, xPos, yPos, ArmorBarRenderer.getProtectColor(protectArr), 0);
                        int n = min;
                        protectArr[n] = protectArr[n] - 2;
                    }
                }
                if (count * 2 + 1 != totalEnchants) continue;
                this.drawEnchantTexture(matrices, xPos, yPos, ArmorBarRenderer.getProtectColor(protectArr), 2);
            }
        }
        if (DetailArmorBar.getConfig().getOptions().toggleThorns && thorns.level > 0 && totalArmorPoint > 0) {
            Color thornsColor = ArmorBarRenderer.getThornColor();
            for (int count = 0; count < 10 && count * 2 + 1 <= thorns.level; ++count) {
                int xPos = screenWidth + count * 8;
                if (count * 2 + 1 < thorns.level) {
                    InGameDrawer.drawTexture(matrices, xPos, yPos, 36, 18, thornsColor, false);
                }
                if (count * 2 + 1 != thorns.level) continue;
                InGameDrawer.drawTexture(matrices, xPos, yPos, 27, 18, thornsColor, false);
            }
        }
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_332.field_22737);
    }

    private void drawEnchantTexture(class_4587 matrices, int x, int y, Color color, int half) {
        int u = 0;
        int v = 0;
        int t = this.hud.method_1738() / 3 % 36;
        if (DetailArmorBar.getConfig().getOptions().effectType == ConfigEnumType.ProtectionEffect.AURA) {
            if (t < 12) {
                u = t % 12 * 9;
                v = 27 + half * 9;
            }
        } else if (DetailArmorBar.getConfig().getOptions().effectType == ConfigEnumType.ProtectionEffect.OUTLINE) {
            u = 9 + half * 9;
        } else {
            return;
        }
        InGameDrawer.drawTexture(matrices, x, y, u, v, color, false);
    }

    static class LevelData {
        int level;
        int count;

        LevelData(int level, int count) {
            this.level = level;
            this.count = count;
        }
    }
}

