/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.detailab.api.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.redlimerl.detailab.DetailArmorBar;
import com.redlimerl.detailab.api.render.ArmorBarRenderManager;
import com.redlimerl.detailab.api.render.BarRenderManager;
import com.redlimerl.detailab.api.render.ItemBarRenderManager;
import com.redlimerl.detailab.api.render.TextureOffset;
import com.redlimerl.detailab.render.InGameDrawer;
import java.awt.Color;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public class CustomArmorBar {
    public static CustomArmorBar DEFAULT = new CustomArmorBar(itemStack -> new ArmorBarRenderManager(DetailArmorBar.GUI_ARMOR_BAR, 128, 128, new TextureOffset(63, 9 + DetailArmorBar.isVanillaTexture()), new TextureOffset(54, 9 + DetailArmorBar.isVanillaTexture()), new TextureOffset(9, 0), new TextureOffset(27, 0)));
    public static CustomArmorBar EMPTY = new CustomArmorBar(itemStack -> {
        if (DetailArmorBar.getConfig().getOptions().toggleEmptyBar) {
            return new ArmorBarRenderManager(DetailArmorBar.GUI_ARMOR_BAR, 128, 128, new TextureOffset(45, 0), new TextureOffset(45, 0), new TextureOffset(9, 0), new TextureOffset(27, 0));
        }
        return new ArmorBarRenderManager(DetailArmorBar.GUI_ARMOR_BAR, 128, 128, new TextureOffset(0, 0), new TextureOffset(0, 0), new TextureOffset(0, 0), new TextureOffset(0, 0));
    });
    private final Function<class_1799, ? extends BarRenderManager> predicate;

    public CustomArmorBar(Function<class_1799, ? extends BarRenderManager> predicate) {
        this.predicate = predicate;
    }

    public void draw(class_1799 itemStack, class_4587 matrices, int xPos, int yPos, boolean isHalf, boolean isMirror) {
        BarRenderManager renderInfo = this.predicate.apply(itemStack);
        if (renderInfo.isShown()) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)renderInfo.getTexture());
        if (isHalf) {
            InGameDrawer.drawTexture(matrices, xPos, yPos, renderInfo.getTextureOffsetHalf().x, renderInfo.getTextureOffsetHalf().y, renderInfo.getTextureWidth(), renderInfo.getTextureHeight(), renderInfo.getColor(), isMirror);
        } else {
            InGameDrawer.drawTexture(matrices, xPos, yPos, renderInfo.getTextureOffsetFull().x, renderInfo.getTextureOffsetFull().y, renderInfo.getTextureWidth(), renderInfo.getTextureHeight(), renderInfo.getColor(), false);
        }
    }

    public void drawOutLine(class_1799 itemStack, class_4587 matrices, int xPos, int yPos, boolean isHalf, boolean isMirror, Color color) {
        TextureOffset offset;
        BarRenderManager renderInfo = this.predicate.apply(itemStack);
        if (renderInfo.isShown()) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)renderInfo.getTexture());
        TextureOffset textureOffset = offset = isHalf ? renderInfo.getTextureOffsetOutlineHalf() : renderInfo.getTextureOffsetOutline();
        if (isHalf) {
            if (renderInfo instanceof ItemBarRenderManager) {
                InGameDrawer.drawTexture(matrices, xPos + 4, yPos, offset.x + 4, offset.y, 5, 9, renderInfo.getTextureWidth(), renderInfo.getTextureHeight(), color, false);
            } else {
                InGameDrawer.drawTexture(matrices, xPos, yPos, offset.x, offset.y, renderInfo.getTextureWidth(), renderInfo.getTextureHeight(), color, isMirror);
            }
        } else {
            InGameDrawer.drawTexture(matrices, xPos, yPos, offset.x, offset.y, renderInfo.getTextureWidth(), renderInfo.getTextureHeight(), color, false);
        }
    }
}

