/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.hud;

import com.google.common.collect.ImmutableList;
import dev.lambdaurora.spruceui.hud.HudComponent;
import dev.lambdaurora.spruceui.util.Identifiable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;

public abstract class Hud
extends class_332
implements Identifiable {
    protected final class_2960 identifier;
    protected final List<HudComponent> components = new ArrayList<HudComponent>();
    protected final String translationKey;
    private boolean enabled = true;
    protected boolean visible = true;

    public Hud(@NotNull class_2960 id) {
        this.identifier = id;
        this.translationKey = this.identifier.method_12836() + ".hud." + this.identifier.method_12832().replace('/', '.');
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            class_310 client = class_310.method_1551();
            this.init(client, client.method_22683().method_4486(), client.method_22683().method_4502());
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void init(@NotNull class_310 client, int screenWidth, int screenHeight) {
        this.components.clear();
    }

    public void render(class_4587 matrices, float tickDelta) {
        this.components.stream().filter(HudComponent::isEnabled).forEach(component -> component.render(matrices, tickDelta));
    }

    public void tick() {
        this.components.stream().filter(((Predicate<HudComponent>)HudComponent::hasTicks).and(HudComponent::isEnabled)).forEach(HudComponent::tick);
    }

    public boolean hasTicks() {
        return false;
    }

    @NotNull
    public List<HudComponent> getComponents() {
        return ImmutableList.copyOf(this.components);
    }

    @Override
    @NotNull
    public class_2960 getIdentifier() {
        return this.identifier;
    }
}

