/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.datagen;

import com.google.gson.JsonElement;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4916;
import net.minecraft.class_4917;
import net.minecraft.class_7403;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_4916.class})
public class ModelProviderMixin {
    @Unique
    private class_2403 generator;
    @Unique
    private static final ThreadLocal<class_2403> dataGeneratorThreadLocal = new ThreadLocal();
    @Unique
    private static ThreadLocal<Map<class_2248, class_4917>> blockStateMapThreadLocal = new ThreadLocal();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void init(class_2403 generator, CallbackInfo ci) {
        this.generator = generator;
    }

    @Redirect(method={"run"}, at=@At(value="INVOKE", target="Lnet/minecraft/data/client/BlockStateModelGenerator;register()V"))
    private void registerBlockStateModels(class_4910 instance) {
        ModelProviderMixin modelProviderMixin = this;
        if (modelProviderMixin instanceof FabricModelProvider) {
            FabricModelProvider fabricModelProvider = (FabricModelProvider)((Object)modelProviderMixin);
            fabricModelProvider.generateBlockStateModels(instance);
        } else {
            instance.method_25534();
        }
    }

    @Redirect(method={"run"}, at=@At(value="INVOKE", target="Lnet/minecraft/data/client/ItemModelGenerator;register()V"))
    private void registerItemModels(class_4915 instance) {
        ModelProviderMixin modelProviderMixin = this;
        if (modelProviderMixin instanceof FabricModelProvider) {
            FabricModelProvider fabricModelProvider = (FabricModelProvider)((Object)modelProviderMixin);
            fabricModelProvider.generateItemModels(instance);
        } else {
            instance.method_25731();
        }
    }

    @Inject(method={"run"}, at={@At(value="INVOKE_ASSIGN", target="com/google/common/collect/Maps.newHashMap()Ljava/util/HashMap;", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void runHead(class_7403 writer, CallbackInfo ci, Map<class_2248, class_4917> map) {
        dataGeneratorThreadLocal.set(this.generator);
        blockStateMapThreadLocal.set(map);
    }

    @Inject(method={"run"}, at={@At(value="TAIL")})
    private void runTail(class_7403 writer, CallbackInfo ci) {
        dataGeneratorThreadLocal.remove();
        blockStateMapThreadLocal.remove();
    }

    @Inject(method={"method_25738"}, at={@At(value="HEAD")}, cancellable=true)
    private static void filterBlocksForProcessingMod(Map<class_2248, class_4917> map, class_2248 block, CallbackInfoReturnable<Boolean> cir) {
        class_2403 class_24032 = dataGeneratorThreadLocal.get();
        if (class_24032 instanceof FabricDataGenerator) {
            FabricDataGenerator dataGenerator = (FabricDataGenerator)class_24032;
            if (!dataGenerator.isStrictValidationEnabled()) {
                cir.setReturnValue((Object)false);
                return;
            }
            if (!class_2378.field_11146.method_10221((Object)block).method_12836().equals(dataGenerator.getModId())) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"method_25741"}, at={@At(value="INVOKE", target="Lnet/minecraft/data/client/ModelIds;getItemModelId(Lnet/minecraft/item/Item;)Lnet/minecraft/util/Identifier;")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void filterItemsForProcessingMod(Set<class_1792> set, Map<class_2960, Supplier<JsonElement>> map, class_2248 block, CallbackInfo ci, class_1792 item) {
        class_2403 class_24032 = dataGeneratorThreadLocal.get();
        if (class_24032 instanceof FabricDataGenerator) {
            FabricDataGenerator dataGenerator = (FabricDataGenerator)class_24032;
            if (!blockStateMapThreadLocal.get().containsKey(block)) {
                ci.cancel();
                return;
            }
            if (!class_2378.field_11142.method_10221((Object)item).method_12836().equals(dataGenerator.getModId())) {
                ci.cancel();
            }
        }
    }
}

