/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoLuminanceFix;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractMeshConsumer;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractRenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.TerrainBlockRenderInfo;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.TerrainFallbackConsumer;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5539;
import net.minecraft.class_761;

public class WorldMesherRenderContext
extends AbstractRenderContext {
    private final TerrainBlockRenderInfo blockInfo = new TerrainBlockRenderInfo();
    private final AoCalculator aoCalc;
    private final AbstractMeshConsumer meshConsumer;
    private final TerrainFallbackConsumer fallbackConsumer;

    public WorldMesherRenderContext(class_1920 blockView, Function<class_1921, class_4588> bufferFunc) {
        this.blockInfo.setBlockView(blockView);
        this.aoCalc = new AoCalculator((BlockRenderInfo)this.blockInfo, pos -> class_761.method_23793((class_1920)blockView, (class_2680)blockView.method_8320(pos), (class_2338)pos), pos -> AoLuminanceFix.INSTANCE.apply((class_1922)blockView, pos));
        this.meshConsumer = new AbstractMeshConsumer((BlockRenderInfo)this.blockInfo, bufferFunc, this.aoCalc, arg_0 -> ((WorldMesherRenderContext)this).transform(arg_0)){

            protected int overlay() {
                return WorldMesherRenderContext.this.overlay;
            }

            protected class_1159 matrix() {
                return WorldMesherRenderContext.this.matrix;
            }

            protected class_4581 normalMatrix() {
                return WorldMesherRenderContext.this.normalMatrix;
            }
        };
        this.fallbackConsumer = new TerrainFallbackConsumer((BlockRenderInfo)this.blockInfo, bufferFunc, this.aoCalc, arg_0 -> ((WorldMesherRenderContext)this).transform(arg_0)){

            protected int overlay() {
                return WorldMesherRenderContext.this.overlay;
            }

            protected class_1159 matrix() {
                return WorldMesherRenderContext.this.matrix;
            }

            protected class_4581 normalMatrix() {
                return WorldMesherRenderContext.this.normalMatrix;
            }
        };
    }

    public void tessellateBlock(class_1920 blockView, class_2680 blockState, class_2338 blockPos, class_1087 model, class_4587 matrixStack) {
        this.matrix = matrixStack.method_23760().method_23761();
        this.normalMatrix = matrixStack.method_23760().method_23762();
        try {
            this.aoCalc.clear();
            this.blockInfo.prepareForBlock(blockState, blockPos, model.method_4708());
            ((FabricBakedModel)model).emitBlockQuads(this.blockInfo.blockView, this.blockInfo.blockState, this.blockInfo.blockPos, this.blockInfo.randomSupplier, (RenderContext)this);
        }
        catch (Throwable throwable) {
            class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Tessellating block in WorldMesher mesh");
            class_129 crashReportSection = crashReport.method_562("Block being tessellated");
            class_129.method_586((class_129)crashReportSection, (class_5539)blockView, (class_2338)blockPos, (class_2680)blockState);
            throw new class_148(crashReport);
        }
    }

    public Consumer<Mesh> meshConsumer() {
        return this.meshConsumer;
    }

    public Consumer<class_1087> fallbackConsumer() {
        return this.fallbackConsumer;
    }

    public QuadEmitter getEmitter() {
        return this.meshConsumer.getEmitter();
    }
}

