/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.worldmesher;

import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.worldmesher.DynamicRenderInfo;
import io.wispforest.worldmesher.renderers.WorldMesherBlockModelRenderer;
import io.wispforest.worldmesher.renderers.WorldMesherFluidRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.impl.client.indigo.renderer.IndigoRenderer;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.WorldMesherRenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_776;

public class WorldMesh {
    private final class_1937 world;
    private final class_2338 origin;
    private final class_2338 end;
    private final boolean cull;
    private final class_238 dimensions;
    private MeshState state = MeshState.NEW;
    private float buildProgress = 0.0f;
    private final Map<class_1921, class_291> bufferStorage;
    private final Map<class_1921, class_287> initializedLayers;
    private DynamicRenderInfo renderInfo;
    private boolean entitiesFrozen;
    private boolean freezeEntities;
    private final Runnable renderStartAction;
    private final Runnable renderEndAction;
    private Supplier<class_4587> matrixStackSupplier = class_4587::new;

    private WorldMesh(class_1937 world, class_2338 origin, class_2338 end, boolean cull, boolean freezeEntities, Runnable renderStartAction, Runnable renderEndAction) {
        this.world = world;
        this.origin = origin;
        this.end = end;
        this.cull = cull;
        this.freezeEntities = freezeEntities;
        this.dimensions = new class_238(this.origin, this.end);
        this.renderStartAction = renderStartAction;
        this.renderEndAction = renderEndAction;
        this.bufferStorage = new HashMap<class_1921, class_291>();
        this.initializedLayers = new HashMap<class_1921, class_287>();
        this.renderInfo = new DynamicRenderInfo();
        this.scheduleRebuild();
    }

    public void render(class_4587 matrices) {
        class_1159 matrix = matrices.method_23760().method_23761();
        if (!this.canRender()) {
            throw new IllegalStateException("World mesh not prepared!");
        }
        class_1921 translucent = class_1921.method_23583();
        this.bufferStorage.forEach((renderLayer, vertexBuffer) -> {
            if (renderLayer == translucent) {
                return;
            }
            this.draw((class_1921)renderLayer, (class_291)vertexBuffer, matrix);
        });
        if (this.bufferStorage.containsKey(translucent)) {
            this.draw(translucent, this.bufferStorage.get(translucent), matrix);
        }
        class_291.method_1354();
    }

    public void setMatrixStackSupplier(Supplier<class_4587> stackSupplier) {
        this.matrixStackSupplier = stackSupplier;
    }

    public boolean canRender() {
        return this.state.canRender;
    }

    public MeshState getState() {
        return this.state;
    }

    public float getBuildProgress() {
        return this.buildProgress;
    }

    public DynamicRenderInfo getRenderInfo() {
        return this.renderInfo;
    }

    public class_2338 startPos() {
        return this.origin;
    }

    public class_2338 endPos() {
        return this.end;
    }

    public boolean entitiesFrozen() {
        return this.entitiesFrozen;
    }

    public void setFreezeEntities(boolean freezeEntities) {
        this.freezeEntities = freezeEntities;
    }

    public class_238 dimensions() {
        return this.dimensions;
    }

    public void scheduleRebuild() {
        if (this.state.isBuildStage) {
            return;
        }
        this.state = this.state == MeshState.NEW ? MeshState.BUILDING : MeshState.REBUILDING;
        this.initializedLayers.clear();
        CompletableFuture.runAsync(this::build, class_156.method_18349()).whenComplete((unused, throwable) -> {
            if (throwable != null) {
                throwable.printStackTrace();
                this.state = MeshState.NEW;
            } else {
                this.state = MeshState.READY;
            }
        });
    }

    private void build() {
        class_310 client = class_310.method_1551();
        class_776 blockRenderManager = client.method_1541();
        WorldMesherBlockModelRenderer blockRenderer = new WorldMesherBlockModelRenderer();
        WorldMesherFluidRenderer fluidRenderer = new WorldMesherFluidRenderer();
        class_4587 matrices = this.matrixStackSupplier.get();
        WorldMesherRenderContext renderContext = RendererAccess.INSTANCE.getRenderer() instanceof IndigoRenderer ? new WorldMesherRenderContext((class_1920)this.world, this::getOrCreateBuffer) : null;
        class_5819 random = class_5819.method_43053();
        ArrayList<class_2338> possess = new ArrayList<class_2338>();
        for (class_2338 pos : class_2338.method_10097((class_2338)this.origin, (class_2338)this.end)) {
            possess.add(pos.method_10062());
        }
        int blocksToBuild = possess.size();
        DynamicRenderInfo.Mutable tempRenderInfo = new DynamicRenderInfo.Mutable();
        this.entitiesFrozen = this.freezeEntities;
        CompletableFuture entitiesFuture = new CompletableFuture();
        client.execute(() -> entitiesFuture.complete(client.field_1687.method_8333((class_1297)client.field_1724, new class_238(this.origin, this.end).method_1014(0.5), entity -> !(entity instanceof class_1657)).stream().map(entity -> {
            if (this.freezeEntities) {
                class_1297 originalEntity = entity;
                entity = entity.method_5864().method_5883((class_1937)client.field_1687);
                entity.method_5878(originalEntity);
                entity.method_5719(originalEntity);
                entity.method_5773();
            }
            return new DynamicRenderInfo.EntityEntry((class_1297)entity, client.method_1561().method_23839(entity, 0.0f));
        }).toList()));
        for (int i = 0; i < blocksToBuild; ++i) {
            class_2338 pos = (class_2338)possess.get(i);
            class_2338 renderPos = pos.method_10059((class_2382)this.origin);
            class_2680 state = this.world.method_8320(pos);
            if (state.method_26215()) continue;
            if (this.world.method_8321(pos) != null) {
                tempRenderInfo.addBlockEntity(renderPos, this.world.method_8321(pos));
            }
            if (!this.world.method_8316(pos).method_15769()) {
                class_3610 fluidState = this.world.method_8316(pos);
                class_1921 fluidLayer = class_4696.method_23680((class_3610)fluidState);
                matrices.method_22903();
                matrices.method_22904((double)(-(pos.method_10263() & 0xF)), (double)(-(pos.method_10264() & 0xF)), (double)(-(pos.method_10260() & 0xF)));
                matrices.method_22904((double)renderPos.method_10263(), (double)renderPos.method_10264(), (double)renderPos.method_10260());
                fluidRenderer.setMatrix(matrices.method_23760().method_23761());
                fluidRenderer.method_3347((class_1920)this.world, pos, this.getOrCreateBuffer(fluidLayer), state, fluidState);
                matrices.method_22909();
            }
            matrices.method_22903();
            matrices.method_22904((double)renderPos.method_10263(), (double)renderPos.method_10264(), (double)renderPos.method_10260());
            blockRenderer.clearCullingOverrides();
            blockRenderer.setCullDirection(class_2350.field_11034, pos.method_10263() == this.end.method_10263());
            blockRenderer.setCullDirection(class_2350.field_11039, pos.method_10263() == this.origin.method_10263());
            blockRenderer.setCullDirection(class_2350.field_11035, pos.method_10260() == this.end.method_10260());
            blockRenderer.setCullDirection(class_2350.field_11043, pos.method_10260() == this.origin.method_10260());
            blockRenderer.setCullDirection(class_2350.field_11036, pos.method_10264() == this.end.method_10264());
            blockRenderer.setCullDirection(class_2350.field_11033, pos.method_10264() == this.origin.method_10264());
            class_1921 renderLayer = class_4696.method_23679((class_2680)state);
            class_1087 model = blockRenderManager.method_3349(state);
            if (!((FabricBakedModel)model).isVanillaAdapter() && renderContext != null) {
                renderContext.tessellateBlock((class_1920)this.world, state, pos, model, matrices);
            } else {
                blockRenderer.method_3374((class_1920)this.world, model, state, pos, matrices, this.getOrCreateBuffer(renderLayer), this.cull, random, state.method_26190(pos), class_4608.field_21444);
            }
            matrices.method_22909();
            this.buildProgress = (float)i / (float)blocksToBuild;
        }
        if (this.initializedLayers.containsKey(class_1921.method_23583())) {
            class_287 translucentBuilder = this.initializedLayers.get(class_1921.method_23583());
            class_4184 camera = client.field_1773.method_19418();
            translucentBuilder.method_31948((float)camera.method_19326().field_1352 - (float)this.origin.method_10263(), (float)camera.method_19326().field_1351 - (float)this.origin.method_10264(), (float)camera.method_19326().field_1350 - (float)this.origin.method_10260());
        }
        CompletableFuture future = new CompletableFuture();
        RenderSystem.recordRenderCall(() -> {
            this.initializedLayers.forEach((renderLayer, bufferBuilder) -> {
                class_291 vertexBuffer = new class_291();
                vertexBuffer.method_1353();
                vertexBuffer.method_1352(bufferBuilder.method_1326());
                this.bufferStorage.put((class_1921)renderLayer, vertexBuffer);
            });
            future.complete(null);
        });
        future.join();
        ((List)entitiesFuture.join()).forEach(entry -> tempRenderInfo.addEntity(entry.entity().method_19538().method_1023((double)this.origin.method_10263(), (double)this.origin.method_10264(), (double)this.origin.method_10260()), (DynamicRenderInfo.EntityEntry)entry));
        this.renderInfo = tempRenderInfo.toImmutable();
    }

    private class_4588 getOrCreateBuffer(class_1921 layer) {
        if (!this.initializedLayers.containsKey(layer)) {
            class_287 builder = new class_287(layer.method_22722());
            this.initializedLayers.put(layer, builder);
            builder.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
        }
        return (class_4588)this.initializedLayers.get(layer);
    }

    private void draw(class_1921 renderLayer, class_291 vertexBuffer, class_1159 matrix) {
        renderLayer.method_23516();
        this.renderStartAction.run();
        vertexBuffer.method_1353();
        vertexBuffer.method_34427(matrix, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
        this.renderEndAction.run();
        renderLayer.method_23518();
    }

    public static enum MeshState {
        NEW(false, false),
        BUILDING(true, false),
        REBUILDING(true, true),
        READY(false, true);

        public final boolean isBuildStage;
        public final boolean canRender;

        private MeshState(boolean buildStage, boolean canRender) {
            this.isBuildStage = buildStage;
            this.canRender = canRender;
        }
    }

    public static class Builder {
        private final class_1937 world;
        private final class_2338 origin;
        private final class_2338 end;
        private boolean cull = true;
        private boolean freezeEntities = false;
        private Runnable startAction = () -> {};
        private Runnable endAction = () -> {};

        public Builder(class_1937 world, class_2338 origin, class_2338 end) {
            this.world = world;
            this.origin = origin;
            this.end = end;
        }

        public Builder disableCulling() {
            this.cull = false;
            return this;
        }

        public Builder freezeEntities() {
            this.freezeEntities = true;
            return this;
        }

        public Builder renderActions(Runnable startAction, Runnable endAction) {
            this.startAction = startAction;
            this.endAction = endAction;
            return this;
        }

        public WorldMesh build() {
            class_2338 start = new class_2338(Math.min(this.origin.method_10263(), this.end.method_10263()), Math.min(this.origin.method_10264(), this.end.method_10264()), Math.min(this.origin.method_10260(), this.end.method_10260()));
            class_2338 target = new class_2338(Math.max(this.origin.method_10263(), this.end.method_10263()), Math.max(this.origin.method_10264(), this.end.method_10264()), Math.max(this.origin.method_10260(), this.end.method_10260()));
            return new WorldMesh(this.world, start, target, this.cull, this.freezeEntities, this.startAction, this.endAction);
        }
    }
}

