/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.api.event;

import java.awt.geom.Point2D;
import journeymap.client.api.event.ClientEvent;
import journeymap.client.api.model.IBlockInfo;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5321;

public class FullscreenMapEvent
extends ClientEvent {
    private final class_2338 location;

    private FullscreenMapEvent(ClientEvent.Type type, class_2338 location, class_5321<class_1937> level) {
        super(type, level);
        this.location = location;
    }

    public class_2338 getLocation() {
        return this.location;
    }

    public class_5321<class_1937> getLevel() {
        return this.dimension;
    }

    public static enum Stage {
        PRE,
        POST;

    }

    public static class MouseMoveEvent
    extends FullscreenMapEvent {
        private final Point2D.Double mousePosition;
        private final IBlockInfo info;

        public MouseMoveEvent(class_5321<class_1937> level, IBlockInfo info, Point2D.Double mousePosition) {
            super(ClientEvent.Type.MAP_MOUSE_MOVED, info.getBlockPos(), level);
            this.mousePosition = mousePosition;
            this.info = info;
        }

        public Point2D.Double getMousePosition() {
            return this.mousePosition;
        }

        public double getMouseX() {
            return this.mousePosition.x;
        }

        public double getMouseY() {
            return this.mousePosition.y;
        }

        public IBlockInfo getInfo() {
            return this.info;
        }
    }

    public static class MouseDraggedEvent
    extends FullscreenMapEvent {
        private final int button;
        private final Point2D.Double mousePosition;
        private final Stage stage;

        public MouseDraggedEvent(Stage stage, class_2338 location, class_5321<class_1937> level, Point2D.Double mousePosition, int button) {
            super(ClientEvent.Type.MAP_DRAGGED, location, level);
            this.stage = stage;
            this.mousePosition = mousePosition;
            this.button = button;
        }

        public Stage getStage() {
            return this.stage;
        }

        public double getMouseX() {
            return this.mousePosition.x;
        }

        public double getMouseY() {
            return this.mousePosition.y;
        }

        public Point2D.Double getMousePosition() {
            return this.mousePosition;
        }

        public int getButton() {
            return this.button;
        }

        public static class Post
        extends MouseDraggedEvent {
            public Post(class_2338 location, class_5321<class_1937> level, Point2D.Double mousePosition, int button) {
                super(Stage.POST, location, level, mousePosition, button);
            }

            @Override
            public boolean isCancellable() {
                return false;
            }
        }

        public static class Pre
        extends MouseDraggedEvent {
            public Pre(class_2338 location, class_5321<class_1937> level, Point2D.Double mousePosition, int button) {
                super(Stage.PRE, location, level, mousePosition, button);
            }
        }
    }

    public static class ClickEvent
    extends FullscreenMapEvent {
        private final int button;
        private final Point2D.Double mousePosition;
        private final Stage stage;

        public ClickEvent(Stage stage, class_2338 location, class_5321<class_1937> level, Point2D.Double mousePosition, int button) {
            super(ClientEvent.Type.MAP_CLICKED, location, level);
            this.stage = stage;
            this.mousePosition = mousePosition;
            this.button = button;
        }

        public Stage getStage() {
            return this.stage;
        }

        public double getMouseX() {
            return this.mousePosition.x;
        }

        public double getMouseY() {
            return this.mousePosition.y;
        }

        public Point2D.Double getMousePosition() {
            return this.mousePosition;
        }

        public int getButton() {
            return this.button;
        }

        public static class Post
        extends ClickEvent {
            public Post(class_2338 location, class_5321<class_1937> level, Point2D.Double mousePosition, int button) {
                super(Stage.POST, location, level, mousePosition, button);
            }

            @Override
            public boolean isCancellable() {
                return false;
            }
        }

        public static class Pre
        extends ClickEvent {
            public Pre(class_2338 location, class_5321<class_1937> level, Point2D.Double mousePosition, int button) {
                super(Stage.PRE, location, level, mousePosition, button);
            }
        }
    }
}

