/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.rewrites.chunkio.common;

import com.ishland.c2me.base.ModuleEntryPoint;
import com.ishland.c2me.base.common.GlobalExecutors;
import com.ishland.c2me.base.common.scheduler.PriorityUtils;
import com.ishland.c2me.base.common.util.SneakyThrow;
import com.ishland.c2me.base.mixin.access.IRegionBasedStorage;
import com.ishland.c2me.base.mixin.access.IRegionFile;
import com.ishland.c2me.opts.chunkio.common.ConfigConstants;
import com.ishland.c2me.rewrites.chunkio.common.RawByteArrayOutputStream;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongFunction;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2861;
import net.minecraft.class_2867;
import net.minecraft.class_6836;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C2MEStorageThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"C2ME Storage");
    private static final AtomicLong SERIAL = new AtomicLong(0L);
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();
    private final class_2867 storage;
    private final LongFunction<IntSupplier> priorityProvider;
    private final Long2ObjectLinkedOpenHashMap<class_2487> writeBacklog = new Long2ObjectLinkedOpenHashMap();
    private final Long2ObjectOpenHashMap<class_2487> cache = new Long2ObjectOpenHashMap();
    private final Queue<ReadRequest> pendingReadRequests;
    private final Semaphore readSemaphore = new Semaphore((int)ModuleEntryPoint.globalExecutorParallelism + 1);
    private final ConcurrentLinkedQueue<WriteRequest> pendingWriteRequests = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Runnable> pendingTasks = new ConcurrentLinkedQueue();
    private final Executor executor = command -> {
        if (Thread.currentThread() == this) {
            command.run();
        } else {
            this.pendingTasks.add(command);
            LockSupport.unpark(this);
        }
    };
    private final ObjectArraySet<CompletableFuture<Void>> writeFutures = new ObjectArraySet();
    private long lastRebuild = 0L;
    private long lastPrioritySerial = 0L;
    private final ObjectArrayList<ReadRequest> priorityChangeTmpStorage = new ObjectArrayList();

    public C2MEStorageThread(Path directory, boolean dsync, String name, LongFunction<IntSupplier> priorityProvider) {
        this.storage = new class_2867(directory, dsync);
        this.priorityProvider = priorityProvider;
        this.pendingReadRequests = this.priorityProvider != null ? new PriorityBlockingQueue<ReadRequest>() : new ConcurrentLinkedQueue<ReadRequest>();
        this.setName("C2ME Storage #%d".formatted(SERIAL.incrementAndGet()));
        this.setDaemon(true);
        this.setUncaughtExceptionHandler((t, e) -> LOGGER.error("Thread %s died".formatted(t), e));
        this.start();
    }

    @Override
    public void run() {
        while (true) {
            boolean hasWork = false;
            hasWork = this.handleTasks() || hasWork;
            hasWork = this.handlePendingWrites() || hasWork;
            hasWork = this.handlePendingReads() || hasWork;
            hasWork = this.writeBacklog() || hasWork;
            this.runWriteFutureGC();
            if (hasWork) continue;
            if (this.closing.get()) {
                this.flush0(true);
                try {
                    this.storage.close();
                }
                catch (Throwable t) {
                    LOGGER.error("Error closing storage", t);
                }
                break;
            }
            LockSupport.parkNanos("Waiting for tasks", 10000000L);
        }
        this.closeFuture.complete(null);
        LOGGER.info("Storage thread {} stopped", (Object)this);
    }

    public CompletableFuture<class_2487> getChunkData(long pos, class_6836 scanner) {
        CompletableFuture<class_2487> future = new CompletableFuture<class_2487>();
        this.pendingReadRequests.add(new ReadRequest(pos, future, scanner, this.priorityProvider != null ? this.priorityProvider.apply(pos) : null));
        LockSupport.unpark(this);
        return future.thenApply(Function.identity());
    }

    public void setChunkData(long pos, @Nullable class_2487 nbt) {
        this.pendingWriteRequests.add(new WriteRequest(pos, nbt));
        LockSupport.unpark(this);
    }

    public CompletableFuture<Void> flush(boolean sync) {
        return CompletableFuture.runAsync(() -> this.flush0(sync), this.executor);
    }

    private void flush0(boolean sync) {
        try {
            do {
                this.runWriteFutureGC();
                this.doPriorityChanges();
            } while (this.handleTasks() || this.handlePendingReads() || this.handlePendingWrites() || this.writeBacklog());
            this.flushBacklog();
            if (sync) {
                this.storage.method_26982();
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error flushing storage", t);
        }
    }

    public CompletableFuture<Void> close() {
        this.closing.set(true);
        LockSupport.unpark(this);
        return this.closeFuture.thenApply(Function.identity());
    }

    private boolean handleTasks() {
        Runnable runnable;
        boolean hasWork = false;
        while ((runnable = this.pendingTasks.poll()) != null) {
            hasWork = true;
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOGGER.error("Error while executing task", t);
            }
        }
        return hasWork;
    }

    private boolean handlePendingWrites() {
        WriteRequest writeRequest;
        boolean hasWork = false;
        while ((writeRequest = this.pendingWriteRequests.poll()) != null) {
            hasWork = true;
            this.cache.put(writeRequest.pos, (Object)writeRequest.nbt);
            this.writeBacklog.put(writeRequest.pos, (Object)writeRequest.nbt);
        }
        return hasWork;
    }

    private boolean handlePendingReads() {
        boolean hasWork = false;
        while (!this.pendingReadRequests.isEmpty() && this.readSemaphore.tryAcquire()) {
            ReadRequest readRequest = this.pendingReadRequests.poll();
            hasWork = true;
            assert (readRequest != null);
            long pos = readRequest.pos;
            CompletableFuture<class_2487> future = readRequest.future;
            class_6836 scanner = readRequest.scanner;
            class_2487 cached = (class_2487)this.cache.get(pos);
            if (cached != null) {
                future.complete(cached);
                this.readSemaphore.release();
                continue;
            }
            this.scheduleChunkRead(pos, future, scanner);
        }
        return hasWork;
    }

    private boolean writeBacklog() {
        if (!this.writeBacklog.isEmpty()) {
            long pos = this.writeBacklog.firstLongKey();
            class_2487 nbt = (class_2487)this.writeBacklog.removeFirst();
            this.writeChunk(pos, nbt);
            return true;
        }
        return false;
    }

    private void runWriteFutureGC() {
        this.writeFutures.removeIf(CompletableFuture::isDone);
    }

    private void doPriorityChanges() {
        Queue<ReadRequest> queue = this.pendingReadRequests;
        if (queue instanceof PriorityBlockingQueue) {
            PriorityBlockingQueue queue2 = (PriorityBlockingQueue)queue;
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis > this.lastRebuild + 500L) {
                this.lastRebuild = currentTimeMillis;
                int currentPrioritySerial = PriorityUtils.priorityChangeSerial();
                if (this.lastPrioritySerial != (long)currentPrioritySerial) {
                    this.lastPrioritySerial = currentPrioritySerial;
                    long startTime = System.nanoTime();
                    this.priorityChangeTmpStorage.clear();
                    queue2.drainTo(this.priorityChangeTmpStorage);
                    queue2.addAll(this.priorityChangeTmpStorage);
                    this.priorityChangeTmpStorage.clear();
                }
            }
        }
    }

    private void flushBacklog() {
        while (!this.writeFutures.isEmpty()) {
            while (this.writeBacklog()) {
            }
            this.runWriteFutureGC();
            CompletableFuture<Void> allFuture = CompletableFuture.allOf((CompletableFuture[])this.writeFutures.stream().map(future -> future.exceptionally(unused -> null)).distinct().toArray(CompletableFuture[]::new));
            while (!allFuture.isDone()) {
                this.handleTasks();
            }
            this.runWriteFutureGC();
        }
    }

    private void scheduleChunkRead(long pos, CompletableFuture<class_2487> future, class_6836 scanner) {
        class_2487 cached = (class_2487)this.cache.get(pos);
        if (cached != null) {
            if (scanner != null) {
                cached.method_39876(scanner);
                this.readSemaphore.release();
                future.complete(null);
                return;
            }
            this.readSemaphore.release();
            future.complete(cached);
            return;
        }
        try {
            class_1923 pos1 = new class_1923(pos);
            class_2861 regionFile = ((IRegionBasedStorage)this.storage).invokeGetRegionFile(pos1);
            DataInputStream chunkInputStream = regionFile.method_21873(pos1);
            if (chunkInputStream == null) {
                future.complete(null);
                this.readSemaphore.release();
                return;
            }
            CompletableFuture.supplyAsync(() -> {
                try (DataInputStream inputStream = chunkInputStream;){
                    if (scanner != null) {
                        class_2507.method_39855((DataInput)inputStream, (class_6836)scanner);
                        class_2487 class_24873 = null;
                        return class_24873;
                    }
                    class_2487 class_24872 = class_2507.method_10627((DataInput)inputStream);
                    return class_24872;
                }
                catch (Throwable t) {
                    SneakyThrow.sneaky((Throwable)t);
                    return null;
                }
            }, GlobalExecutors.executor).handle((compound, throwable) -> {
                this.readSemaphore.release();
                if (throwable != null) {
                    future.completeExceptionally((Throwable)throwable);
                } else {
                    future.complete((class_2487)compound);
                }
                return null;
            });
        }
        catch (Throwable t) {
            this.readSemaphore.release();
            future.completeExceptionally(t);
        }
    }

    private void writeChunk(long pos, class_2487 nbt) {
        if (nbt == null) {
            try {
                class_1923 pos1 = new class_1923(pos);
                class_2861 regionFile = ((IRegionBasedStorage)this.storage).invokeGetRegionFile(pos1);
                regionFile.method_31740(pos1);
            }
            catch (Throwable t) {
                LOGGER.error("Error writing chunk %s".formatted(new class_1923(pos)), t);
            }
        } else {
            CompletionStage future = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                try {
                    RawByteArrayOutputStream out = new RawByteArrayOutputStream(8096);
                    out.write(0);
                    out.write(0);
                    out.write(0);
                    out.write(0);
                    out.write(ConfigConstants.CHUNK_STREAM_VERSION.method_21882());
                    try (DataOutputStream dataOutputStream = new DataOutputStream(ConfigConstants.CHUNK_STREAM_VERSION.method_21886((OutputStream)out));){
                        class_2507.method_10628((class_2487)nbt, (DataOutput)dataOutputStream);
                    }
                    return out;
                }
                catch (Throwable t) {
                    SneakyThrow.sneaky((Throwable)t);
                    return null;
                }
            }, GlobalExecutors.executor).thenAcceptAsync(bytes -> {
                if (nbt == this.cache.get(pos)) {
                    try {
                        class_1923 pos1 = new class_1923(pos);
                        class_2861 regionFile = ((IRegionBasedStorage)this.storage).invokeGetRegionFile(pos1);
                        ByteBuffer byteBuffer = bytes.asByteBuffer();
                        byteBuffer.putInt(0, bytes.size() - 5 + 1);
                        ((IRegionFile)regionFile).invokeWriteChunk(pos1, byteBuffer);
                    }
                    catch (Throwable t) {
                        SneakyThrow.sneaky((Throwable)t);
                    }
                }
            }, this.executor)).handleAsync((unused, throwable) -> {
                if (throwable != null) {
                    LOGGER.error("Error writing chunk %s".formatted(new class_1923(pos)), throwable);
                }
                this.cache.remove(pos);
                return null;
            }, this.executor);
            this.writeFutures.add((Object)future);
        }
    }

    private record ReadRequest(long pos, CompletableFuture<class_2487> future, @Nullable class_6836 scanner, @Nullable IntSupplier priorityProvider) implements Comparable<ReadRequest>
    {
        @Override
        public int compareTo(@NotNull ReadRequest o) {
            return Integer.compare(this.priorityProvider != null ? this.priorityProvider.getAsInt() : 0, o.priorityProvider != null ? o.priorityProvider.getAsInt() : 0);
        }
    }

    private record WriteRequest(long pos, class_2487 nbt) {
    }
}

