/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.registry.sync;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.fabricmc.fabric.api.event.registry.RegistryEntryRemovedCallback;
import net.fabricmc.fabric.api.event.registry.RegistryIdRemapCallback;
import net.fabricmc.fabric.impl.registry.sync.ListenableRegistry;
import net.fabricmc.fabric.impl.registry.sync.RemapException;
import net.fabricmc.fabric.impl.registry.sync.RemapStateImpl;
import net.fabricmc.fabric.impl.registry.sync.RemappableRegistry;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2370.class})
public abstract class MixinIdRegistry<T>
extends class_2378<T>
implements RemappableRegistry,
ListenableRegistry<T> {
    @Shadow
    @Final
    private ObjectList<class_6880.class_6883<T>> field_26682;
    @Shadow
    @Final
    private Object2IntMap<T> field_26683;
    @Shadow
    @Final
    private Map<class_2960, class_6880.class_6883<T>> field_11107;
    @Shadow
    @Final
    private Map<class_5321<T>, class_6880.class_6883<T>> field_25067;
    @Shadow
    private int field_11109;
    @Unique
    private static Logger FABRIC_LOGGER = LoggerFactory.getLogger(MixinIdRegistry.class);
    @Unique
    private final Event<RegistryEntryAddedCallback<T>> fabric_addObjectEvent = EventFactory.createArrayBacked(RegistryEntryAddedCallback.class, callbacks -> (rawId, id, object) -> {
        for (RegistryEntryAddedCallback callback : callbacks) {
            callback.onEntryAdded(rawId, id, object);
        }
    });
    @Unique
    private final Event<RegistryEntryRemovedCallback<T>> fabric_removeObjectEvent = EventFactory.createArrayBacked(RegistryEntryRemovedCallback.class, callbacks -> (rawId, id, object) -> {
        for (RegistryEntryRemovedCallback callback : callbacks) {
            callback.onEntryRemoved(rawId, id, object);
        }
    });
    @Unique
    private final Event<RegistryIdRemapCallback<T>> fabric_postRemapEvent = EventFactory.createArrayBacked(RegistryIdRemapCallback.class, callbacks -> a -> {
        for (RegistryIdRemapCallback callback : callbacks) {
            callback.onRemap(a);
        }
    });
    @Unique
    private Object2IntMap<class_2960> fabric_prevIndexedEntries;
    @Unique
    private BiMap<class_2960, class_6880.class_6883<T>> fabric_prevEntries;
    @Unique
    private boolean fabric_isObjectNew = false;

    @Shadow
    public abstract Optional<class_5321<T>> method_29113(T var1);

    @Shadow
    @Nullable
    public abstract T method_10223(@Nullable class_2960 var1);

    public MixinIdRegistry(class_5321<? extends class_2378<T>> key, Lifecycle lifecycle) {
        super(key, lifecycle);
    }

    @Override
    public Event<RegistryEntryAddedCallback<T>> fabric_getAddObjectEvent() {
        return this.fabric_addObjectEvent;
    }

    @Override
    public Event<RegistryEntryRemovedCallback<T>> fabric_getRemoveObjectEvent() {
        return this.fabric_removeObjectEvent;
    }

    @Override
    public Event<RegistryIdRemapCallback<T>> fabric_getRemapEvent() {
        return this.fabric_postRemapEvent;
    }

    @Inject(method={"set(ILnet/minecraft/util/registry/RegistryKey;Ljava/lang/Object;Lcom/mojang/serialization/Lifecycle;Z)Lnet/minecraft/util/registry/RegistryEntry;"}, at={@At(value="HEAD")})
    public void setPre(int id, class_5321<T> registryId, T object, Lifecycle lifecycle, boolean checkDuplicateKeys, CallbackInfoReturnable<T> info) {
        int indexedEntriesId = this.field_26683.getInt(object);
        if (indexedEntriesId >= 0) {
            throw new RuntimeException("Attempted to register object " + object + " twice! (at raw IDs " + indexedEntriesId + " and " + id + " )");
        }
        if (!this.field_11107.containsKey(registryId.method_29177())) {
            this.fabric_isObjectNew = true;
        } else {
            class_6880.class_6883<T> oldObject = this.field_11107.get(registryId.method_29177());
            if (oldObject != null && oldObject != object) {
                int oldId = this.field_26683.getInt(oldObject);
                if (oldId != id && checkDuplicateKeys) {
                    throw new RuntimeException("Attempted to register ID " + registryId + " at different raw IDs (" + oldId + ", " + id + ")! If you're trying to override an item, use .set(), not .register()!");
                }
                ((RegistryEntryRemovedCallback)this.fabric_removeObjectEvent.invoker()).onEntryRemoved(oldId, registryId.method_29177(), oldObject.comp_349());
                this.fabric_isObjectNew = true;
            } else {
                this.fabric_isObjectNew = false;
            }
        }
    }

    @Inject(method={"set(ILnet/minecraft/util/registry/RegistryKey;Ljava/lang/Object;Lcom/mojang/serialization/Lifecycle;Z)Lnet/minecraft/util/registry/RegistryEntry;"}, at={@At(value="RETURN")})
    public void setPost(int id, class_5321<T> registryId, T object, Lifecycle lifecycle, boolean checkDuplicateKeys, CallbackInfoReturnable<T> info) {
        if (this.fabric_isObjectNew) {
            ((RegistryEntryAddedCallback)this.fabric_addObjectEvent.invoker()).onEntryAdded(id, registryId.method_29177(), object);
        }
    }

    @Override
    public void remap(String name, Object2IntMap<class_2960> remoteIndexedEntries, RemappableRegistry.RemapMode mode) throws RemapException {
        IntIterator id2;
        Iterator o;
        switch (mode) {
            case AUTHORITATIVE: {
                break;
            }
            case REMOTE: {
                ArrayList<CallSite> strings = null;
                for (Object remoteId2 : remoteIndexedEntries.keySet()) {
                    if (this.field_11107.containsKey(remoteId2)) continue;
                    if (strings == null) {
                        strings = new ArrayList<CallSite>();
                    }
                    strings.add((CallSite)((Object)(" - " + (class_2960)remoteId2)));
                }
                if (strings == null) break;
                StringBuilder builder = new StringBuilder("Received ID map for " + name + " contains IDs unknown to the receiver!");
                for (String string : strings) {
                    builder.append('\n').append(string);
                }
                throw new RemapException(builder.toString());
            }
            case EXACT: {
                if (this.field_11107.keySet().equals(remoteIndexedEntries.keySet())) break;
                ArrayList<CallSite> strings2 = new ArrayList<CallSite>();
                for (class_2960 remoteId : remoteIndexedEntries.keySet()) {
                    if (this.field_11107.containsKey(remoteId)) continue;
                    strings2.add((CallSite)((Object)(" - " + remoteId + " (missing on local)")));
                }
                for (Object localId : this.method_10235()) {
                    if (remoteIndexedEntries.containsKey(localId)) continue;
                    strings2.add((CallSite)((Object)(" - " + (class_2960)localId + " (missing on remote)")));
                }
                StringBuilder builder = new StringBuilder("Local and remote ID sets for " + name + " do not match!");
                for (String string : strings2) {
                    builder.append('\n').append(string);
                }
                throw new RemapException(builder.toString());
            }
        }
        if (this.fabric_prevIndexedEntries == null) {
            this.fabric_prevIndexedEntries = new Object2IntOpenHashMap();
            this.fabric_prevEntries = HashBiMap.create(this.field_11107);
            Iterator strings2 = this.iterator();
            while (strings2.hasNext()) {
                o = strings2.next();
                this.fabric_prevIndexedEntries.put((Object)this.method_10221(o), this.method_10206(o));
            }
        }
        Int2ObjectOpenHashMap oldIdMap = new Int2ObjectOpenHashMap();
        o = this.iterator();
        while (o.hasNext()) {
            Object o2 = o.next();
            oldIdMap.put(this.method_10206(o2), (Object)this.method_10221(o2));
        }
        switch (mode) {
            case AUTHORITATIVE: {
                int maxValue = 0;
                Object2IntOpenHashMap oldRemoteIndexedEntries = remoteIndexedEntries;
                remoteIndexedEntries = new Object2IntOpenHashMap();
                for (class_2960 id2 : oldRemoteIndexedEntries.keySet()) {
                    int v = oldRemoteIndexedEntries.getInt((Object)id2);
                    remoteIndexedEntries.put((Object)id2, v);
                    if (v <= maxValue) continue;
                    maxValue = v;
                }
                for (IntIterator id2 : this.method_10235()) {
                    if (remoteIndexedEntries.containsKey((Object)id2)) continue;
                    FABRIC_LOGGER.warn("Adding " + (class_2960)id2 + " to saved/remote registry.");
                    remoteIndexedEntries.put((Object)id2, ++maxValue);
                }
                break;
            }
            case REMOTE: {
                int maxId = -1;
                for (class_2960 class_29602 : this.method_10235()) {
                    if (remoteIndexedEntries.containsKey((Object)class_29602)) continue;
                    if (maxId < 0) {
                        id2 = remoteIndexedEntries.values().iterator();
                        while (id2.hasNext()) {
                            int value = (Integer)id2.next();
                            if (value <= maxId) continue;
                            maxId = value;
                        }
                    }
                    if (maxId < 0) {
                        throw new RemapException("Failed to assign new id to client only registry entry");
                    }
                    FABRIC_LOGGER.debug("An ID for {} was not sent by the server, assuming client only registry entry and assigning a new id ({}) in {}", new Object[]{class_29602.toString(), ++maxId, this.method_30517().method_29177().toString()});
                    remoteIndexedEntries.put((Object)class_29602, maxId);
                }
                break;
            }
        }
        Int2IntOpenHashMap idMap = new Int2IntOpenHashMap();
        for (int i = 0; i < this.field_26682.size(); ++i) {
            class_6880.class_6883 class_68832 = (class_6880.class_6883)this.field_26682.get(i);
            if (class_68832 == null || !remoteIndexedEntries.containsKey((Object)(id2 = class_68832.method_40237().method_29177()))) continue;
            idMap.put(i, remoteIndexedEntries.getInt((Object)id2));
        }
        this.field_26682.clear();
        this.field_26683.clear();
        this.field_11109 = 0;
        ArrayList<class_2960> orderedRemoteEntries = new ArrayList<class_2960>((Collection<class_2960>)remoteIndexedEntries.keySet());
        orderedRemoteEntries.sort(Comparator.comparingInt(arg_0 -> ((Object2IntMap)remoteIndexedEntries).getInt(arg_0)));
        for (class_2960 identifier : orderedRemoteEntries) {
            int id4 = remoteIndexedEntries.getInt((Object)identifier);
            class_6880.class_6883<T> object = this.field_11107.get(identifier);
            if (object == null) {
                if (mode != RemappableRegistry.RemapMode.AUTHORITATIVE) {
                    throw new RemapException(identifier + " missing from registry, but requested!");
                }
                FABRIC_LOGGER.warn(identifier + " missing from registry, but requested!");
                continue;
            }
            this.field_26682.size(Math.max(this.field_26682.size(), id4 + 1));
            this.field_26682.set(id4, object);
            this.field_26683.put(object.comp_349(), id4);
            if (this.field_11109 > id4) continue;
            this.field_11109 = id4 + 1;
        }
        ((RegistryIdRemapCallback)this.fabric_getRemapEvent().invoker()).onRemap(new RemapStateImpl(this, (Int2ObjectMap<class_2960>)oldIdMap, (Int2IntMap)idMap));
    }

    @Override
    public void unmap(String name) throws RemapException {
        if (this.fabric_prevIndexedEntries != null) {
            ArrayList<class_2960> addedIds = new ArrayList<class_2960>();
            for (class_2960 id : this.fabric_prevEntries.keySet()) {
                if (this.field_11107.containsKey(id)) continue;
                assert (this.fabric_prevIndexedEntries.containsKey((Object)id));
                addedIds.add(id);
            }
            this.field_11107.clear();
            this.field_25067.clear();
            this.field_11107.putAll((Map<class_2960, class_6880.class_6883<T>>)this.fabric_prevEntries);
            for (Map.Entry entry : this.fabric_prevEntries.entrySet()) {
                class_5321 entryKey = class_5321.method_29179((class_5321)this.method_30517(), (class_2960)((class_2960)entry.getKey()));
                this.field_25067.put(entryKey, (class_6880.class_6883)entry.getValue());
            }
            this.remap(name, this.fabric_prevIndexedEntries, RemappableRegistry.RemapMode.AUTHORITATIVE);
            for (class_2960 id : addedIds) {
                ((RegistryEntryAddedCallback)this.fabric_getAddObjectEvent().invoker()).onEntryAdded(this.field_26683.getInt(this.field_11107.get(id)), id, this.method_10223(id));
            }
            this.fabric_prevIndexedEntries = null;
            this.fabric_prevEntries = null;
        }
    }
}

