/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.item;

import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.fabricmc.fabric.impl.transfer.item.InventorySlotWrapper;
import net.fabricmc.fabric.impl.transfer.item.PlayerInventoryStorageImpl;
import net.fabricmc.fabric.impl.transfer.item.SidedInventoryStorageImpl;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1661;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;

public class InventoryStorageImpl
extends CombinedStorage<ItemVariant, SingleSlotStorage<ItemVariant>>
implements InventoryStorage {
    private static final Map<class_1263, InventoryStorageImpl> WRAPPERS = new MapMaker().weakValues().makeMap();
    final class_1263 inventory;
    final List<InventorySlotWrapper> backingList;
    final MarkDirtyParticipant markDirtyParticipant = new MarkDirtyParticipant();

    public static InventoryStorage of(class_1263 inventory, @Nullable class_2350 direction) {
        InventoryStorageImpl storage = WRAPPERS.computeIfAbsent(inventory, inv -> {
            if (inv instanceof class_1661) {
                class_1661 playerInventory = (class_1661)inv;
                return new PlayerInventoryStorageImpl(playerInventory);
            }
            return new InventoryStorageImpl((class_1263)inv);
        });
        storage.resizeSlotList();
        return storage.getSidedWrapper(direction);
    }

    InventoryStorageImpl(class_1263 inventory) {
        super(Collections.emptyList());
        this.inventory = inventory;
        this.backingList = new ArrayList<InventorySlotWrapper>();
    }

    @Override
    public List<SingleSlotStorage<ItemVariant>> getSlots() {
        return this.parts;
    }

    private void resizeSlotList() {
        int inventorySize = this.inventory.method_5439();
        if (inventorySize != this.parts.size()) {
            while (this.backingList.size() < inventorySize) {
                this.backingList.add(new InventorySlotWrapper(this, this.backingList.size()));
            }
            this.parts = Collections.unmodifiableList(this.backingList.subList(0, inventorySize));
        }
    }

    private InventoryStorage getSidedWrapper(@Nullable class_2350 direction) {
        if (this.inventory instanceof class_1278 && direction != null) {
            return new SidedInventoryStorageImpl(this, direction);
        }
        return this;
    }

    class MarkDirtyParticipant
    extends SnapshotParticipant<Boolean> {
        MarkDirtyParticipant() {
        }

        @Override
        protected Boolean createSnapshot() {
            return Boolean.TRUE;
        }

        @Override
        protected void readSnapshot(Boolean snapshot) {
        }

        @Override
        protected void onFinalCommit() {
            InventoryStorageImpl.this.inventory.method_5431();
        }
    }
}

