/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.favorites.history;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponent;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentVisitorWidget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.impl.client.gui.widget.DisplayCompositeWidget;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import me.shedaniel.rei.impl.client.gui.widget.favorites.history.DisplayEntry;
import net.minecraft.class_1159;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

public class DisplayHistoryWidget
extends WidgetWithBounds
implements DraggableComponentVisitorWidget,
DraggableComponentProviderWidget<Display> {
    private final FavoritesListWidget parent;
    private final Rectangle bounds = new Rectangle();
    private final NumberAnimator<Double> height;
    private final List<DisplayEntry> entries = new ArrayList<DisplayEntry>();
    private final NumberAnimator<Double> scroll = ValueAnimator.ofDouble();

    public DisplayHistoryWidget(FavoritesListWidget parent) {
        this.parent = parent;
        this.height = ValueAnimator.ofDouble().withConvention(() -> {
            boolean draggingDisplay;
            boolean bl = draggingDisplay = DraggingContext.getInstance().isDraggingComponent() && DraggingContext.getInstance().getDragged().get() instanceof Display;
            if (draggingDisplay) {
                return Math.min((double)parent.excludedBounds.height, 80.0);
            }
            return 0.0;
        }, ValueAnimator.typicalTransitionTime());
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public List<DisplayEntry> getEntries() {
        return this.entries;
    }

    public void method_25394(class_4587 poses, int mouseX, int mouseY, float delta) {
        Rectangle fullBounds = this.parent.excludedBounds;
        if (this.updateBounds(fullBounds)) {
            for (DisplayEntry entry : this.entries) {
                entry.markBoundsDirty();
            }
        }
        this.updatePosition(delta);
        double xOffset = -this.scroll.doubleValue() + (double)(this.entries.size() * this.getBounds().getWidth());
        for (int i = this.entries.size() - 1; i >= 0; --i) {
            DisplayEntry entry = this.entries.get(i);
            entry.setScrolled(xOffset -= (double)this.getBounds().getWidth());
            if (entry.isStable()) {
                ScissorsHandler.INSTANCE.scissor(this.getBounds());
            }
            entry.method_25394(poses, mouseX, mouseY, delta);
            if (!entry.isStable()) continue;
            ScissorsHandler.INSTANCE.removeLastScissor();
        }
        boolean draggingDisplay = DraggingContext.getInstance().isDraggingComponent() && DraggingContext.getInstance().getDragged().get() instanceof Display;
        double onBoardingHeight = (Double)this.height.value();
        if (this.entries.isEmpty() && draggingDisplay && Math.round(onBoardingHeight) > 0L) {
            double lastProgress = Math.pow(class_3532.method_15350((double)(onBoardingHeight / Math.min((double)this.parent.excludedBounds.height, 80.0)), (double)0.0, (double)1.0), 7.0);
            int alpha = (int)(80.0 * lastProgress) + (int)(66.0 * lastProgress * (double)(class_3532.method_15362((float)((float)((double)((float)(System.currentTimeMillis() % 1000L) / 500.0f) * Math.PI))) + 1.0f) / 2.0);
            int lineColor = alpha << 24 | 0xFFFFFF;
            Rectangle bounds = this.bounds.clone();
            bounds.y += 10;
            bounds.height -= 20;
            this.drawHorizontalDashedLine(poses, bounds.x, bounds.getMaxX(), bounds.y, lineColor, false);
            this.drawHorizontalDashedLine(poses, bounds.x, bounds.getMaxX(), bounds.getMaxY() - 1, lineColor, true);
            this.drawVerticalDashedLine(poses, bounds.x, bounds.y, bounds.getMaxY(), lineColor, true);
            this.drawVerticalDashedLine(poses, bounds.getMaxX() - 1, bounds.y, bounds.getMaxY(), lineColor, false);
        }
    }

    private void drawHorizontalDashedLine(class_4587 poses, int x1, int x2, int y, int color, boolean reverse) {
        float offset = (float)(System.currentTimeMillis() % 600L) / 100.0f;
        if (!reverse) {
            offset = 6.0f - offset;
        }
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tesselator = class_289.method_1348();
        class_287 builder = tesselator.method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        class_1159 pose = poses.method_23760().method_23761();
        for (float x = (float)x1 - offset; x < (float)x2; x += 7.0f) {
            builder.method_22918(pose, class_3532.method_15363((float)(x + 4.0f), (float)x1, (float)x2), (float)y, (float)this.getZ()).method_22915(r, g, b, a).method_1344();
            builder.method_22918(pose, class_3532.method_15363((float)x, (float)x1, (float)x2), (float)y, (float)this.getZ()).method_22915(r, g, b, a).method_1344();
            builder.method_22918(pose, class_3532.method_15363((float)x, (float)x1, (float)x2), (float)(y + 1), (float)this.getZ()).method_22915(r, g, b, a).method_1344();
            builder.method_22918(pose, class_3532.method_15363((float)(x + 4.0f), (float)x1, (float)x2), (float)(y + 1), (float)this.getZ()).method_22915(r, g, b, a).method_1344();
        }
        tesselator.method_1350();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }

    private void drawVerticalDashedLine(class_4587 poses, int x, int y1, int y2, int color, boolean reverse) {
        float offset = (float)(System.currentTimeMillis() % 600L) / 100.0f;
        if (!reverse) {
            offset = 6.0f - offset;
        }
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tesselator = class_289.method_1348();
        class_287 builder = tesselator.method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        class_1159 pose = poses.method_23760().method_23761();
        for (float y = (float)y1 - offset; y < (float)y2; y += 7.0f) {
            builder.method_22918(pose, (float)(x + 1), class_3532.method_15363((float)y, (float)y1, (float)y2), (float)this.getZ()).method_22915(r, g, b, a).method_1344();
            builder.method_22918(pose, (float)x, class_3532.method_15363((float)y, (float)y1, (float)y2), (float)this.getZ()).method_22915(r, g, b, a).method_1344();
            builder.method_22918(pose, (float)x, class_3532.method_15363((float)(y + 4.0f), (float)y1, (float)y2), (float)this.getZ()).method_22915(r, g, b, a).method_1344();
            builder.method_22918(pose, (float)(x + 1), class_3532.method_15363((float)(y + 4.0f), (float)y1, (float)y2), (float)this.getZ()).method_22915(r, g, b, a).method_1344();
        }
        tesselator.method_1350();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }

    private boolean updateBounds(Rectangle fullBounds) {
        int prevHash = this.bounds.hashCode();
        this.bounds.setBounds(this.createBounds(fullBounds));
        return prevHash != this.bounds.hashCode();
    }

    public Rectangle createBounds(Rectangle fullBounds) {
        return this.createBounds(fullBounds, (Double)this.height.value());
    }

    public Rectangle createBounds(Rectangle fullBounds, @Nullable Double height) {
        return new Rectangle(fullBounds.x + 2, fullBounds.y, fullBounds.width - 4, Math.min(fullBounds.height, 80));
    }

    public void updatePosition(float delta) {
        this.height.update((double)delta);
        this.scroll.setTarget(ScrollingContainer.handleBounceBack((double)((Double)this.scroll.target()), (double)this.getMaxScrollDist(), (float)delta, (double)0.08));
        this.scroll.update((double)delta);
        if ((Double)this.scroll.target() >= 0.0 && (Double)this.scroll.target() <= (double)this.getMaxScrollDist() && this.entries.size() > 1) {
            int before = (int)(Math.floor((Double)this.scroll.target() / (double)this.getBounds().getWidth()) * (double)this.getBounds().getWidth());
            int after = (int)(Math.ceil((Double)this.scroll.target() / (double)this.getBounds().getWidth()) * (double)this.getBounds().getWidth());
            if ((double)before <= (Double)this.scroll.target() && (double)after >= (Double)this.scroll.target()) {
                if (Math.abs((double)before - (Double)this.scroll.target()) < Math.abs((double)after - (Double)this.scroll.target())) {
                    this.scroll.setTarget((Double)this.scroll.target() - ((Double)this.scroll.target() - (double)before) * (double)delta / 2.0);
                } else {
                    this.scroll.setTarget((Double)this.scroll.target() + ((double)after - (Double)this.scroll.target()) * (double)delta / 2.0);
                }
            }
        }
    }

    public int getContentHeight() {
        if (this.entries.isEmpty()) {
            return 0;
        }
        return this.getBounds().getWidth() * this.entries.size();
    }

    public final int getMaxScrollDist() {
        return Math.max(0, this.getContentHeight() - this.getBounds().width);
    }

    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.containsMouse(mouseX, mouseY)) {
            for (DisplayEntry entry : this.entries) {
                if (entry.isStable()) continue;
                entry.setReachedStable(true);
            }
            this.scroll.setTo((Double)this.scroll.target() + ClothConfigInitializer.getScrollStep() * amount * ((double)this.getBounds().getWidth() / -50.0), ClothConfigInitializer.getScrollDuration());
            return true;
        }
        for (DisplayEntry entry : this.entries) {
            if (!entry.method_25401(mouseX, mouseY, amount)) continue;
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (DisplayEntry entry : this.entries) {
            if (!entry.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        Point mouse;
        for (DisplayEntry entry : this.entries) {
            if (!entry.method_25406(mouseX, mouseY, button)) continue;
            return true;
        }
        if (ConfigObject.getInstance().getFavoriteKeyCode().matchesMouse(button) && this.containsMouse(mouse = PointHelper.ofMouse())) {
            double xOffset = -((Double)this.scroll.value()).doubleValue();
            for (DisplayEntry entry : this.entries) {
                if (!entry.isStable() || !entry.getBounds().contains((double)mouse.x + xOffset, (double)mouse.y)) continue;
                this.entries.remove(entry);
                this.scroll.setAs((Double)this.scroll.target() - (double)this.getBounds().getWidth());
                this.scroll.setTo((Double)this.scroll.target() + (double)this.getBounds().getWidth(), 800L);
                DisplayCompositeWidget.DisplayDraggableComponent component = new DisplayCompositeWidget.DisplayDraggableComponent(Widgets.concat(entry.getWidgets()), entry.getDisplay(), entry.getBounds().clone(), new Rectangle(0, 0, entry.getSize().width, entry.getSize().height));
                DraggingContext.getInstance().renderToVoid(component);
                return true;
            }
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        Point mouse;
        for (DisplayEntry entry : this.entries) {
            if (!entry.method_25404(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (ConfigObject.getInstance().getFavoriteKeyCode().matchesKey(keyCode, scanCode) && this.containsMouse(mouse = PointHelper.ofMouse())) {
            double xOffset = -((Double)this.scroll.value()).doubleValue();
            for (DisplayEntry entry : this.entries) {
                if (!entry.isStable() || !entry.getBounds().contains((double)mouse.x + xOffset, (double)mouse.y)) continue;
                this.entries.remove(entry);
                this.scroll.setAs((Double)this.scroll.target() - (double)this.getBounds().getWidth());
                this.scroll.setTo((Double)this.scroll.target() + (double)this.getBounds().getWidth(), 800L);
                DisplayCompositeWidget.DisplayDraggableComponent component = new DisplayCompositeWidget.DisplayDraggableComponent(Widgets.concat(entry.getWidgets()), entry.getDisplay(), entry.getBounds().clone(), new Rectangle(0, 0, entry.getSize().width, entry.getSize().height));
                DraggingContext.getInstance().renderToVoid(component);
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public DraggedAcceptorResult acceptDragged(DraggingContext<class_437> context, DraggableComponent<?> component) {
        return component.ifMatches(display -> {
            Point pos = context.getCurrentPosition();
            if (this.containsMouse(pos)) {
                this.addDisplay(context.getCurrentBounds().clone(), (Display)display);
                return true;
            }
            return false;
        }, new Display[0]) ? DraggedAcceptorResult.CONSUMED : DraggedAcceptorResult.PASS;
    }

    public void addDisplay(Rectangle bounds, Display display) {
        this.entries.removeIf(displayEntry -> displayEntry.getDisplay() == display);
        this.entries.add(0, new DisplayEntry(this, display, bounds));
        this.scroll.setAs((Double)this.scroll.target() + (double)this.getBounds().getWidth());
        this.scroll.setTo(0, 800L);
        while (this.entries.size() >= 10) {
            this.entries.remove(Iterables.get(this.entries, (int)(this.entries.size() - 1)));
        }
    }

    @Override
    @Nullable
    public DraggableComponent<Display> getHovered(DraggingContext<class_437> context, double mouseX, double mouseY) {
        if (this.containsMouse(mouseX, mouseY)) {
            double xOffset = -((Double)this.scroll.value()).doubleValue();
            for (final DisplayEntry entry : this.entries) {
                if (entry.isStable() && entry.getBounds().contains(mouseX + xOffset, mouseY)) {
                    return new DisplayCompositeWidget.DisplayDraggableComponent(Widgets.concat(entry.getWidgets()), entry.getDisplay(), entry.getBounds().clone(), new Rectangle(0, 0, entry.getSize().width, entry.getSize().height)){

                        @Override
                        public void drag() {
                            DisplayHistoryWidget.this.entries.remove(entry);
                            DisplayHistoryWidget.this.scroll.setAs((Double)DisplayHistoryWidget.this.scroll.target() - (double)DisplayHistoryWidget.this.getBounds().getWidth());
                            DisplayHistoryWidget.this.scroll.setTo((Double)DisplayHistoryWidget.this.scroll.target() + (double)DisplayHistoryWidget.this.getBounds().getWidth(), 800L);
                        }

                        @Override
                        public void release(DraggedAcceptorResult result) {
                            if (result == DraggedAcceptorResult.PASS) {
                                DisplayHistoryWidget.this.addDisplay(DraggingContext.getInstance().getCurrentBounds().clone(), entry.getDisplay());
                            }
                        }
                    };
                }
                xOffset += (double)this.getBounds().getWidth();
            }
        }
        return null;
    }
}

