/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.fabric;

import com.google.common.collect.ImmutableSet;
import me.shedaniel.rei.RoughlyEnoughItemsState;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;

public class RoughlyEnoughItemsInitializerImpl {
    public static boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public static void checkMods() {
        ImmutableSet requiredModules = RoughlyEnoughItemsInitializerImpl.isClient() ? ImmutableSet.builder().add((Object)"fabric-api-base").add((Object)"fabric-resource-loader-v0").add((Object)"fabric-networking-api-v1").add((Object)"fabric-lifecycle-events-v1").add((Object)"fabric-rendering-fluids-v1").build() : ImmutableSet.builder().add((Object)"fabric-api-base").add((Object)"fabric-resource-loader-v0").add((Object)"fabric-networking-api-v1").add((Object)"fabric-lifecycle-events-v1").build();
        for (String module : requiredModules) {
            boolean moduleLoaded = FabricLoader.getInstance().isModLoaded(module);
            if (moduleLoaded) continue;
            RoughlyEnoughItemsState.error("Fabric API is not installed!", "https://www.curseforge.com/minecraft/mc-mods/fabric-api/files/all");
            break;
        }
        if (!FabricLoader.getInstance().isModLoaded("architectury")) {
            RoughlyEnoughItemsState.error("Architectury API is not installed!", "https://www.curseforge.com/minecraft/mc-mods/architectury-api/files/all");
        } else {
            Version version = ((ModContainer)FabricLoader.getInstance().getModContainer("architectury").get()).getMetadata().getVersion();
            try {
                if (version instanceof SemanticVersion && SemanticVersion.parse((String)"2.6.0").compareTo((SemanticVersion)version) > 0) {
                    RoughlyEnoughItemsState.error("Architectury API is too old, please update!", "https://www.curseforge.com/minecraft/mc-mods/architectury-api/files/all");
                }
            }
            catch (VersionParsingException e) {
                e.printStackTrace();
            }
        }
        if (RoughlyEnoughItemsInitializerImpl.isClient() && !FabricLoader.getInstance().isModLoaded("cloth-config2")) {
            RoughlyEnoughItemsState.error("Cloth Config is not installed!", "https://www.curseforge.com/minecraft/mc-mods/cloth-config/files/all");
        }
    }

    public static boolean isDev() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static String getMinecraftVersion() {
        return ((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").get()).getMetadata().getVersion().getFriendlyString();
    }

    public static int compareVersions(String version1, String version2) {
        SemanticVersion v2;
        SemanticVersion v1;
        version1 = version1.contains("-") ? version1.substring(0, version1.indexOf("-")) : version1;
        version2 = version2.contains("-") ? version2.substring(0, version2.indexOf("-")) : version2;
        version1 = version1.contains("+") ? version1.substring(0, version1.indexOf("+")) : version1;
        version2 = version2.contains("+") ? version2.substring(0, version2.indexOf("+")) : version2;
        try {
            v1 = SemanticVersion.parse((String)version1);
        }
        catch (VersionParsingException e) {
            new IllegalStateException("Failed to parse version: " + version1, e).printStackTrace();
            return 0;
        }
        try {
            v2 = SemanticVersion.parse((String)version2);
        }
        catch (VersionParsingException e) {
            new IllegalStateException("Failed to parse version: " + version2, e).printStackTrace();
            return 0;
        }
        return v1.compareTo((Object)v2);
    }
}

