/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.isometricrenders.widget;

import com.glisco.isometricrenders.property.Property;
import com.glisco.isometricrenders.util.Translate;
import com.glisco.isometricrenders.widget.IsometricButtonWidget;
import com.glisco.isometricrenders.widget.LabelWidget;
import com.glisco.isometricrenders.widget.PropertyCheckbox;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;

public class WidgetColumnBuilder {
    private final WidgetConsumer consumer;
    private final int width;
    private final int baseX;
    private int currentY;
    private int currentRowHeight = 0;

    public WidgetColumnBuilder(WidgetConsumer consumer, int baseY, int baseX, int width) {
        this.consumer = consumer;
        this.currentY = baseY;
        this.baseX = baseX + 10;
        this.width = width;
    }

    public <T extends class_364 & class_4068> T add(T widget, int widgetHeight) {
        this.consumer.accept(widget);
        if (widgetHeight > this.currentRowHeight) {
            this.currentRowHeight = widgetHeight;
        }
        return widget;
    }

    public LabelWidget label(String key) {
        LabelWidget labelWidget = new LabelWidget(this.baseX + 2, this.currentY(), (class_2561)Translate.gui(key, new Object[0]));
        Objects.requireNonNull(class_310.method_1551().field_1772);
        LabelWidget label = this.add(labelWidget, 9);
        this.nextRow();
        return label;
    }

    public LabelWidget dynamicLabel(Supplier<class_2561> content) {
        LabelWidget labelWidget = new LabelWidget(this.baseX + 2, this.currentY(), content);
        Objects.requireNonNull(class_310.method_1551().field_1772);
        LabelWidget label = this.add(labelWidget, 9);
        this.nextRow();
        return label;
    }

    public IsometricButtonWidget button(String messageKey, int xOffset, int width, class_4185.class_4241 onPress) {
        return this.add(new IsometricButtonWidget(this.baseX + xOffset, this.currentY(), width, 20, (class_2561)Translate.gui(messageKey, new Object[0]), onPress), 20);
    }

    public class_342 labeledTextField(String content, int width, String labelKey) {
        class_342 textField = this.add(new class_342(class_310.method_1551().field_1772, this.baseX, this.currentY(), width, 20, (class_2561)class_2561.method_43473()), 20);
        textField.method_1852(content);
        LabelWidget labelWidget = new LabelWidget(this.baseX + width + 5, this.currentY + 6, (class_2561)Translate.gui(labelKey, new Object[0]));
        Objects.requireNonNull(class_310.method_1551().field_1772);
        this.add(labelWidget, 9).color(0xAAAAAA).shadow(false);
        this.nextRow();
        return textField;
    }

    public PropertyCheckbox propertyCheckbox(Property<Boolean> property, String key) {
        PropertyCheckbox checkbox = this.add(new PropertyCheckbox(this.baseX, this.currentY, (class_2561)Translate.gui(key, new Object[0]), property), 20);
        this.nextRow();
        return checkbox;
    }

    public void nextRow() {
        this.move(this.currentRowHeight + 10);
        this.currentRowHeight = 0;
    }

    public void move(int pixels) {
        this.currentY += pixels;
    }

    public int currentY() {
        return this.currentY;
    }

    public int width() {
        return this.width;
    }

    public static interface WidgetConsumer {
        public <T extends class_364 & class_4068> void accept(T var1);
    }
}

