/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.isometricrenders.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class NotificationStack
implements class_364,
class_6379,
class_4068 {
    private final List<Notification> notifications = new ArrayList<Notification>();
    @Nullable
    private Notification hoveredNotification = null;
    private int bottomRightX = 0;
    private int bottomRightY = 0;

    public void setPosition(int bottomRightX, int bottomRightY) {
        this.bottomRightX = bottomRightX;
        this.bottomRightY = bottomRightY;
    }

    public void add(class_2561 ... text) {
        this.notifications.add(new Notification(Arrays.asList(text), () -> {}));
    }

    public void add(Runnable clickListener, class_2561 ... text) {
        this.notifications.add(new Notification(Arrays.asList(text), clickListener));
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.notifications.removeIf(Notification::isExpired);
        class_327 textRenderer = class_310.method_1551().field_1772;
        int renderY = this.bottomRightY + 10;
        this.hoveredNotification = null;
        for (Notification notification : this.notifications) {
            int height = notification.getHeight();
            int renderX = this.bottomRightX - notification.width;
            boolean hovered = false;
            if (mouseX >= renderX && mouseX <= renderX + notification.width && mouseY >= (renderY -= height + 10) && mouseY <= renderY + height) {
                this.hoveredNotification = notification;
                hovered = true;
            }
            if (!(notification.getOpacity() * 255.0f > 5.0f)) continue;
            int alpha = (int)(144.0f * notification.getOpacity()) << 24;
            class_332.method_25294((class_4587)matrices, (int)renderX, (int)renderY, (int)(renderX + notification.width), (int)(renderY + height), (int)((hovered ? 0x242424 : 0) | alpha));
            int textAlpha = (int)(255.0f * notification.getOpacity()) << 24;
            for (int i = 0; i < notification.lines.size(); ++i) {
                textRenderer.method_30883(matrices, notification.lines.get(i), (float)(renderX + 10), (float)(renderY + 10 + i * 11), 0xFFFFFF | textAlpha);
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.hoveredNotification == null) {
            return false;
        }
        this.hoveredNotification.clickListener.run();
        return true;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33785;
    }

    public void method_37020(class_6382 builder) {
    }

    private static class Notification {
        private final List<class_2561> lines;
        private final int width;
        private final int height;
        private final long startTime;
        private final Runnable clickListener;

        private Notification(List<class_2561> lines, Runnable clickListener) {
            this.lines = lines;
            this.clickListener = clickListener;
            int longestLine = 0;
            for (class_2561 line : lines) {
                longestLine = Math.max(longestLine, class_310.method_1551().field_1772.method_27525((class_5348)line));
            }
            this.width = longestLine + 20;
            this.height = 10 + lines.size() * 11 + 10 - 2;
            this.startTime = System.currentTimeMillis();
        }

        public int getHeight() {
            if (this.age() < 5000L) {
                return this.height;
            }
            if (this.age() < 6000L) {
                return this.height;
            }
            return Math.round(this.progress(6000L, 6500L) * (float)(this.height + 10)) - 10;
        }

        public float getOpacity() {
            if (this.age() < 5000L) {
                return 1.0f;
            }
            return this.progress(5000L, 6000L);
        }

        public boolean isExpired() {
            return this.age() > 6500L;
        }

        private float progress(long from, long to) {
            long age = this.age();
            float linearProgress = (float)class_3532.method_24156((long)(age - from), (long)0L, (long)(to - from)) / (float)(to - from);
            return (float)((Math.sin(1.5707963267948966 + (double)linearProgress * Math.PI) + 1.0) / 2.0);
        }

        private long age() {
            return System.currentTimeMillis() - this.startTime;
        }
    }
}

