/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.isometricrenders.util;

import com.glisco.isometricrenders.IsometricRenders;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_238;

public class ParticleRestriction<T> {
    public static final Allow<Supplier<Boolean>> ALLOW_DURING_TICK = new Allow();
    public static final Allow<Void> ALLOW_ALWAYS = new Allow();
    public static final Allow<Void> ALLOW_NEVER = new Allow();
    public static final Allow<Predicate<class_238>> ALLOW_IN_AREA = new Allow();
    private static final ParticleRestriction<Supplier<Boolean>> DURING_TICK = new ParticleRestriction<Supplier<Boolean>>(ALLOW_DURING_TICK, () -> IsometricRenders.inRenderableTick);
    private static final ParticleRestriction<Void> ALWAYS = new ParticleRestriction<Object>(ALLOW_ALWAYS, null);
    private static final ParticleRestriction<Void> NEVER = new ParticleRestriction<Object>(ALLOW_NEVER, null);
    private final Allow<T> allow;
    private final T condition;

    private ParticleRestriction(Allow<T> allow, T condition) {
        this.allow = allow;
        this.condition = condition;
    }

    public static ParticleRestriction<Supplier<Boolean>> duringTick() {
        return DURING_TICK;
    }

    public static ParticleRestriction<Void> always() {
        return ALWAYS;
    }

    public static ParticleRestriction<Void> never() {
        return NEVER;
    }

    public static ParticleRestriction<Predicate<class_238>> inArea(class_238 area) {
        return new ParticleRestriction<Predicate<class_238>>(ALLOW_IN_AREA, arg_0 -> ((class_238)area).method_994(arg_0));
    }

    public boolean is(Allow<?> allow) {
        return this.allow == allow;
    }

    public <C> C conditionFor(Allow<C> allow) {
        return (C)this.condition;
    }

    public static class Allow<D> {
        private Allow() {
        }
    }
}

