/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.isometricrenders.util;

import com.glisco.isometricrenders.util.Translate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;

public class MemoryGuard {
    private final float maximumLoadFactor;
    private int availableVramMB = 0;
    private int availableRamMB = 0;

    public MemoryGuard(float maximumLoadFactor) {
        this.maximumLoadFactor = maximumLoadFactor;
    }

    public void update() {
        int[] data = new int[4];
        GLCapabilities caps = GL.getCapabilities();
        if (caps.GL_ATI_meminfo) {
            GL11.glGetIntegerv((int)34812, (int[])data);
        }
        if (caps.GL_NVX_gpu_memory_info) {
            GL11.glGetIntegerv((int)36937, (int[])data);
        }
        GL11.glGetError();
        this.availableVramMB = data[0] / 1024;
        this.availableRamMB = (int)((Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory()) / 1024L / 1024L);
    }

    public boolean isSupported() {
        return GL.getCapabilities().GL_ATI_meminfo || GL.getCapabilities().GL_NVX_gpu_memory_info;
    }

    public List<class_2561> getStatusTooltip(int memoryMB) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        tooltip.add((class_2561)this.usageText("vram", memoryMB, this.availableVramMB(), this.canFitInVram(memoryMB)));
        tooltip.add((class_2561)this.usageText("ram", memoryMB, this.availableRamMB(), this.canFitInRam(memoryMB)));
        if (!this.isSupported()) {
            tooltip.add((class_2561)class_2561.method_43473());
            tooltip.add((class_2561)Translate.gui("no_vram_info_warning", new Object[0]).method_27692(class_124.field_1054));
        }
        if (!this.canFit(memoryMB)) {
            tooltip.add((class_2561)Translate.gui("vram_ignore", new Object[0]).method_27692(class_124.field_1080));
        }
        return tooltip;
    }

    private class_5250 usageText(String key, int usage, int available, boolean fits) {
        if (available == 0) {
            available = 1;
        }
        if (fits) {
            return Translate.gui(key, class_2561.method_43470((String)("" + usage)).method_27692(class_124.field_1080), class_2561.method_43470((String)("" + available)).method_27692(class_124.field_1080), class_2561.method_43470((String)(usage * 100 / available + "%")).method_27692(class_124.field_1080));
        }
        return Translate.gui(key, class_2561.method_43470((String)("" + usage)).method_27692(class_124.field_1061), class_2561.method_43470((String)("" + available)).method_27692(class_124.field_1080), class_2561.method_43470((String)(usage * 100 / available + "%")).method_27692(class_124.field_1061));
    }

    public int availableVramMB() {
        return this.availableVramMB;
    }

    public int availableRamMB() {
        return this.availableRamMB;
    }

    public boolean canFit(int memoryMB) {
        return this.canFitInVram(memoryMB) && this.canFitInRam(memoryMB);
    }

    public boolean canFitInRam(int memoryMB) {
        return (float)memoryMB / (float)this.availableRamMB <= this.maximumLoadFactor;
    }

    public boolean canFitInVram(int memoryMB) {
        return (float)memoryMB / (float)this.availableVramMB <= this.maximumLoadFactor;
    }
}

