/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.isometricrenders.util;

import com.glisco.isometricrenders.IsometricRenders;
import com.glisco.isometricrenders.property.GlobalProperties;
import com.glisco.isometricrenders.util.ExportPathSpec;
import com.glisco.isometricrenders.util.Translate;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1011;
import net.minecraft.class_2561;

public class ImageIO {
    private static final AtomicInteger TASK_COUNT = new AtomicInteger(0);

    public static CompletableFuture<File> save(class_1011 image, ExportPathSpec path) {
        CompletableFuture<File> future = new CompletableFuture<File>();
        TASK_COUNT.incrementAndGet();
        ForkJoinPool.commonPool().submit(() -> {
            File imageFile = path.resolveFile("png");
            imageFile.getParentFile().mkdirs();
            try {
                image.method_4325(imageFile);
                IsometricRenders.LOGGER.info("Image " + imageFile.getAbsolutePath() + " saved");
                future.complete(imageFile);
            }
            catch (IOException e) {
                IsometricRenders.LOGGER.warn("Could not save image " + imageFile.getAbsolutePath(), (Throwable)e);
                future.completeExceptionally(e);
            }
            finally {
                TASK_COUNT.decrementAndGet();
            }
        });
        return future;
    }

    public static int taskCount() {
        return TASK_COUNT.get();
    }

    public static class_2561 progressText() {
        int jobs = ImageIO.taskCount();
        if (jobs == 0) {
            return Translate.gui("exporter.idle", new Object[0]);
        }
        return Translate.gui("exporter.jobs", jobs);
    }

    public static Path next(Path input) {
        Path currentPath;
        CharSequence[] file = input.getFileName().toString().split("\\.");
        Path path = input.getParent();
        Path lastPath = currentPath = path.resolve(String.join((CharSequence)".", file));
        int i = 1;
        while (Files.exists(currentPath, new LinkOption[0])) {
            lastPath = currentPath;
            currentPath = path.resolve(String.join((CharSequence)("_" + i + "."), file));
            ++i;
        }
        return GlobalProperties.overwriteLatest.get() != false ? lastPath : currentPath;
    }
}

