/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.isometricrenders.screen;

import com.glisco.isometricrenders.IsometricRenders;
import com.glisco.isometricrenders.mixin.access.ParticleManagerAccessor;
import com.glisco.isometricrenders.property.DefaultPropertyBundle;
import com.glisco.isometricrenders.property.GlobalProperties;
import com.glisco.isometricrenders.property.Property;
import com.glisco.isometricrenders.render.DefaultRenderable;
import com.glisco.isometricrenders.render.Renderable;
import com.glisco.isometricrenders.render.RenderableDispatcher;
import com.glisco.isometricrenders.render.TickingRenderable;
import com.glisco.isometricrenders.util.ExportPathSpec;
import com.glisco.isometricrenders.util.FFmpegDispatcher;
import com.glisco.isometricrenders.util.ImageIO;
import com.glisco.isometricrenders.util.ImageTransferable;
import com.glisco.isometricrenders.util.MemoryGuard;
import com.glisco.isometricrenders.util.ParticleRestriction;
import com.glisco.isometricrenders.util.Translate;
import com.glisco.isometricrenders.widget.IsometricButtonWidget;
import com.glisco.isometricrenders.widget.NotificationStack;
import com.glisco.isometricrenders.widget.WidgetColumnBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_1041;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5498;

public class RenderScreen
extends class_437 {
    private static final Int2ObjectMap<Consumer<DefaultPropertyBundle>> KEYBOARD_CONTROLS = new Int2ObjectOpenHashMap();
    private final MemoryGuard memoryGuard = new MemoryGuard(0.75f);
    private final Renderable<?> renderable;
    private Consumer<File> exportCallback = file -> {};
    public final Property<Boolean> playAnimations = Property.of(false);
    public final Property<Boolean> tickParticles = Property.of(true);
    private final NotificationStack notificationStack = new NotificationStack();
    private class_4185 exportAnimationButton;
    private boolean drawOnlyBackground = false;
    private boolean captureScheduled = false;
    private boolean guiRebuildScheduled = false;
    private int viewportBeginX;
    private int viewportEndX;
    private final List<class_276> renderedFrames = new ArrayList<class_276>();
    private int remainingAnimationFrames;

    public RenderScreen(Renderable<?> renderable) {
        super(class_2561.method_30163((String)""));
        this.renderable = renderable;
        this.memoryGuard.update();
    }

    protected void method_25426() {
        this.field_22787.field_1774.method_1462(true);
        this.viewportBeginX = (int)((double)(this.field_22789 - this.field_22790) * 0.5);
        this.viewportEndX = (int)((double)this.field_22789 - (double)(this.field_22789 - this.field_22790) * 0.5) + 1;
        ((ParticleManagerAccessor)class_310.method_1551().field_1713).isometric$getParticles().clear();
        IsometricRenders.particleRestriction = this.renderable.particleRestriction();
        this.field_22787.field_1690.method_31043(class_5498.field_26664);
        WidgetColumnBuilder leftBuilder = new WidgetColumnBuilder(x$0 -> this.method_37063(x$0), 20, 0, this.viewportBeginX);
        this.renderable.properties().buildGuiControls(this.renderable, leftBuilder);
        WidgetColumnBuilder rightBuilder = new WidgetColumnBuilder(x$0 -> this.method_37063(x$0), 20, this.viewportEndX, this.viewportBeginX);
        rightBuilder.label("render_options");
        class_342 colorField = rightBuilder.labeledTextField("#000000", 50, "background_color");
        colorField.method_1890(s -> s.matches("^#([A-Fa-f\\d]{0,6})$"));
        colorField.method_1852("#" + String.format("%02X", GlobalProperties.backgroundColor >> 16) + String.format("%02X", GlobalProperties.backgroundColor >> 8 & 0xFF) + String.format("%02X", GlobalProperties.backgroundColor & 0xFF));
        colorField.method_1863(s -> {
            if (s.substring(1).length() < 6) {
                return;
            }
            GlobalProperties.backgroundColor = Integer.parseInt(s.substring(1), 16);
        });
        rightBuilder.propertyCheckbox(this.playAnimations, "animations");
        rightBuilder.move(-5);
        rightBuilder.propertyCheckbox(this.tickParticles, "particles");
        rightBuilder.move(10);
        rightBuilder.label("export_options");
        rightBuilder.propertyCheckbox(GlobalProperties.saveIntoRoot, "dump_into_root");
        rightBuilder.move(-5);
        rightBuilder.propertyCheckbox(GlobalProperties.overwriteLatest, "overwrite_latest");
        rightBuilder.move(-5);
        IsometricButtonWidget exportButton = rightBuilder.button("export", 0, 75, button -> {
            this.captureScheduled = true;
        });
        rightBuilder.button("open_folder", 80, 75, button -> class_156.method_668().method_672(this.renderable.exportPath().resolveOffset().toFile()));
        rightBuilder.nextRow();
        if (!GraphicsEnvironment.isHeadless()) {
            rightBuilder.move(-5);
            rightBuilder.button("export_to_clipboard", 0, 75, button -> {
                this.notificationStack.add(new class_2561[]{Translate.gui("copied_to_clipboard", new Object[0])});
                try (class_1011 image = RenderableDispatcher.drawIntoImage(this.renderable, 0.0f, GlobalProperties.exportResolution);){
                    ImageTransferable transferable = new ImageTransferable(javax.imageio.ImageIO.read(new ByteArrayInputStream(image.method_24036())));
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, transferable);
                }
                catch (IOException e) {
                    IsometricRenders.LOGGER.error("mfw", (Throwable)e);
                }
            });
            rightBuilder.nextRow();
        }
        rightBuilder.move(5);
        class_342 resolutionField = rightBuilder.labeledTextField(String.valueOf(GlobalProperties.exportResolution), 50, "renderer_resolution");
        resolutionField.method_1868(65280);
        resolutionField.method_1890(s -> s.matches("\\d{0,5}"));
        resolutionField.method_1863(s -> {
            if (s.isBlank()) {
                return;
            }
            int resolution = Integer.parseInt(s);
            if (!(resolution >= 16 && resolution <= 16384 || GlobalProperties.unsafe.get().booleanValue())) {
                resolutionField.method_1868(0xFF0000);
                exportButton.field_22763 = false;
            } else {
                resolutionField.method_1868(65280);
                GlobalProperties.exportResolution = resolution;
                exportButton.field_22763 = true;
            }
        });
        rightBuilder.move(10);
        rightBuilder.label("animation_options");
        if (FFmpegDispatcher.wasFFmpegDetected()) {
            if (FFmpegDispatcher.ffmpegAvailable()) {
                class_342 framesField = rightBuilder.labeledTextField(String.valueOf(GlobalProperties.exportFrames), 30, "animation_frames");
                framesField.method_1890(s -> s.matches("\\d*"));
                framesField.method_1863(s -> {
                    if (s.isBlank()) {
                        return;
                    }
                    GlobalProperties.exportFrames = Integer.parseInt(s);
                });
                class_342 framerateField = rightBuilder.labeledTextField(String.valueOf(GlobalProperties.exportFramerate), 30, "animation_framerate");
                framerateField.method_1890(s -> s.matches("\\d*"));
                framerateField.method_1863(s -> {
                    if (s.isBlank()) {
                        return;
                    }
                    GlobalProperties.exportFramerate = Integer.parseInt(s);
                });
                this.exportAnimationButton = rightBuilder.button("export_animation", 0, 100, button -> {
                    if (this.memoryGuard.canFit(this.estimateMemoryUsage(GlobalProperties.exportFrames)) || class_437.method_25442()) {
                        this.remainingAnimationFrames = GlobalProperties.exportFrames;
                        this.field_22787.method_22683().method_15999(Integer.parseInt(framerateField.method_1882()));
                        IsometricRenders.skipNextWorldRender();
                        button.field_22763 = false;
                        button.method_25355((class_2561)Translate.gui("exporting", new Object[0]));
                    }
                }).withTooltip(this, () -> this.memoryGuard.getStatusTooltip(this.estimateMemoryUsage(GlobalProperties.exportFrames)));
                rightBuilder.button("format." + GlobalProperties.animationFormat.extension, 105, 35, button -> {
                    GlobalProperties.animationFormat = GlobalProperties.animationFormat.next();
                    button.method_25355((class_2561)Translate.gui("format." + GlobalProperties.animationFormat.extension, new Object[0]));
                });
                rightBuilder.nextRow();
            } else {
                rightBuilder.label("no_ffmpeg_1");
                rightBuilder.label("no_ffmpeg_2");
                rightBuilder.move(-6);
                rightBuilder.label("no_ffmpeg_3").clickAction(labelWidget -> {
                    this.field_22787.method_1507((class_437)new class_407(confirmed -> {
                        if (confirmed) {
                            class_156.method_668().method_670("https://ffmpeg.org/download.html");
                        }
                        this.field_22787.method_1507((class_437)this);
                    }, "https://ffmpeg.org/download.html", true));
                    return true;
                });
            }
        } else {
            rightBuilder.label("detecting_ffmpeg");
            FFmpegDispatcher.detectFFmpeg().whenComplete((aBoolean, throwable) -> {
                this.guiRebuildScheduled = true;
            });
        }
        rightBuilder.dynamicLabel(() -> this.remainingAnimationFrames == 0 ? class_2561.method_43473() : Translate.gui("export_remaining_frames", this.remainingAnimationFrames));
        this.notificationStack.setPosition(this.viewportEndX - 10, this.field_22790 - 10);
        this.method_37063(this.notificationStack);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.guiRebuildScheduled) {
            this.method_41843();
            this.guiRebuildScheduled = false;
        }
        if (this.drawOnlyBackground) {
            RenderScreen.method_25294((class_4587)matrices, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (int)(GlobalProperties.backgroundColor | 0xFF000000));
        } else {
            this.method_25420(matrices);
        }
        class_1041 window = this.field_22787.method_22683();
        float effectiveTickDelta = this.playAnimations.get() != false ? this.field_22787.method_1488() : 0.0f;
        RenderableDispatcher.drawIntoActiveFramebuffer(this.renderable, (float)window.method_4489() / (float)window.method_4506(), effectiveTickDelta);
        if (!this.drawOnlyBackground) {
            this.drawFramingHint(matrices);
            this.drawGuiBackground(matrices);
            RenderSystem.clear((int)256, (boolean)class_310.field_1703);
            super.method_25394(matrices, mouseX, mouseY, delta);
            RenderScreen.method_25294((class_4587)matrices, (int)(this.viewportEndX + 160), (int)45, (int)(this.viewportEndX + 168), (int)53, (int)(GlobalProperties.backgroundColor | 0xFF000000));
            this.field_22787.field_1772.method_30883(matrices, (class_2561)Translate.gui("hotkeys", new Object[0]), (float)(this.viewportEndX + 12), (float)(this.field_22790 - 20), 0xAAAAAA);
            this.field_22787.field_1772.method_30883(matrices, (class_2561)Translate.gui("memory_warning1", new Object[0]), 10.0f, (float)(this.field_22790 - 60), 0xAAAAAA);
            this.field_22787.field_1772.method_30883(matrices, (class_2561)Translate.gui("memory_warning2", new Object[0]), 10.0f, (float)(this.field_22790 - 50), 0xAAAAAA);
            this.field_22787.field_1772.method_30883(matrices, (class_2561)Translate.gui("memory_warning3", new Object[0]), 10.0f, (float)(this.field_22790 - 40), 0xAAAAAA);
            this.field_22787.field_1772.method_30883(matrices, (class_2561)Translate.gui("memory_warning4", new Object[0]), 10.0f, (float)(this.field_22790 - 30), 0xAAAAAA);
            this.field_22787.field_1772.method_30883(matrices, (class_2561)Translate.gui("memory_warning5", new Object[0]), 10.0f, (float)(this.field_22790 - 20), 0xAAAAAA);
            if (ImageIO.taskCount() > 1) {
                int exportRootX = this.viewportBeginX + 10;
                int exportRootY = this.field_22790 - 50;
                class_332.method_25294((class_4587)matrices, (int)exportRootX, (int)exportRootY, (int)(exportRootX + 120), (int)(exportRootY + 40), (int)-1879048192);
                this.field_22787.field_1772.method_30883(matrices, ImageIO.progressText(), (float)(exportRootX + 10), (float)(exportRootY + 10), 0xFFFFFF);
                RenderScreen.drawExportProgressBar(matrices, exportRootX + 10, exportRootY + 25, 100, 50, 10.0);
            }
        }
        if (this.captureScheduled) {
            ImageIO.save(RenderableDispatcher.drawIntoImage(this.renderable, 0.0f, GlobalProperties.exportResolution), this.renderable.exportPath()).whenComplete((file, throwable) -> {
                this.exportCallback.accept((File)file);
                this.notificationStack.add(() -> class_156.method_668().method_672(file), new class_2561[]{Translate.gui("exported_as", new Object[0]), class_2561.method_43470((String)ExportPathSpec.exportRoot().relativize(file.toPath()).toString())});
            });
            this.captureScheduled = false;
        }
        if (this.remainingAnimationFrames > 0) {
            this.renderedFrames.add(RenderableDispatcher.drawIntoTexture(this.renderable, effectiveTickDelta, GlobalProperties.exportResolution));
            IsometricRenders.skipNextWorldRender();
            if (--this.remainingAnimationFrames == 0) {
                this.field_22787.method_22683().method_15999(((Integer)this.field_22787.field_1690.method_42524().method_41753()).intValue());
                Boolean overwriteValue = GlobalProperties.overwriteLatest.get();
                GlobalProperties.overwriteLatest.set(false);
                CompletableFuture<File> exportFuture = null;
                for (int i = 0; i < this.renderedFrames.size(); ++i) {
                    exportFuture = ImageIO.save(RenderableDispatcher.copyFramebufferIntoImage(this.renderedFrames.get(i)), ExportPathSpec.forced("sequence", "seq_" + i));
                    this.renderedFrames.get(i).method_1238();
                }
                this.renderedFrames.clear();
                exportFuture.whenComplete((file, throwable) -> {
                    GlobalProperties.overwriteLatest.set(overwriteValue);
                    if (throwable != null) {
                        return;
                    }
                    this.exportAnimationButton.method_25355((class_2561)Translate.gui("converting", new Object[0]));
                    this.notificationStack.add(new class_2561[]{Translate.gui("converting_image_sequence", new Object[0])});
                    FFmpegDispatcher.assemble(this.renderable.exportPath(), ExportPathSpec.exportRoot().resolve("sequence/"), GlobalProperties.animationFormat).whenComplete((animationFile, animationThrowable) -> {
                        this.exportAnimationButton.field_22763 = true;
                        this.exportAnimationButton.method_25355((class_2561)Translate.gui("export_animation", new Object[0]));
                        this.notificationStack.add(() -> class_156.method_668().method_672(animationFile), new class_2561[]{Translate.gui("animation_saved", new Object[0]), class_2561.method_43470((String)ExportPathSpec.exportRoot().relativize(animationFile.toPath()).toString())});
                    });
                });
            }
        }
    }

    private int estimateMemoryUsage(int frames) {
        return (int)((long)(GlobalProperties.exportResolution * GlobalProperties.exportResolution) * 4L * (long)frames / 1024L / 1024L);
    }

    private void drawFramingHint(class_4587 matrices) {
        RenderScreen.method_25294((class_4587)matrices, (int)(this.viewportBeginX + 5), (int)0, (int)(this.viewportEndX - 5), (int)5, (int)-1879048192);
        RenderScreen.method_25294((class_4587)matrices, (int)(this.viewportBeginX + 5), (int)(this.field_22790 - 5), (int)(this.viewportEndX - 5), (int)this.field_22790, (int)-1879048192);
        RenderScreen.method_25294((class_4587)matrices, (int)this.viewportBeginX, (int)0, (int)(this.viewportBeginX + 5), (int)this.field_22790, (int)-1879048192);
        RenderScreen.method_25294((class_4587)matrices, (int)(this.viewportEndX - 5), (int)0, (int)this.viewportEndX, (int)this.field_22790, (int)-1879048192);
    }

    private void drawGuiBackground(class_4587 matrices) {
        RenderScreen.method_25294((class_4587)matrices, (int)0, (int)0, (int)this.viewportBeginX, (int)this.field_22790, (int)-1879048192);
        RenderScreen.method_25294((class_4587)matrices, (int)this.viewportEndX, (int)0, (int)this.field_22789, (int)this.field_22790, (int)-1879048192);
    }

    public void method_25393() {
        Renderable<?> renderable;
        if (this.field_22787.field_1687.method_8510() % 40L == 0L) {
            this.memoryGuard.update();
        }
        if (this.playAnimations.get().booleanValue() && (renderable = this.renderable) instanceof TickingRenderable) {
            TickingRenderable tickable = (TickingRenderable)renderable;
            IsometricRenders.beginRenderableTick();
            tickable.tick();
            IsometricRenders.endRenderableTick();
        }
    }

    private boolean isInViewport(double mouseX) {
        return mouseX > (double)this.viewportBeginX && mouseX < (double)this.viewportEndX;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        Object obj = this.renderable.properties();
        if (!(obj instanceof DefaultPropertyBundle)) {
            return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        DefaultPropertyBundle properties = (DefaultPropertyBundle)obj;
        if (this.isInViewport(mouseX)) {
            if (button == 2) {
                double xScaling = 100.0 / (double)((Integer)properties.scale.get()).intValue() * (double)((float)this.field_22787.method_22683().method_4480() / (float)this.field_22787.method_22683().method_4486());
                double yScaling = 100.0 / (double)((Integer)properties.scale.get()).intValue() * (double)((float)this.field_22787.method_22683().method_4507() / (float)this.field_22787.method_22683().method_4502());
                properties.xOffset.modify((int)(50.0 * deltaX * xScaling));
                properties.yOffset.modify((int)(50.0 * deltaY * yScaling));
                return true;
            }
            if (button == 0) {
                properties.rotation.modify((int)(deltaX * 2.0));
                return true;
            }
            if (button == 1) {
                properties.slant.modify((int)(deltaY * 2.0));
                return true;
            }
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        Object obj = this.renderable.properties();
        if (!(obj instanceof DefaultPropertyBundle)) {
            return super.method_25402(mouseX, mouseY, button);
        }
        DefaultPropertyBundle properties = (DefaultPropertyBundle)obj;
        if (this.isInViewport(mouseX) && class_437.method_25441()) {
            if (button == 2) {
                properties.xOffset.setToDefault();
                properties.yOffset.setToDefault();
            } else if (button == 0) {
                properties.rotation.setToDefault();
            } else if (button == 1) {
                properties.slant.setToDefault();
            }
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        Object obj = this.renderable.properties();
        if (!(obj instanceof DefaultPropertyBundle)) {
            return super.method_25401(mouseX, mouseY, amount);
        }
        DefaultPropertyBundle properties = (DefaultPropertyBundle)obj;
        if (this.isInViewport(mouseX)) {
            properties.scale.modify((int)(amount * Math.max(1.0, (double)((Integer)properties.scale.get()).intValue() * 0.075)));
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 301) {
            this.captureScheduled = true;
        } else if (keyCode == 299) {
            this.drawOnlyBackground = !this.drawOnlyBackground;
        } else if (KEYBOARD_CONTROLS.containsKey(keyCode) && this.renderable instanceof DefaultRenderable) {
            ((Consumer)KEYBOARD_CONTROLS.get(keyCode)).accept((DefaultPropertyBundle)this.renderable.properties());
        }
        return true;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25432() {
        this.renderable.dispose();
        this.field_22787.field_1774.method_1462(false);
        IsometricRenders.particleRestriction = ParticleRestriction.always();
        this.field_22787.method_22683().method_15999(((Integer)this.field_22787.field_1690.method_42524().method_41753()).intValue());
    }

    public void scheduleCapture() {
        this.captureScheduled = true;
    }

    public void setExportCallback(Consumer<File> exportCallback) {
        this.exportCallback = exportCallback;
    }

    public static void drawExportProgressBar(class_4587 matrices, int x, int y, int drawWidth, int barWidth, double speed) {
        int end = x + drawWidth + barWidth;
        int offset = (int)((double)System.currentTimeMillis() / speed % (double)(drawWidth + barWidth));
        int endWithOffset = x + offset;
        if (endWithOffset > end) {
            endWithOffset = end;
        }
        RenderScreen.method_25294((class_4587)matrices, (int)Math.max(x + offset - barWidth, x), (int)y, (int)Math.min(endWithOffset, x + drawWidth), (int)(y + 2), (int)-16711936);
    }

    static {
        KEYBOARD_CONTROLS.put(87, properties -> properties.yOffset.modify(-1000));
        KEYBOARD_CONTROLS.put(83, properties -> properties.yOffset.modify(1000));
        KEYBOARD_CONTROLS.put(68, properties -> properties.xOffset.modify(1000));
        KEYBOARD_CONTROLS.put(65, properties -> properties.xOffset.modify(-1000));
        KEYBOARD_CONTROLS.put(265, properties -> properties.slant.modify(-5));
        KEYBOARD_CONTROLS.put(264, properties -> properties.slant.modify(5));
        KEYBOARD_CONTROLS.put(263, properties -> properties.rotation.modify(-10));
        KEYBOARD_CONTROLS.put(262, properties -> properties.rotation.modify(10));
        KEYBOARD_CONTROLS.put(93, properties -> properties.scale.modify(10));
        KEYBOARD_CONTROLS.put(47, properties -> properties.scale.modify(-10));
    }
}

