/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.isometricrenders.render;

import com.glisco.isometricrenders.property.DefaultPropertyBundle;
import com.glisco.isometricrenders.property.IntProperty;
import com.glisco.isometricrenders.render.DefaultRenderable;
import com.glisco.isometricrenders.render.Renderable;
import com.glisco.isometricrenders.util.ExportPathSpec;
import com.glisco.isometricrenders.widget.WidgetColumnBuilder;
import java.util.List;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_809;

public class ItemAtlasRenderable
extends DefaultRenderable<ItemAtlasPropertyBundle> {
    private final class_310 client = class_310.method_1551();
    private final List<class_1799> items;
    private final String atlasSource;

    public ItemAtlasRenderable(String atlasSource, List<class_1799> items) {
        this.atlasSource = atlasSource;
        this.items = items;
    }

    @Override
    public void emitVertices(class_4587 matrices, class_4597 vertexConsumers, float tickDelta) {
        int columns = (Integer)this.properties().columns.get();
        int rows = class_3532.method_38788((int)this.items.size(), (int)columns);
        float spacing = 1.25f;
        matrices.method_22905(0.1f, 0.1f, 0.1f);
        matrices.method_22904((double)((float)(-columns) / 2.0f * 1.25f - 0.625f), (double)((float)rows / 2.0f * 1.25f + 0.625f), 0.0);
        for (int row = 0; row < rows; ++row) {
            matrices.method_22904(0.0, -1.25, 0.0);
            matrices.method_22903();
            for (int column = 0; column < columns; ++column) {
                matrices.method_22904(1.25, 0.0, 0.0);
                int index = row * columns + column;
                if (index >= this.items.size()) continue;
                this.client.method_1480().method_23178(this.items.get(index), class_809.class_811.field_4317, 0xF000F0, class_4608.field_21444, matrices, vertexConsumers, 0);
            }
            matrices.method_22909();
        }
    }

    @Override
    public ItemAtlasPropertyBundle properties() {
        return ItemAtlasPropertyBundle.INSTANCE;
    }

    @Override
    public ExportPathSpec exportPath() {
        return ExportPathSpec.of("atlases", this.atlasSource);
    }

    public static class ItemAtlasPropertyBundle
    extends DefaultPropertyBundle {
        private static final ItemAtlasPropertyBundle INSTANCE = new ItemAtlasPropertyBundle();
        private final IntProperty columns = IntProperty.of(20, 1, 500);

        @Override
        public void buildGuiControls(Renderable<?> renderable, WidgetColumnBuilder builder) {
            builder.label("transform_options");
            this.appendIntControls(builder, this.scale, "scale", 10);
            this.appendIntControls(builder, this.columns, "columns", 1);
        }

        @Override
        public void applyToViewMatrix(class_4587 modelViewStack) {
            super.applyToViewMatrix(modelViewStack);
            modelViewStack.method_22907(class_1160.field_20705.method_23214((float)(-((Integer)this.rotation.get()).intValue())));
            modelViewStack.method_22907(class_1160.field_20703.method_23214((float)(-((Integer)this.slant.get()).intValue())));
        }
    }
}

