/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.isometricrenders.render;

import com.glisco.isometricrenders.property.DefaultPropertyBundle;
import com.glisco.isometricrenders.property.GlobalProperties;
import com.glisco.isometricrenders.property.PropertyBundle;
import com.glisco.isometricrenders.render.Renderable;
import com.glisco.isometricrenders.render.RenderableDispatcher;
import com.glisco.isometricrenders.util.ExportPathSpec;
import com.glisco.isometricrenders.util.ImageIO;
import com.glisco.isometricrenders.util.Translate;
import com.glisco.isometricrenders.widget.IsometricButtonWidget;
import com.glisco.isometricrenders.widget.WidgetColumnBuilder;
import java.util.List;
import net.minecraft.class_1011;
import net.minecraft.class_1159;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class BatchRenderable<R extends Renderable<?>>
implements Renderable<BatchPropertyBundle> {
    private final BatchPropertyBundle properties;
    private final List<R> delegates;
    private final String contentType;
    private R currentDelegate;
    private int currentIndex;
    private long renderDelay;
    private long lastRenderTime;
    private boolean batchActive;

    private BatchRenderable(String source, List<R> delegates) {
        this.delegates = delegates;
        this.reset();
        this.contentType = ExportPathSpec.exportRoot().resolve("batches/").relativize(ImageIO.next(ExportPathSpec.exportRoot().resolve("batches/" + source + "/"))).toString();
        this.properties = new BatchPropertyBundle((PropertyBundle)this.currentDelegate.properties());
        this.renderDelay = Math.max((long)((int)Math.pow((float)GlobalProperties.exportResolution / 1024.0f, 2.0)) * 100L, 75L);
    }

    public static <R extends Renderable<?>> BatchRenderable<?> of(String source, List<R> delegates) {
        if (delegates.isEmpty()) {
            return new BatchRenderable<Renderable<PropertyBundle>>(source, List.of(Renderable.EMPTY));
        }
        return new BatchRenderable<R>(source, delegates);
    }

    @Override
    public void emitVertices(class_4587 matrices, class_4597 vertexConsumers, float tickDelta) {
        this.currentDelegate.emitVertices(matrices, vertexConsumers, tickDelta);
        if (this.batchActive && this.currentIndex < this.delegates.size() && System.currentTimeMillis() - this.lastRenderTime > this.renderDelay && ImageIO.taskCount() <= 5) {
            class_1011 image = RenderableDispatcher.drawIntoImage(this.currentDelegate, 0.0f, GlobalProperties.exportResolution);
            ImageIO.save(image, this.exportPath());
            ++this.currentIndex;
            this.currentDelegate = this.currentIndex < this.delegates.size() ? (Renderable)this.delegates.get(this.currentIndex) : this.currentDelegate;
            this.lastRenderTime = System.currentTimeMillis();
        }
    }

    @Override
    public void draw(class_1159 modelViewMatrix) {
        this.currentDelegate.draw(modelViewMatrix);
    }

    private void start() {
        this.batchActive = true;
        this.currentIndex = 0;
        this.lastRenderTime = System.currentTimeMillis();
        this.renderDelay = Math.max((long)((int)Math.pow((float)GlobalProperties.exportResolution / 1024.0f, 2.0)) * 100L, 75L);
    }

    private void reset() {
        this.batchActive = false;
        this.lastRenderTime = -1L;
        this.currentIndex = -1;
        this.currentDelegate = (Renderable)this.delegates.get(0);
    }

    @Override
    public BatchPropertyBundle properties() {
        return this.properties;
    }

    @Override
    public ExportPathSpec exportPath() {
        return this.currentDelegate.exportPath().relocate("batches/" + this.contentType);
    }

    public static class BatchPropertyBundle
    extends DefaultPropertyBundle {
        private final PropertyBundle delegate;

        public BatchPropertyBundle(PropertyBundle delegate) {
            PropertyBundle propertyBundle = this.delegate = delegate;
            if (propertyBundle instanceof DefaultPropertyBundle) {
                DefaultPropertyBundle defaultPropertyBundle = (DefaultPropertyBundle)propertyBundle;
                this.scale.copyFrom(defaultPropertyBundle.scale);
                this.rotation.copyFrom(defaultPropertyBundle.rotation);
                this.slant.copyFrom(defaultPropertyBundle.slant);
                this.lightAngle.copyFrom(defaultPropertyBundle.lightAngle);
                this.xOffset.copyFrom(defaultPropertyBundle.xOffset);
                this.yOffset.copyFrom(defaultPropertyBundle.yOffset);
                this.scale.listen(defaultPropertyBundle.scale);
                this.rotation.listen(defaultPropertyBundle.rotation);
                this.slant.listen(defaultPropertyBundle.slant);
                this.lightAngle.listen(defaultPropertyBundle.lightAngle);
                this.xOffset.listen(defaultPropertyBundle.xOffset);
                this.yOffset.listen(defaultPropertyBundle.yOffset);
            }
        }

        @Override
        public void buildGuiControls(Renderable<?> renderable, WidgetColumnBuilder builder) {
            BatchRenderable batchRenderable = (BatchRenderable)renderable;
            this.delegate.buildGuiControls((Renderable<?>)batchRenderable.currentDelegate, builder);
            builder.move(10);
            builder.label("batch.controls");
            IsometricButtonWidget startButton = builder.button("batch.start", 0, 60, button -> {
                batchRenderable.start();
                button.field_22763 = false;
            });
            builder.button("batch.reset", 65, 60, button -> {
                batchRenderable.reset();
                startButton.field_22763 = true;
            });
            builder.nextRow();
            builder.dynamicLabel(() -> Translate.gui("batch.remaining", Math.max(0, batchRenderable.delegates.size() - batchRenderable.currentIndex - 1), batchRenderable.delegates.size()));
        }

        @Override
        public void applyToViewMatrix(class_4587 modelViewStack) {
            this.delegate.applyToViewMatrix(modelViewStack);
        }
    }
}

