/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.isometricrenders.render;

import com.glisco.isometricrenders.property.DefaultPropertyBundle;
import com.glisco.isometricrenders.property.Property;
import com.glisco.isometricrenders.render.DefaultRenderable;
import com.glisco.isometricrenders.render.Renderable;
import com.glisco.isometricrenders.util.ExportPathSpec;
import com.glisco.isometricrenders.util.ParticleRestriction;
import com.glisco.isometricrenders.util.Translate;
import com.glisco.isometricrenders.widget.WidgetColumnBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.worldmesher.WorldMesh;
import java.util.HashMap;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;

public class AreaRenderable
extends DefaultRenderable<AreaPropertyBundle> {
    private final class_310 client = class_310.method_1551();
    private final WorldMesh mesh;
    private final int ySize;
    private final int xSize;
    private final int zSize;

    public AreaRenderable(WorldMesh mesh) {
        this.mesh = mesh;
        class_238 dimensions = mesh.dimensions();
        this.xSize = (int)dimensions.method_17939() + 1;
        this.ySize = (int)dimensions.method_17940() + 1;
        this.zSize = (int)dimensions.method_17941() + 1;
    }

    public static AreaRenderable of(class_2338 origin, class_2338 end) {
        WorldMesh.Builder builder = new WorldMesh.Builder((class_1937)class_310.method_1551().field_1687, origin, end);
        if (AreaPropertyBundle.INSTANCE.freezeEntities.get().booleanValue()) {
            builder.freezeEntities();
        }
        return new AreaRenderable(builder.build());
    }

    @Override
    public void emitVertices(class_4587 matrices, class_4597 vertexConsumers, float tickDelta) {
        if (!this.mesh.canRender()) {
            this.mesh.scheduleRebuild();
            return;
        }
        matrices.method_34426();
        matrices.method_22904((double)((float)(-this.xSize) / 2.0f), (double)((float)(-this.ySize) / 2.0f), (double)((float)(-this.zSize) / 2.0f));
        HashMap blockEntities = this.mesh.getRenderInfo().getBlockEntities();
        blockEntities.forEach((blockPos, entity) -> {
            matrices.method_22903();
            matrices.method_22904((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260());
            this.client.method_31975().method_3555(entity, 0.0f, matrices, vertexConsumers);
            matrices.method_22909();
        });
        super.draw(RenderSystem.getModelViewMatrix());
        float effectiveDelta = this.mesh.entitiesFrozen() ? 0.0f : this.client.method_1488();
        HashMap entities = this.mesh.getRenderInfo().getEntities();
        entities.forEach((vec3d, entry) -> {
            if (!this.mesh.entitiesFrozen()) {
                vec3d = entry.entity().method_30950(effectiveDelta).method_1023((double)this.mesh.startPos().method_10263(), (double)this.mesh.startPos().method_10264(), (double)this.mesh.startPos().method_10260());
            }
            this.client.method_1561().method_3954(entry.entity(), vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, entry.entity().method_5705(effectiveDelta), effectiveDelta, matrices, vertexConsumers, entry.light());
            super.draw(RenderSystem.getModelViewMatrix());
        });
        class_243 diff = class_243.method_24954((class_2382)this.mesh.startPos()).method_1020(this.client.field_1724.method_19538());
        matrices.method_22904(-diff.field_1352, -diff.field_1351 + 1.65, -diff.field_1350);
        this.client.field_1713.method_3049(matrices, (class_4597.class_4598)vertexConsumers, this.client.field_1773.method_22974(), this.getParticleCamera(), tickDelta);
    }

    @Override
    public void draw(class_1159 modelViewMatrix) {
        if (!this.mesh.canRender()) {
            return;
        }
        super.draw(modelViewMatrix);
        class_4587 meshStack = new class_4587();
        meshStack.method_34425(modelViewMatrix);
        meshStack.method_22904((double)((float)(-this.xSize) / 2.0f), (double)((float)(-this.ySize) / 2.0f), (double)((float)(-this.zSize) / 2.0f));
        this.mesh.render(meshStack);
    }

    @Override
    public AreaPropertyBundle properties() {
        return AreaPropertyBundle.INSTANCE;
    }

    @Override
    public ParticleRestriction<?> particleRestriction() {
        class_238 dimensions = this.mesh.dimensions();
        return ParticleRestriction.inArea(new class_238(dimensions.field_1323, dimensions.field_1322, dimensions.field_1321, dimensions.field_1320 + 1.0, dimensions.field_1325 + 1.0, dimensions.field_1324 + 1.0));
    }

    @Override
    public ExportPathSpec exportPath() {
        return ExportPathSpec.of("area_renders", "area_render");
    }

    public static class AreaPropertyBundle
    extends DefaultPropertyBundle {
        private static final AreaPropertyBundle INSTANCE = new AreaPropertyBundle();
        public final Property<Boolean> freezeEntities = Property.of(true);

        @Override
        public void buildGuiControls(Renderable<?> renderable, WidgetColumnBuilder builder) {
            super.buildGuiControls(renderable, builder);
            WorldMesh mesh = ((AreaRenderable)renderable).mesh;
            builder.move(10);
            builder.label("mesh_controls");
            builder.dynamicLabel(() -> {
                class_5250 meshStatus = Translate.gui("mesh_status", new Object[0]);
                if (!mesh.getState().isBuildStage) {
                    meshStatus.method_10852((class_2561)Translate.gui("mesh_ready", new Object[0]).method_27692(class_124.field_1060));
                } else {
                    meshStatus.method_10852((class_2561)Translate.gui(mesh.getState() == WorldMesh.MeshState.BUILDING ? "mesh_building" : "mesh_rebuilding", (int)(mesh.getBuildProgress() * 100.0f)).method_27692(class_124.field_1061));
                }
                return meshStatus;
            });
            builder.propertyCheckbox(this.freezeEntities, "freeze_entities");
            this.freezeEntities.listen((booleanProperty, aBoolean) -> mesh.setFreezeEntities(aBoolean.booleanValue()));
            builder.button("rebuild_mesh", 0, 80, button -> mesh.scheduleRebuild());
        }

        @Override
        public void applyToViewMatrix(class_4587 modelViewStack) {
            float scale = (float)((Integer)this.scale.get()).intValue() / 1000.0f;
            modelViewStack.method_22905(scale, scale, scale);
            modelViewStack.method_22904((double)((Integer)this.xOffset.get()).intValue() / 2600.0, (double)((Integer)this.yOffset.get()).intValue() / -2600.0, 0.0);
            modelViewStack.method_22907(class_1160.field_20703.method_23214((float)((Integer)this.slant.get()).intValue()));
            modelViewStack.method_22907(class_1160.field_20705.method_23214((float)((Integer)this.rotation.get()).intValue()));
            this.updateAndApplyRotationOffset(modelViewStack);
        }
    }
}

