/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.isometricrenders.property;

import com.glisco.isometricrenders.property.Property;
import net.minecraft.class_3532;

public class IntProperty
extends Property<Integer> {
    private final int max;
    private final int min;
    private final int span;
    private boolean allowRollover = false;

    private IntProperty(int defaultValue, int min, int max) {
        super(defaultValue);
        this.min = min;
        this.max = max;
        this.span = this.max - this.min;
    }

    public static IntProperty of(int defaultValue, int min, int max) {
        if (min >= max) {
            throw new IllegalArgumentException("'min' must be less than 'max'");
        }
        return new IntProperty(defaultValue, min, max);
    }

    public IntProperty withRollover() {
        this.allowRollover = true;
        return this;
    }

    public void modify(int by) {
        if (this.allowRollover) {
            this.value = (Integer)this.value + by;
            if ((Integer)this.value > this.max) {
                this.value = (Integer)this.value - this.span;
            }
            if ((Integer)this.value < this.min) {
                this.value = (Integer)this.value + this.span;
            }
        } else {
            this.value = class_3532.method_15340((int)((Integer)this.value + by), (int)this.min, (int)this.max);
        }
        this.invokeListeners();
    }

    public double progress() {
        return (double)((Integer)this.value - this.min) / (double)this.span;
    }

    public void setFromProgress(double progress) {
        this.value = (int)((double)this.min + progress * (double)this.span);
        this.invokeListeners();
    }

    public int max() {
        return this.max;
    }

    public int min() {
        return this.min;
    }
}

