/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.isometricrenders.property;

import com.glisco.isometricrenders.property.IntProperty;
import com.glisco.isometricrenders.property.PropertyBundle;
import com.glisco.isometricrenders.render.Renderable;
import com.glisco.isometricrenders.util.ClientRenderCallback;
import com.glisco.isometricrenders.widget.WidgetColumnBuilder;
import net.minecraft.class_1160;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class DefaultPropertyBundle
implements PropertyBundle {
    private static final DefaultPropertyBundle INSTANCE = new DefaultPropertyBundle();
    public final IntProperty scale = IntProperty.of(100, 0, 500);
    public final IntProperty rotation = IntProperty.of(135, 0, 360).withRollover();
    public final IntProperty slant = IntProperty.of(30, -90, 90);
    public final IntProperty lightAngle = IntProperty.of(-45, -45, 45);
    public final IntProperty xOffset = IntProperty.of(0, -1073741824, 0x3FFFFFFF);
    public final IntProperty yOffset = IntProperty.of(0, -1073741824, 0x3FFFFFFF);
    public final IntProperty rotationSpeed = IntProperty.of(0, 0, 100);
    protected float rotationOffset = 0.0f;
    protected boolean rotationOffsetUpdated = false;

    public DefaultPropertyBundle() {
        ClientRenderCallback.EVENT.register(client -> {
            this.rotationOffsetUpdated = false;
        });
    }

    @Override
    public void buildGuiControls(Renderable<?> renderable, WidgetColumnBuilder builder) {
        builder.label("transform_options");
        this.appendIntControls(builder, this.scale, "scale", 10);
        this.appendIntControls(builder, this.rotation, "rotation", 45);
        this.appendIntControls(builder, this.slant, "slant", 30);
        this.appendIntControls(builder, this.lightAngle, "light_angle", 15);
        this.appendIntControls(builder, this.rotationSpeed, "rotation_speed", 5);
        builder.move(10);
        builder.label("presets");
        builder.button("dimetric", 0, 60, button -> {
            this.rotation.setToDefault();
            this.slant.set(30);
        });
        builder.button("isometric", 65, 60, button -> {
            this.rotation.setToDefault();
            this.slant.set(36);
        });
        builder.nextRow();
    }

    @Override
    public void applyToViewMatrix(class_4587 modelViewStack) {
        float scale = (float)((Integer)this.scale.get()).intValue() / 100.0f;
        modelViewStack.method_22905(scale, scale, scale);
        modelViewStack.method_22904((double)((Integer)this.xOffset.get()).intValue() / 26000.0, (double)((Integer)this.yOffset.get()).intValue() / -26000.0, 0.0);
        modelViewStack.method_22907(class_1160.field_20703.method_23214((float)((Integer)this.slant.get()).intValue()));
        modelViewStack.method_22907(class_1160.field_20705.method_23214((float)((Integer)this.rotation.get()).intValue()));
        this.updateAndApplyRotationOffset(modelViewStack);
    }

    public float rotationOffset() {
        return this.rotationOffset;
    }

    protected void updateAndApplyRotationOffset(class_4587 modelViewStack) {
        if ((Integer)this.rotationSpeed.get() != 0) {
            if (!this.rotationOffsetUpdated) {
                this.rotationOffset += class_310.method_1551().method_1534() * (float)((Integer)this.rotationSpeed.get()).intValue() * 0.1f;
                this.rotationOffsetUpdated = true;
            }
            modelViewStack.method_22907(class_1160.field_20705.method_23214(this.rotationOffset));
        } else {
            this.rotationOffset = 0.0f;
        }
    }

    public static DefaultPropertyBundle get() {
        return INSTANCE;
    }
}

