/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.isometricrenders.command;

import com.glisco.isometricrenders.IsometricRenders;
import com.glisco.isometricrenders.command.ItemGroupArgumentType;
import com.glisco.isometricrenders.command.NamespaceArgumentType;
import com.glisco.isometricrenders.command.RenderTaskArgumentType;
import com.glisco.isometricrenders.command.TagArgumentType;
import com.glisco.isometricrenders.mixin.access.BlockStateArgumentAccessor;
import com.glisco.isometricrenders.mixin.access.DefaultPosArgumentAccessor;
import com.glisco.isometricrenders.mixin.access.EntitySummonArgumentTypeInvoker;
import com.glisco.isometricrenders.property.GlobalProperties;
import com.glisco.isometricrenders.render.AreaRenderable;
import com.glisco.isometricrenders.render.BlockStateRenderable;
import com.glisco.isometricrenders.render.EntityRenderable;
import com.glisco.isometricrenders.render.ItemRenderable;
import com.glisco.isometricrenders.render.RenderTask;
import com.glisco.isometricrenders.render.TooltipRenderable;
import com.glisco.isometricrenders.screen.RenderScreen;
import com.glisco.isometricrenders.screen.ScreenScheduler;
import com.glisco.isometricrenders.util.AreaSelectionHelper;
import com.glisco.isometricrenders.util.Translate;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2172;
import net.minecraft.class_2179;
import net.minecraft.class_2188;
import net.minecraft.class_2247;
import net.minecraft.class_2257;
import net.minecraft.class_2262;
import net.minecraft.class_2280;
import net.minecraft.class_2287;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6880;
import net.minecraft.class_7157;

public class IsorenderCommand {
    private static final SuggestionProvider<FabricClientCommandSource> CLIENT_SUMMONABLE_ENTITIES = (context, builder) -> class_2172.method_9271(class_2378.field_11145.method_10220().filter(class_1299::method_5896), (SuggestionsBuilder)builder, class_1299::method_5890, entityType -> class_2561.method_43471((String)class_156.method_646((String)"entity", (class_2960)class_1299.method_5890((class_1299)entityType))));

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 access) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"isorender").executes(IsorenderCommand::showRootNodeHelp)).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"area").executes(IsorenderCommand::renderAreaSelection)).then(ClientCommandManager.argument((String)"start", (ArgumentType)class_2262.method_9698()).then(ClientCommandManager.argument((String)"end", (ArgumentType)class_2262.method_9698()).executes(IsorenderCommand::renderAreaWithArguments))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"block").executes(IsorenderCommand::renderTargetedBlock)).then(ClientCommandManager.argument((String)"block", (ArgumentType)class_2257.method_9653((class_7157)access)).executes(IsorenderCommand::renderBlockWithArgument)))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"entity").executes(IsorenderCommand::renderTargetedEntity)).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"entity", (ArgumentType)class_2188.method_9324()).suggests(CLIENT_SUMMONABLE_ENTITIES).executes(IsorenderCommand::renderEntityWithoutNbt)).then(ClientCommandManager.argument((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(IsorenderCommand::renderEntityWithNbt))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"item").executes(IsorenderCommand::renderHeldItem)).then(ClientCommandManager.argument((String)"item", (ArgumentType)class_2287.method_9776((class_7157)access)).executes(IsorenderCommand::renderItemWithArgument)))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"tooltip").executes(IsorenderCommand::renderHeldItemTooltip)).then(ClientCommandManager.argument((String)"item", (ArgumentType)class_2287.method_9776((class_7157)access)).executes(IsorenderCommand::renderItemTooltipWithArgument)))).then(ClientCommandManager.literal((String)"namespace").then(ClientCommandManager.argument((String)"namespace", (ArgumentType)NamespaceArgumentType.namespace()).then(ClientCommandManager.argument((String)"task", (ArgumentType)new RenderTaskArgumentType()).executes(IsorenderCommand::renderNamespace))))).then(ClientCommandManager.literal((String)"creative_tab").then(ClientCommandManager.argument((String)"itemgroup", (ArgumentType)ItemGroupArgumentType.itemGroup()).then(ClientCommandManager.argument((String)"task", (ArgumentType)new RenderTaskArgumentType()).executes(IsorenderCommand::renderCreativeTab))))).then(ClientCommandManager.literal((String)"tag").then(ClientCommandManager.argument((String)"tag", (ArgumentType)new TagArgumentType(access)).then(ClientCommandManager.argument((String)"task", (ArgumentType)new RenderTaskArgumentType()).executes(IsorenderCommand::renderTagContents))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"unsafe").then(ClientCommandManager.literal((String)"enable").executes(IsorenderCommand::enableUnsafe))).then(ClientCommandManager.literal((String)"disable").executes(IsorenderCommand::disableUnsafe))));
    }

    private static int showRootNodeHelp(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        source.sendFeedback((class_2561)Translate.prefixed((class_2561)Translate.make("version", class_2561.method_43470((String)IsometricRenders.VERSION).method_27692(class_124.field_1063)).method_27692(class_124.field_1080)));
        source.sendFeedback((class_2561)Translate.prefixed((class_2561)Translate.make("command_hint", new Object[0]).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://docs.wispforest.io/isometric-renders/slash_isorender/")).method_27706(class_124.field_1073).method_27706(class_124.field_1080))));
        return 0;
    }

    private static int disableUnsafe(CommandContext<FabricClientCommandSource> context) {
        GlobalProperties.unsafe.set(false);
        Translate.commandFeedback(context, "unsafe_disabled", new Object[0]);
        return 0;
    }

    private static int enableUnsafe(CommandContext<FabricClientCommandSource> context) {
        GlobalProperties.unsafe.set(true);
        Translate.commandFeedback(context, "unsafe_enabled", new Object[0]);
        return 0;
    }

    private static int renderTagContents(CommandContext<FabricClientCommandSource> context) {
        TagArgumentType.TagArgument tag = TagArgumentType.getTag("tag", context);
        RenderTaskArgumentType.getTask((String)"task", context).action.accept("tag_" + tag.id(), tag.entries().method_40239().map(class_6880::comp_349).map(class_1792::method_7854).toList());
        return 0;
    }

    private static int renderCreativeTab(CommandContext<FabricClientCommandSource> context) {
        RenderTask task = RenderTaskArgumentType.getTask("task", context);
        IsorenderCommand.withItemGroupFromContext(context, (itemStacks, name) -> task.action.accept((String)name, (Collection<class_1799>)itemStacks));
        return 0;
    }

    private static int renderNamespace(CommandContext<FabricClientCommandSource> context) {
        NamespaceArgumentType.Namespace namespace = NamespaceArgumentType.getNamespace("namespace", context);
        RenderTaskArgumentType.getTask((String)"task", context).action.accept("namespace_" + namespace.name(), namespace.getContent());
        return 0;
    }

    private static int renderItemWithArgument(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        ScreenScheduler.schedule(new RenderScreen(new ItemRenderable(class_2287.method_9777(context, (String)"item").method_9781(1, false))));
        return 0;
    }

    private static int renderHeldItem(CommandContext<FabricClientCommandSource> context) {
        ScreenScheduler.schedule(new RenderScreen(new ItemRenderable(class_310.method_1551().field_1724.method_6047())));
        return 0;
    }

    private static int renderItemTooltipWithArgument(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        ScreenScheduler.schedule(new RenderScreen(new TooltipRenderable(class_2287.method_9777(context, (String)"item").method_9781(1, false))));
        return 0;
    }

    private static int renderHeldItemTooltip(CommandContext<FabricClientCommandSource> context) {
        ScreenScheduler.schedule(new RenderScreen(new TooltipRenderable(class_310.method_1551().field_1724.method_6047())));
        return 0;
    }

    private static int renderEntityWithNbt(CommandContext<FabricClientCommandSource> context) {
        class_2487 entityNbt = class_2179.method_9285(context, (String)"nbt");
        class_2960 entityId = EntitySummonArgumentTypeInvoker.isometric$validate((class_2960)context.getArgument("entity", class_2960.class));
        ScreenScheduler.schedule(new RenderScreen(EntityRenderable.of((class_1299)class_2378.field_11145.method_10223(entityId), entityNbt)));
        return 0;
    }

    private static int renderEntityWithoutNbt(CommandContext<FabricClientCommandSource> context) {
        class_2960 entityId = EntitySummonArgumentTypeInvoker.isometric$validate((class_2960)context.getArgument("entity", class_2960.class));
        ScreenScheduler.schedule(new RenderScreen(EntityRenderable.of((class_1299)class_2378.field_11145.method_10223(entityId), null)));
        return 0;
    }

    private static int renderTargetedEntity(CommandContext<FabricClientCommandSource> context) {
        class_310 client = class_310.method_1551();
        if (client.field_1765.method_17783() != class_239.class_240.field_1331) {
            Translate.commandError(context, "no_entity", new Object[0]);
            return 0;
        }
        class_1297 targetEntity = ((class_3966)client.field_1765).method_17782();
        ScreenScheduler.schedule(new RenderScreen(EntityRenderable.copyOf(targetEntity)));
        return 0;
    }

    private static int renderBlockWithArgument(CommandContext<FabricClientCommandSource> context) {
        class_2247 stateArg = (class_2247)context.getArgument("block", class_2247.class);
        class_2680 state = stateArg.method_9494();
        class_2487 data = ((BlockStateArgumentAccessor)stateArg).isometric$getData();
        ScreenScheduler.schedule(new RenderScreen(BlockStateRenderable.of(state, data)));
        return 0;
    }

    private static int renderTargetedBlock(CommandContext<FabricClientCommandSource> context) {
        class_310 client = class_310.method_1551();
        if (client.field_1765.method_17783() != class_239.class_240.field_1332) {
            Translate.commandError(context, "no_block", new Object[0]);
            return 0;
        }
        class_2338 hitPos = ((class_3965)client.field_1765).method_17777();
        ScreenScheduler.schedule(new RenderScreen(BlockStateRenderable.copyOf((class_1937)client.field_1687, hitPos)));
        return 0;
    }

    private static int renderAreaWithArguments(CommandContext<FabricClientCommandSource> context) {
        class_2280 startArg = (class_2280)context.getArgument("start", class_2280.class);
        class_2280 endArg = (class_2280)context.getArgument("end", class_2280.class);
        class_2338 pos1 = IsorenderCommand.getPosFromArgument(startArg, (FabricClientCommandSource)context.getSource());
        class_2338 pos2 = IsorenderCommand.getPosFromArgument(endArg, (FabricClientCommandSource)context.getSource());
        ScreenScheduler.schedule(new RenderScreen(AreaRenderable.of(pos1, pos2)));
        return 0;
    }

    private static int renderAreaSelection(CommandContext<FabricClientCommandSource> context) {
        if (!AreaSelectionHelper.tryOpenScreen()) {
            Translate.commandError(context, "incomplete_selection", new Object[0]);
        }
        return 0;
    }

    private static <S> void withItemGroupFromContext(CommandContext<S> context, BiConsumer<List<class_1799>, String> action) {
        class_1761 itemGroup = ItemGroupArgumentType.getItemGroup("itemgroup", context);
        class_2371 stacks = class_2371.method_10211();
        itemGroup.method_7738(stacks);
        action.accept((List<class_1799>)stacks, "creative-tab_" + itemGroup.method_7751());
    }

    public static class_2338 getPosFromArgument(class_2280 argument, FabricClientCommandSource source) {
        DefaultPosArgumentAccessor accessor = (DefaultPosArgumentAccessor)argument;
        class_243 pos = source.getPlayer().method_19538();
        return new class_2338(accessor.isometric$getX().method_9740(pos.field_1352), accessor.isometric$getY().method_9740(pos.field_1351), accessor.isometric$getZ().method_9740(pos.field_1350));
    }
}

