/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.fabric;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import journeymap.common.network.data.NetworkHandler;
import journeymap.common.network.data.PacketContainer;
import journeymap.common.network.data.PacketContext;
import journeymap.common.network.data.Side;
import journeymap.common.network.packets.PacketManager;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class FabricNetworkHandler
extends PacketManager
implements NetworkHandler {
    private final Map<Class<?>, Message<?>> MESSAGE_MAP = new HashMap();

    public FabricNetworkHandler(Side side) {
        this.PACKET_MAP.forEach((clazz, packetContainer) -> this.registerPacket((PacketContainer)packetContainer, side));
    }

    private <T> void registerPacket(PacketContainer<T> container, Side side) {
        this.MESSAGE_MAP.put(container.messageType(), new Message<T>(container.packetIdentifier(), container.encoder()));
        if (Side.CLIENT.equals((Object)side)) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)container.packetIdentifier(), (client, listener, buf, responseSender) -> {
                buf.readByte();
                Object message = container.decoder().apply(buf);
                client.execute(() -> container.handler().accept(new PacketContext<Object>(message, side)));
            });
        } else {
            ServerPlayNetworking.registerGlobalReceiver((class_2960)container.packetIdentifier(), (server, player, listener, buf, responseSender) -> {
                buf.readByte();
                Object message = container.decoder().apply(buf);
                server.execute(() -> container.handler().accept(new PacketContext<Object>(player, message, side)));
            });
        }
    }

    @Override
    public <T> void sendToServer(T packet) {
        Message<?> message = this.MESSAGE_MAP.get(packet.getClass());
        class_2540 buf = PacketByteBufs.create();
        buf.writeByte(0);
        message.encoder().accept(packet, buf);
        ClientPlayNetworking.send((class_2960)message.id(), (class_2540)buf);
    }

    @Override
    public <T> void sendToClient(T packet, class_3222 player) {
        Message<?> message = this.MESSAGE_MAP.get(packet.getClass());
        class_2540 buf = PacketByteBufs.create();
        buf.writeByte(0);
        message.encoder().accept(packet, buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)message.id(), (class_2540)buf);
    }

    public record Message<T>(class_2960 id, BiConsumer<T, class_2540> encoder) {
    }
}

