/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.config.fabric;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Since;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import journeymap.common.Journeymap;
import journeymap.common.LoaderHooks;
import journeymap.common.config.AdminConfig;
import journeymap.common.log.LogFormatter;

public class FabricConfig
implements AdminConfig,
Serializable {
    private final File adminFile = new File(LoaderHooks.getServer().method_3831(), "config/journeymap-server.json");
    public List<String> admins = new ArrayList<String>();
    public boolean opAccess = true;

    @Override
    public boolean getOpAccess() {
        return this.opAccess;
    }

    @Override
    public List<String> getAdmins() {
        return this.admins;
    }

    @Override
    public void load() {
        FabricServerConfig config = this.load(this.adminFile);
        if (config != null) {
            this.admins = config.admins;
            this.opAccess = config.opAccess;
        }
    }

    private FabricServerConfig load(File configFile) {
        String configString = null;
        try {
            FabricServerConfig config;
            if (configFile.exists()) {
                configString = Files.asCharSource((File)configFile, (Charset)StandardCharsets.UTF_8).read();
                config = FabricServerConfig.fromString(configString);
            } else {
                config = new FabricServerConfig(true, "79f597fe-2877-4ecb-acdf-8c58cc1854ca");
                configFile.getParentFile().mkdirs();
                if (!configFile.exists()) {
                    configFile.createNewFile();
                }
                this.save(config);
            }
            return config;
        }
        catch (Throwable e) {
            Journeymap.getLogger().error(String.format("Can't load Admin Config file %s with contents: %s because %s", configFile, configString, e.getMessage()));
            return null;
        }
    }

    private boolean save(FabricServerConfig config) {
        try {
            Files.asCharSink((File)this.adminFile, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)config.toJson());
            return true;
        }
        catch (Exception e) {
            Journeymap.getLogger().error(String.format("Can't save Admin Config file %s: %s", this.adminFile, LogFormatter.toString(e)));
            return false;
        }
    }

    public static class FabricServerConfig
    implements Serializable {
        public static final int VERSION = 1;
        public static final Gson GSON = new GsonBuilder().setVersion(1.0).create();
        @Since(value=1.0)
        protected boolean opAccess;
        @Since(value=1.0)
        protected List<String> admins;

        public FabricServerConfig() {
        }

        public FabricServerConfig(boolean defaultOpAccess, String defaultAdmin) {
            this.opAccess = defaultOpAccess;
            this.admins = new ArrayList<String>();
            this.admins.add(defaultAdmin);
        }

        public static FabricServerConfig fromString(String json) {
            return (FabricServerConfig)GSON.fromJson(json, FabricServerConfig.class);
        }

        public String toJson() {
            return GSON.toJson((Object)this);
        }
    }
}

