/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import journeymap.client.Constants;
import journeymap.client.properties.ClientCategory;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.DraggableListPane;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.ResetButton;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.minimap.Effect;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.ui.minimap.Selectable;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.OptionSlotFactory;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.common.properties.PropertiesBase;
import journeymap.common.properties.catagory.Category;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5481;

public class MinimapOptions
extends JmUI {
    protected Button buttonClose;
    protected Map<Category, List<SlotMetadata>> toolbars;
    protected DraggableListPane<CategorySlot> minimapPositionPane;
    private final MiniMapProperties miniMapProperties;
    private final MiniMap minimap;
    private final Effect effect;
    private Selectable selected;
    private Selectable notSelected;
    private Map<class_1291, class_1293> activeEffects;
    private Map<Category, PropertiesBase> slotMap = Maps.newHashMap();
    private static final Map<class_1291, class_1293> FAKE_EFFECT_MAP;

    public MinimapOptions(class_437 returnDisplay, MiniMapProperties miniMapProperties) {
        super(Constants.getString("jm.common.minimap_options.title"), returnDisplay);
        this.miniMapProperties = miniMapProperties;
        UIManager.INSTANCE.switchMiniMapPreset(miniMapProperties.getId());
        this.minimap = UIManager.INSTANCE.getMiniMap();
        this.effect = Effect.getInstance();
        this.slotMap.put(ClientCategory.MinimapPosition, miniMapProperties);
        this.activeEffects = Maps.newHashMap((Map)class_310.method_1551().field_1724.method_6088());
        class_310.method_1551().field_1724.method_6088().clear();
    }

    @Override
    public void method_25423(class_310 minecraft, int width, int height) {
        super.setRenderBottomBar(true);
        super.method_25423(minecraft, width, height);
        Objects.requireNonNull(this);
        this.minimapPositionPane = new DraggableListPane(this, this.field_22787, 0, 0, 20, 35);
        List<CategorySlot> slotList = OptionSlotFactory.getOptionSlots(this.getToolbars(this.minimapPositionPane), this.slotMap, false, true);
        this.minimapPositionPane.setAlignTop(false);
        this.minimapPositionPane.method_31322(false);
        this.minimapPositionPane.method_31323(false);
        this.minimapPositionPane.setSlots(slotList);
        this.minimapPositionPane.updateSlots();
        this.buttonClose = (Button)this.method_37063((class_364)new Button(Constants.getString("jm.common.close"), button -> this.closeAndReturn()));
        this.buttonClose.fitWidth(minecraft.field_1772);
        this.buttonClose.setX(minecraft.method_22683().method_4486() / 2 - this.buttonClose.method_25368() / 2);
        this.buttonClose.setY(minecraft.method_22683().method_4502() - 25);
    }

    protected Map<Category, List<SlotMetadata>> getToolbars(ScrollListPane<CategorySlot> pane) {
        if (this.toolbars == null) {
            this.toolbars = new HashMap<Category, List<SlotMetadata>>();
            for (Category category : ClientCategory.values) {
                String name = Constants.getString("jm.config.reset");
                String tooltip = Constants.getString("jm.config.reset.tooltip");
                SlotMetadata toolbarSlotMetadata = new SlotMetadata(new ResetButton(category, button -> this.resetOptions(category, pane)), name, tooltip);
                this.toolbars.put(category, Arrays.asList(toolbarSlotMetadata));
            }
        }
        return this.toolbars;
    }

    protected void resetOptions(Category category, ScrollListPane<CategorySlot> pane) {
        HashSet<PropertiesBase> updatedProperties = new HashSet<PropertiesBase>();
        for (CategorySlot categorySlot : pane.getRootSlots()) {
            if (!category.equals(categorySlot.getCategory())) continue;
            for (SlotMetadata slotMetadata : categorySlot.getAllChildMetadata()) {
                slotMetadata.resetToDefaultValue();
                if (!slotMetadata.hasConfigField()) continue;
                PropertiesBase properties = slotMetadata.getProperties();
                if (properties instanceof MiniMapProperties) {
                    this.miniMapProperties.effectTranslateX.setToDefault();
                    this.miniMapProperties.effectTranslateY.setToDefault();
                    this.miniMapProperties.positionX.set(Float.valueOf(0.82f));
                    this.miniMapProperties.positionY.set(Float.valueOf(0.05f));
                }
                this.miniMapProperties.effectTranslateX.set((Object)0);
                if (properties == null) continue;
                updatedProperties.add(properties);
            }
        }
        for (PropertiesBase properties : updatedProperties) {
            properties.save();
        }
        this.minimapPositionPane.updateSlots();
    }

    @Override
    public void method_25394(class_4587 pStack, int x, int y, float partialTicks) {
        this.minimap.drawMap(pStack, true);
        this.renderEffectBox(pStack);
        List lastTooltip = this.minimapPositionPane.lastTooltip;
        long lastTooltipTime = this.minimapPositionPane.lastTooltipTime;
        this.minimapPositionPane.lastTooltip = null;
        this.minimapPositionPane.method_25394(pStack, x, y, partialTicks);
        this.minimap.updateDisplayVars(true);
        super.method_25394(pStack, x, y, partialTicks);
        this.renderTooltip(pStack, x, lastTooltipTime, lastTooltip);
        this.field_22787.field_1724.method_6088().putAll(FAKE_EFFECT_MAP);
    }

    private void renderTooltip(class_4587 pStack, int x, long lastTooltipTime, List<class_5481> lastTooltip) {
        if (this.minimapPositionPane.lastTooltip != null && !this.minimapPositionPane.lastTooltip.equals(lastTooltip)) {
            this.minimapPositionPane.lastTooltipTime = lastTooltipTime;
            if (System.currentTimeMillis() - this.minimapPositionPane.lastTooltipTime > this.minimapPositionPane.hoverDelay) {
                Button button = this.minimapPositionPane.lastTooltipMetadata.getButton();
                this.method_25417(pStack, this.minimapPositionPane.lastTooltip, x, button.getBottomY() + 15);
            }
        }
    }

    private void renderEffectBox(class_4587 pStack) {
        if (this.selected != null && this.notSelected != null) {
            this.selected.renderBorder(pStack, -16711936);
            this.notSelected.renderBorder(pStack, -65536);
        } else {
            this.minimap.renderBorder(pStack, -65536);
            this.effect.renderBorder(pStack, -65536);
        }
        DrawUtil.zLevel = 0.0;
    }

    @Override
    protected void closeAndReturn() {
        this.removeTempEffects();
        super.closeAndReturn();
    }

    public void method_25419() {
        this.removeTempEffects();
        super.method_25419();
    }

    private void removeTempEffects() {
        this.field_22787.field_1724.method_6088().clear();
        this.field_22787.field_1724.method_6088().putAll(this.activeEffects);
    }

    @Override
    protected void layoutButtons(class_4587 mStack) {
        if (this.getRenderables().isEmpty()) {
            this.method_25426();
        }
    }

    @Override
    public void method_25420(class_4587 mStack) {
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (this.minimapPositionPane.method_25402(pMouseX, pMouseY, pButton)) {
            this.minimap.updateDisplayVars(true);
        } else {
            if (this.minimap.mouseClicked(pMouseX, pMouseY, pButton)) {
                this.selected = this.minimap;
                this.notSelected = this.effect;
                return true;
            }
            if (this.effect.mouseClicked(pMouseX, pMouseY, pButton)) {
                this.selected = this.effect;
                this.notSelected = this.minimap;
                return true;
            }
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    public boolean method_25401(double x, double y, double scroll) {
        this.minimapPositionPane.method_25401(x, y, scroll);
        return super.method_25401(x, y, scroll);
    }

    public boolean method_25403(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (!this.minimapPositionPane.method_25403(pMouseX, pMouseY, pButton, pDragX, pDragY) && this.selected != null && this.selected.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY)) {
            return true;
        }
        return super.method_25403(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        this.minimapPositionPane.method_25406(mouseX, mouseY, mouseButton);
        this.minimap.mouseReleased(mouseX, mouseY, mouseButton);
        this.effect.mouseReleased(mouseX, mouseY, mouseButton);
        return super.method_25406(mouseX, mouseY, mouseButton);
    }

    public void method_25393() {
        if (this.selected != null) {
            this.selected.tick();
        }
    }

    static {
        ArrayList fakeEffect = Lists.newArrayList((Object[])new class_1293[]{new class_1293(class_1294.field_5916), new class_1293(class_1294.field_5919), new class_1293(class_1294.field_5899), new class_1293(class_1294.field_5924), new class_1293(class_1294.field_5907), new class_1293(class_1294.field_5923), new class_1293(class_1294.field_5905)});
        FAKE_EFFECT_MAP = fakeEffect.stream().collect(Collectors.toMap(class_1293::method_5579, e -> e));
    }
}

