/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.texture;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.platform.TextureUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import journeymap.client.log.JMLogger;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.task.main.ExpireTextureTask;
import journeymap.client.task.multi.MapPlayerTask;
import journeymap.common.Journeymap;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.lwjgl.BufferUtils;

public class TextureImpl
extends class_1044 {
    protected final ReentrantLock bufferLock = new ReentrantLock();
    protected BufferedImage image;
    protected boolean retainImage;
    protected int width;
    protected int height;
    protected float alpha;
    protected long lastImageUpdate;
    protected long lastBound;
    protected String description;
    protected class_2960 resourceLocation;
    protected List<WeakReference<Listener>> listeners = new ArrayList<WeakReference<Listener>>(0);
    protected Map<Float, TextureImpl> scaledTextureCache = new HashMap<Float, TextureImpl>();
    protected ByteBuffer buffer;
    protected IntBuffer intBuffer;
    protected boolean bindNeeded;

    public TextureImpl(class_2960 resourceLocation) {
        this(null, TextureCache.resolveImage(resourceLocation), false, false);
        this.resourceLocation = resourceLocation;
        this.setDescription(resourceLocation.method_12832());
    }

    public TextureImpl(BufferedImage image) {
        this(null, image, false, true);
    }

    public TextureImpl(BufferedImage image, boolean retainImage) {
        this(null, image, retainImage, true);
    }

    public TextureImpl(Integer glId, BufferedImage image, boolean retainImage) {
        this(glId, image, retainImage, true);
    }

    public TextureImpl(Integer glId, BufferedImage image, boolean retainImage, boolean bindImmediately) {
        if (glId != null) {
            this.field_5204 = glId;
        }
        this.retainImage = retainImage;
        if (image != null) {
            this.setImage(image, retainImage);
        }
        if (bindImmediately) {
            this.method_23207();
            this.buffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(BufferedImage bufferedImage, boolean retainImage) {
        if (bufferedImage == null) {
            return;
        }
        try {
            this.bufferLock.lock();
            this.retainImage = retainImage;
            if (retainImage) {
                this.image = bufferedImage;
            }
            this.width = bufferedImage.getWidth();
            this.height = bufferedImage.getHeight();
            int bufferSize = this.width * this.height * 4;
            if (this.buffer == null || this.buffer.capacity() != bufferSize) {
                this.intBuffer = BufferUtils.createByteBuffer((int)bufferSize).asIntBuffer();
            }
            TextureImpl.loadIntBuffer(bufferedImage, this.intBuffer);
            this.bindNeeded = true;
        }
        finally {
            this.bufferLock.unlock();
        }
        this.lastImageUpdate = System.currentTimeMillis();
        this.notifyListeners();
    }

    public static void loadByteBuffer(BufferedImage bufferedImage, ByteBuffer buffer) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        buffer.clear();
        int[] pixels = new int[width * height];
        bufferedImage.getRGB(0, 0, width, height, pixels, 0, width);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = pixels[y * width + x];
                buffer.put((byte)(pixel >> 16 & 0xFF));
                buffer.put((byte)(pixel >> 8 & 0xFF));
                buffer.put((byte)(pixel & 0xFF));
                buffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        buffer.flip();
    }

    public static IntBuffer loadIntBuffer(BufferedImage bufferedImage, IntBuffer ib) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        ib.clear();
        int[] array = new int[width * height];
        bufferedImage.getRGB(0, 0, width, height, array, 0, width);
        ib.put(array);
        ib.flip();
        return ib;
    }

    public void method_23207() {
        if (!this.bindNeeded) {
            return;
        }
        if (this.bufferLock.tryLock()) {
            if (this.field_5204 > -1) {
                MapPlayerTask.addTempDebugMessage("tex" + this.field_5204, "Updating: " + this.getDescription());
            }
            try {
                int glErr;
                this.field_5204 = super.method_4624();
                RenderWrapper.activeTexture(33984);
                RenderWrapper.bindTextureForSetup(this.field_5204);
                TextureUtil.initTexture((IntBuffer)this.intBuffer, (int)this.width, (int)this.height);
                RenderWrapper.setShaderTexture(0, this.field_5204);
                this.bindNeeded = false;
                while ((glErr = RenderWrapper.getError()) != 0) {
                    JMLogger.logOnce("GL Error in TextureImpl after initTexture: " + glErr + " in " + this, null);
                    this.bindNeeded = true;
                }
                if (!this.bindNeeded) {
                    this.lastBound = System.currentTimeMillis();
                }
            }
            catch (Throwable t) {
                Journeymap.getLogger().warn("Can't bind texture: ", t);
                this.buffer = null;
            }
            finally {
                this.bufferLock.unlock();
            }
        }
    }

    public boolean isBindNeeded() {
        return this.bindNeeded;
    }

    public boolean isBound() {
        return this.field_5204 != -1;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void updateAndBind(BufferedImage image) {
        this.updateAndBind(image, this.retainImage);
    }

    public void updateAndBind(BufferedImage image, boolean retainImage) {
        this.setImage(image, retainImage);
        this.method_23207();
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public BufferedImage getImage() {
        if (this.image != null) {
            return this.image;
        }
        if (this.resourceLocation != null) {
            return TextureCache.resolveImage(this.resourceLocation);
        }
        return null;
    }

    public boolean isDefunct() {
        return this.field_5204 == -1 && this.image == null && this.buffer == null;
    }

    public int method_4624() {
        if (this.bindNeeded) {
            this.method_23207();
        }
        return super.method_4624();
    }

    public int getGlTextureId(boolean forceBind) {
        if (forceBind || this.field_5204 == -1) {
            return this.method_4624();
        }
        return this.field_5204;
    }

    public void clear() {
        this.bufferLock.lock();
        this.buffer = null;
        this.bufferLock.unlock();
        this.image = null;
        this.bindNeeded = false;
        this.lastImageUpdate = 0L;
        this.lastBound = 0L;
        this.field_5204 = -1;
    }

    public void queueForDeletion() {
        ExpireTextureTask.queue(this);
    }

    public long getLastImageUpdate() {
        return this.lastImageUpdate;
    }

    public long getLastBound() {
        return this.lastBound;
    }

    public void method_4625(class_3300 par1ResourceManager) {
        if (this.resourceLocation != null) {
            // empty if block
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("glid", this.field_5204).add("description", (Object)this.description).add("lastImageUpdate", this.lastImageUpdate).add("lastBound", this.lastBound).toString();
    }

    public void close() {
        if (this.isBound()) {
            ExpireTextureTask.queue(this.field_5204);
            super.close();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public TextureImpl getScaledImage(float drawScale) {
        if (drawScale > 1.0f) {
            try {
                if (this.scaledTextureCache.get(Float.valueOf(drawScale)) == null) {
                    int imageWidth = (int)((float)this.getWidth() * drawScale);
                    int imageHeight = (int)((float)this.getHeight() * drawScale);
                    BufferedImage scaledImage = TextureImpl.createBlankImage(imageWidth, imageHeight);
                    Graphics2D g = TextureImpl.initRenderingHints(scaledImage.createGraphics());
                    g.drawImage(this.getImage(), 0, 0, imageWidth, imageHeight, null);
                    g.dispose();
                    TextureImpl image = new TextureImpl(scaledImage);
                    this.scaledTextureCache.put(Float.valueOf(drawScale), image);
                    return image;
                }
            }
            catch (Exception e) {
                return this;
            }
            return this.scaledTextureCache.get(Float.valueOf(drawScale));
        }
        return this;
    }

    public void addListener(Listener addedListener) {
        Iterator<WeakReference<Listener>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            WeakReference<Listener> ref = iter.next();
            Listener listener = (Listener)ref.get();
            if (listener == null) {
                iter.remove();
                continue;
            }
            if (addedListener != listener) continue;
            return;
        }
        this.listeners.add(new WeakReference<Listener>(addedListener));
    }

    protected void notifyListeners() {
        Iterator<WeakReference<Listener>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            WeakReference<Listener> ref = iter.next();
            Listener listener = (Listener)ref.get();
            if (listener == null) {
                iter.remove();
                continue;
            }
            listener.textureImageUpdated(this);
        }
    }

    public static BufferedImage createBlankImage(int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g = TextureImpl.initRenderingHints(img.createGraphics());
        g.setColor(Color.black);
        g.setComposite(AlphaComposite.Clear);
        g.drawImage(img, 0, 0, width, height, null);
        g.dispose();
        return img;
    }

    public static Graphics2D initRenderingHints(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        return g;
    }

    public static interface Listener<T extends TextureImpl> {
        public void textureImageUpdated(T var1);
    }
}

