/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.io.nbt;

import com.mojang.datafixers.DataFixer;
import java.util.Optional;
import journeymap.client.io.nbt.RegionLoader;
import journeymap.client.model.ChunkMD;
import journeymap.common.Journeymap;
import net.minecraft.class_1132;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2802;
import net.minecraft.class_2812;
import net.minecraft.class_2818;
import net.minecraft.class_2821;
import net.minecraft.class_2852;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3977;
import net.minecraft.class_4153;
import net.minecraft.class_4284;
import org.apache.logging.log4j.Logger;

public class JMChunkLoader {
    private static Logger logger = Journeymap.getLogger();

    public static ChunkMD getChunkMD(class_3977 loader, class_310 mc, class_1923 coord, boolean forceRetain) {
        if (RegionLoader.getRegionFile(mc, coord.field_9181, coord.field_9180).exists()) {
            class_1132 integratedServer = mc.method_1576();
            class_3218 serverWorld = integratedServer.method_3847(mc.field_1724.field_6002.method_27983());
            class_2818 chunk = JMChunkLoader.getChunkFromRegion(serverWorld, coord, loader);
            if (chunk != null) {
                chunk.method_12226(true);
                return new ChunkMD(chunk, forceRetain);
            }
        } else {
            logger.warn("Region doesn't exist for chunk: " + coord);
        }
        return null;
    }

    private static class_2818 getChunkFromRegion(class_3218 world, class_1923 coord, class_3977 loader) {
        try {
            class_2487 nbt = (class_2487)((Optional)loader.method_23696(coord).get()).get();
            if (nbt != null) {
                DataFixer fixer = class_310.method_1551().method_1543();
                int dataVersion = class_3977.method_17908((class_2487)nbt);
                nbt = class_2512.method_10688((DataFixer)fixer, (class_4284)class_4284.field_19214, (class_2487)nbt, (int)dataVersion);
                class_2821 primer = (class_2821)class_2852.method_12395((class_3218)world, (class_4153)world.method_19494(), (class_1923)coord, (class_2487)nbt);
                class_2818 chunk = primer.method_12240();
                return chunk;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ChunkMD getChunkMdFromMemory(class_1937 world, int chunkX, int chunkZ) {
        class_2802 provider;
        if (world != null && (provider = world.method_8398()) != null) {
            class_2818 theChunk = world.method_8497(chunkX, chunkZ);
            theChunk.method_12226(true);
            if (theChunk != null && theChunk.field_12855 && !(theChunk instanceof class_2812)) {
                return new ChunkMD(theChunk);
            }
        }
        return null;
    }
}

