/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography.render;

import java.awt.image.BufferedImage;
import journeymap.client.cartography.IChunkRenderer;
import journeymap.client.cartography.color.RGB;
import journeymap.client.cartography.render.SurfaceRenderer;
import journeymap.client.log.StatTimer;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.MapType;
import journeymap.client.render.ComparableBufferedImage;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.nbt.RegionData;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import org.apache.logging.log4j.Level;

public class BiomeRenderer
extends SurfaceRenderer
implements IChunkRenderer {
    private static final String DEFAULT_LAND_CONTOUR_COLOR = "#3F250B";
    protected StatTimer renderTopoTimer = StatTimer.get("BiomeRenderer.renderSurface");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean render(ComparableBufferedImage chunkImage, RegionData regionData, ChunkMD chunkMd, Integer vSlice) {
        StatTimer timer = this.renderTopoTimer;
        try {
            timer.start();
            this.updateOptions(chunkMd, MapType.from(MapType.Name.biome, null, chunkMd.getDimension()));
            boolean bl = this.renderSurface(chunkImage, regionData, chunkMd, vSlice, false);
            return bl;
        }
        catch (Throwable e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            timer.stop();
        }
    }

    protected boolean renderSurface(BufferedImage chunkImage, RegionData regionData, ChunkMD chunkMd, Integer vSlice, boolean cavePrePass) {
        boolean chunkOk = false;
        try {
            class_2487 chunkNbt = regionData.getChunkNbt(chunkMd.getCoord());
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    class_2487 blockNbt = regionData.getBlockDataFromBlockPos(chunkMd.getCoord(), chunkNbt, x, z);
                    BlockMD topBlockMd = null;
                    int y = Math.max(0, this.getBlockHeight(chunkMd, x, null, z, null, null));
                    topBlockMd = chunkMd.getBlockMD(x, y, z);
                    if (topBlockMd == null) {
                        this.paintBadBlock(chunkImage, x, y, z);
                        continue;
                    }
                    chunkOk = this.paintBiome(chunkImage, regionData, blockNbt, chunkMd, topBlockMd, x, y, z) || chunkOk;
                }
            }
            regionData.writeChunk(chunkMd.getCoord(), chunkNbt);
        }
        catch (Throwable t) {
            Journeymap.getLogger().log(Level.WARN, "Error in renderSurface: " + LogFormatter.toString(t));
        }
        return chunkOk;
    }

    private boolean paintBiome(BufferedImage chunkImage, RegionData regionData, class_2487 blockNbt, ChunkMD chunkMd, BlockMD topBlockMd, int x, int y, int z) {
        if (!chunkMd.hasChunk()) {
            return false;
        }
        class_2338 blockPos = chunkMd.getBlockPos(x, y, z);
        class_1959 biome = chunkMd.getBiome(blockPos);
        if (biome == null) {
            return false;
        }
        try {
            boolean isWater = topBlockMd.isWater() || topBlockMd.isIce();
            boolean isFoliage = topBlockMd.isFoliage();
            int contourColor = RGB.hexToInt(DEFAULT_LAND_CONTOUR_COLOR);
            Integer color = this.isBiomeEdge(chunkMd, blockPos, biome) ? Integer.valueOf(contourColor) : (topBlockMd.isLava() ? Integer.valueOf(topBlockMd.getTextureColor()) : (isWater ? Integer.valueOf(biome.method_8687()) : (isFoliage ? Integer.valueOf(biome.method_8698()) : Integer.valueOf(biome.method_8711((double)chunkMd.getCoord().field_9181, (double)chunkMd.getCoord().field_9180)))));
            int blockColor = this.paintBlock(chunkImage, x, z, color);
            regionData.setBlockColor(blockNbt, blockColor, MapType.Name.biome);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean isBiomeEdge(ChunkMD chunkMD, class_2338 pos, class_1959 blockBiome) {
        return false;
    }
}

