/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography.color;

import java.awt.image.BufferedImage;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.render.texture.TextureCache;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_777;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class ColoredSprite {
    private static Logger logger = Journeymap.getLogger();
    private final Integer color;
    private final class_1058 sprite;

    public ColoredSprite(class_1058 sprite, @Nullable Integer color) {
        this.sprite = sprite;
        this.color = null;
    }

    public ColoredSprite(class_777 quad) {
        this.sprite = quad.method_35788();
        this.color = null;
    }

    public String getIconName() {
        return this.sprite.method_4598().method_12832();
    }

    @Nullable
    public Integer getColor() {
        return this.color;
    }

    public boolean hasColor() {
        return this.color != null;
    }

    @Nullable
    public BufferedImage getColoredImage() {
        try {
            class_2960 resourceLocation = new class_2960(this.getIconName());
            if (resourceLocation.equals((Object)new class_2960("missingno"))) {
                return null;
            }
            BufferedImage image = this.getFrameTextureData(this.sprite);
            if (image == null || image.getWidth() == 0) {
                image = this.getImageResource(this.sprite);
            }
            if (image == null || image.getWidth() == 0) {
                return null;
            }
            return this.applyColor(image);
        }
        catch (Throwable e1) {
            if (logger.isDebugEnabled()) {
                logger.error("ColoredSprite: Error getting image for " + this.getIconName() + ": " + LogFormatter.toString(e1));
            }
            return null;
        }
    }

    private BufferedImage getFrameTextureData(class_1058 tas) {
        try {
            int[] rgb;
            if (tas.method_4592() > 0 && (rgb = tas.field_5262[0].method_4322()).length > 0) {
                int width = tas.method_4578();
                int height = tas.method_4595();
                BufferedImage textureImg = new BufferedImage(width, height, 2);
                textureImg.setRGB(0, 0, width, height, rgb, 0, width);
                return textureImg;
            }
        }
        catch (Throwable t) {
            logger.error(String.format("ColoredSprite: Unable to use frame data for %s: %s", tas.method_4598().method_12832(), t.getMessage()));
        }
        return null;
    }

    private BufferedImage getImageResource(class_1058 tas) {
        try {
            class_2960 iconNameLoc = new class_2960(tas.method_4598().method_12832());
            class_2960 fileLoc = new class_2960(iconNameLoc.method_12836(), "textures/" + iconNameLoc.method_12832() + ".png");
            return TextureCache.resolveImage(fileLoc);
        }
        catch (Throwable t) {
            logger.error(String.format("ColoredSprite: Unable to use texture file for %s: %s", tas.method_4598().method_12832(), t.getMessage()));
            return null;
        }
    }

    private BufferedImage applyColor(BufferedImage original) {
        return original;
    }
}

